/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.presentation.headline.ui;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.rmf.pror.reqif10.editor.presentation.service.IProrCellRenderer;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueSimple;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class HeadlineCellRenderer
implements IProrCellRenderer {
    private String fontHandle = "pror_headline_font-";
    private Font font;
    private int fontSize;
    private boolean fontSizeChanged = false;

    public HeadlineCellRenderer(String identifier) {
        this.fontHandle = "pror_headline_font-" + identifier;
    }

    public void setDatatypeId(String identifier) {
        this.fontHandle = "pror_headline_font-" + identifier;
        this.setFontSize(this.fontSize);
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.fontSizeChanged = true;
    }

    public int doDrawCellContent(GC gc, Rectangle rect, Object value) {
        AttributeValueSimple av = (AttributeValueSimple)value;
        String text = " ";
        if (av != null && ReqIF10Util.getTheValue((AttributeValue)av) != null) {
            text = ReqIF10Util.getTheValue((AttributeValue)av).toString();
        }
        if (this.font == null || this.font.isDisposed() || this.fontSizeChanged) {
            FontRegistry fr = JFaceResources.getFontRegistry();
            FontData[] fontData = new FontData[]{new FontData("Arial", this.fontSize, 1)};
            fr.put(String.valueOf(this.fontHandle) + this, fontData);
            this.font = fr.get(String.valueOf(this.fontHandle) + this);
            this.fontSizeChanged = false;
        }
        gc.setFont(this.font);
        gc.drawText(text, rect.x, rect.y);
        return gc.textExtent((String)text).y;
    }

    public String doDrawHtmlContent(AttributeValue value) {
        AttributeValueSimple av = (AttributeValueSimple)value;
        return "<div style='font-size: " + this.fontSize + "pt; font-weight: bold; padding-top: 4pt;'>" + ReqIF10Util.getTheValue((AttributeValue)av) + "</div>";
    }
}

