/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.presentation.id.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.rmf.pror.reqif10.configuration.ConfigurationPackage;
import org.eclipse.rmf.pror.reqif10.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.pror.reqif10.configuration.provider.ProrPresentationConfigurationItemProvider;
import org.eclipse.rmf.pror.reqif10.presentation.id.IdConfiguration;
import org.eclipse.rmf.pror.reqif10.presentation.id.IdPackage;
import org.eclipse.rmf.pror.reqif10.presentation.id.provider.IDEditPlugin;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdConfigurationItemProvider
extends ProrPresentationConfigurationItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private EContentAdapter contentAdapter;

    public IdConfigurationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPrefixPropertyDescriptor(object);
            this.addCountPropertyDescriptor(object);
            this.addVerticalAlignPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPrefixPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IdConfiguration_prefix_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IdConfiguration_prefix_feature", "_UI_IdConfiguration_type"), (EStructuralFeature)IdPackage.Literals.ID_CONFIGURATION__PREFIX, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IdConfiguration_count_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IdConfiguration_count_feature", "_UI_IdConfiguration_type"), (EStructuralFeature)IdPackage.Literals.ID_CONFIGURATION__COUNT, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addVerticalAlignPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IdConfiguration_verticalAlign_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IdConfiguration_verticalAlign_feature", "_UI_IdConfiguration_type"), (EStructuralFeature)IdPackage.Literals.ID_CONFIGURATION__VERTICAL_ALIGN, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return super.getImage(object);
    }

    public String getText(Object object) {
        IdConfiguration idConfiguration = (IdConfiguration)object;
        if (idConfiguration.getDatatype() == null) {
            return this.getString("_UI_IdConfiguration_type_not_set");
        }
        return this.getString("_UI_IdConfiguration_type", new Object[]{idConfiguration.getDatatype().getLongName(), idConfiguration.getCount()});
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(IdConfiguration.class)) {
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return IDEditPlugin.INSTANCE;
    }

    public void registerPresentationConfiguration(final ProrPresentationConfiguration config, final EditingDomain editingDomain) {
        this.registerModelListener((IdConfiguration)config, editingDomain);
        config.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeature() == ConfigurationPackage.Literals.PROR_PRESENTATION_CONFIGURATION__DATATYPE) {
                    IdConfigurationItemProvider.this.unregisterModelListener(config);
                    IdConfigurationItemProvider.this.registerModelListener((IdConfiguration)config, editingDomain);
                }
            }
        });
    }

    public void unregisterPresentationConfiguration(ProrPresentationConfiguration config) {
        this.unregisterModelListener(config);
    }

    private void registerModelListener(final IdConfiguration config, final EditingDomain editingDomain) {
        if (this.contentAdapter != null) {
            throw new IllegalStateException("Cannot register IDConfigAdapter without unregistering first!");
        }
        this.contentAdapter = new EContentAdapter(){

            public void setTarget(Notifier target) {
                AttributeValueString value;
                super.setTarget(target);
                if (target instanceof AttributeValueString && (value = (AttributeValueString)target).getDefinition() != null && value.getDefinition().getType() != null && value.getDefinition().getType().equals(config.getDatatype()) && (value.getTheValue() == null || value.getTheValue().length() == 0)) {
                    int newCount = config.getCount() + 1;
                    String label = "Assigning ID " + config.getPrefix() + newCount;
                    Command redoCommand = editingDomain.getCommandStack().getRedoCommand();
                    if (redoCommand != null && label.equals(redoCommand.getLabel())) {
                        System.out.println("Detected Undo - skip " + label);
                        return;
                    }
                    CompoundCommand cmd = new CompoundCommand(label);
                    cmd.append(SetCommand.create((EditingDomain)editingDomain, (Object)value, (Object)ReqIF10Package.Literals.ATTRIBUTE_VALUE_STRING__THE_VALUE, (Object)(String.valueOf(config.getPrefix()) + newCount)));
                    cmd.append(SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)IdPackage.Literals.ID_CONFIGURATION__COUNT, (Object)newCount));
                    editingDomain.getCommandStack().execute((Command)cmd);
                }
            }
        };
        ReqIF10Util.getReqIF((Object)config).getCoreContent().eAdapters().add((Object)this.contentAdapter);
    }

    private void unregisterModelListener(ProrPresentationConfiguration config) {
        if (this.contentAdapter != null) {
            ReqIF10Util.getReqIF((Object)config).getCoreContent().eAdapters().remove((Object)this.contentAdapter);
            this.contentAdapter = null;
        }
    }

    public Command handleDragAndDrop(Collection<?> source, Object target, EditingDomain editingDomain, int operation) {
        return null;
    }

    public String getLabel(AttributeValue av) {
        return null;
    }

    public boolean canEdit() {
        return false;
    }
}

