/*******************************************************************************
 * Copyright (c) 2011 Formal Mind GmbH and University of Dusseldorf.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Michael Jastram - initial API and implementation
 ******************************************************************************/
package org.eclipse.rmf.pror.presentation.ui;

import org.eclipse.rmf.pror.presentation.linewrap.LinewrapFactory;
import org.eclipse.rmf.pror.reqif10.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.pror.reqif10.edit.presentation.service.PresentationInterface;
import org.eclipse.rmf.pror.reqif10.editor.presentation.service.AbstractPresentationService;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;

/**
 * A very basic Presentation that handles {@link DatatypeDefinitionString}s and
 * wraps them in the Labels and Editors.
 * 
 * @author jastram
 * 
 */
public class LinewrapPresentationService extends AbstractPresentationService implements PresentationInterface {

	public LinewrapPresentationService() {
	}

	@Override
	public ProrPresentationConfiguration getConfigurationInstance() {
		return LinewrapFactory.eINSTANCE.createLinewrapConfiguration();
	}

}
