/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.internal.serialization;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.rmf.internal.serialization.IReqIFSerializationConstants;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReqIFXMLSAXHandler
extends SAXXMLHandler
implements IReqIFSerializationConstants {
    private static final int OUT_OF_XHTML = -1;
    private IReqIFSerializationConstants.SerializationStrategy serializationStrategy = IReqIFSerializationConstants.SerializationStrategy.REQIF;
    private String previousElement = "";
    private int previousLevel = -1;
    int xhtmlLevel = -1;
    int toolExtensionsLevel = -1;
    protected XMLHandler.MyStack<EStructuralFeature> deferredFeatures = new XMLHandler.MyStack();
    protected int level = 0;

    public ReqIFXMLSAXHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
        super(xmiResource, helper, options);
    }

    public void reset() {
        super.reset();
        this.deferredFeatures.clear();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.previousLevel = this.level++;
        super.startElement(uri, localName, qName, attributes);
        this.previousElement = qName;
    }

    protected void processElement(String name, String prefix, String localName) {
        if (IReqIFSerializationConstants.SerializationStrategy.REQIF == this.serializationStrategy || IReqIFSerializationConstants.SerializationStrategy.TOOL_EXTENSION == this.serializationStrategy) {
            if (this.isRoot) {
                this.isRoot = false;
                this.recordHeaderInformation();
            }
            if (this.isError()) {
                this.types.push((Object)"error");
            } else if (this.objects.isEmpty()) {
                this.createTopObject(prefix, localName);
            } else if (this.isFeatureExpected()) {
                this.handleFeature(prefix, localName);
            } else if (localName.endsWith("-REF")) {
                this.handleReference(prefix, localName.substring(0, localName.length() - 4));
            } else {
                this.handleObject(prefix, localName);
            }
        } else {
            super.processElement(name, prefix, localName);
        }
    }

    protected void createObject(EObject peekObject, EStructuralFeature feature) {
        super.createObject(peekObject, feature);
    }

    protected void handleReference(String prefix, String localName) {
        this.handleObject(prefix, localName);
        this.text = new StringBuffer();
    }

    protected void handleProxy(InternalEObject proxy, String uriLiteral) {
        URI resourceURI = this.xmlResource.getURI();
        URI proxyURI = resourceURI == null ? URI.createURI((String)("#" + uriLiteral)) : resourceURI.appendFragment(uriLiteral);
        proxy.eSetProxyURI(proxyURI);
    }

    protected void handleObject(String prefix, String localName) {
        assert (this.deferredFeatures.peek() != null);
        EObject peekObject = this.objects.peekEObject();
        assert (peekObject != null);
        EFactory eFactory = this.getFactoryForPrefix(prefix);
        if (eFactory == null && prefix.equals("") && this.helper.getURI(prefix) == null) {
            EPackage ePackage = this.handleMissingPackage(null);
            if (ePackage == null) {
                this.error((XMIException)new PackageNotFoundException(null, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
            } else {
                eFactory = ePackage.getEFactoryInstance();
            }
        }
        EObject obj = this.createObject(eFactory, this.helper.getType(eFactory, localName), false);
        if (this.deferredFeatures.peek() == null) {
            this.deferredFeatures.pop();
            EStructuralFeature feature = this.getFeature(peekObject, obj.eClass().getEPackage().getNsPrefix(), "root", true);
            this.deferredFeatures.push((Object)feature);
        }
        if ((obj = this.validateCreateObjectFromFactory(eFactory, localName, obj, (EStructuralFeature)this.deferredFeatures.peek())) != null) {
            this.setFeatureValue(peekObject, (EStructuralFeature)this.deferredFeatures.peek(), obj);
        }
        if (obj.eClass().equals(ReqIF10Package.eINSTANCE.getReqIFToolExtension())) {
            this.serializationStrategy = IReqIFSerializationConstants.SerializationStrategy.TOOL_EXTENSION;
            this.deferredFeatures.push(null);
            this.toolExtensionsLevel = this.level;
        }
        this.processObject(obj);
    }

    protected void handleFeature(String prefix, String name) {
        if (IReqIFSerializationConstants.SerializationStrategy.REQIF == this.serializationStrategy || IReqIFSerializationConstants.SerializationStrategy.TOOL_EXTENSION == this.serializationStrategy) {
            EObject peekObject = this.objects.peekEObject();
            if (peekObject == null) {
                this.types.push((Object)"error");
                this.error((XMIException)new FeatureNotFoundException(name, null, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                return;
            }
            EStructuralFeature feature = this.getFeature(peekObject, prefix, name, true);
            if (feature != null) {
                this.deferredFeatures.push((Object)feature);
                int kind = this.helper.getFeatureKind(feature);
                if (kind == 1 || kind == 2) {
                    this.objects.push(null);
                    this.mixedTargets.push(null);
                    this.types.push((Object)feature);
                    if (!this.isNull()) {
                        this.text = new StringBuffer();
                    }
                } else if (this.extendedMetaData != null) {
                    EReference eReference = (EReference)feature;
                    boolean isContainment = eReference.isContainment();
                    if (!isContainment && !eReference.isResolveProxies() && this.extendedMetaData.getFeatureKind(feature) != 0) {
                        this.isIDREF = true;
                        this.objects.push(null);
                        this.mixedTargets.push(null);
                        this.types.push((Object)feature);
                        this.text = new StringBuffer();
                    } else if (feature == ReqIF10Package.eINSTANCE.getAttributeValueXHTML_TheValue() || feature == ReqIF10Package.eINSTANCE.getAttributeValueXHTML_TheOriginalValue()) {
                        this.createObject(peekObject, feature);
                        this.serializationStrategy = IReqIFSerializationConstants.SerializationStrategy.XHTML;
                        this.xhtmlLevel = this.level;
                    } else {
                        this.objects.push((Object)peekObject);
                        this.types.push((Object)"object");
                    }
                } else assert (false);
            } else {
                this.handleUnknownFeature(prefix, name, true, peekObject, null);
            }
        } else {
            super.handleFeature(prefix, name);
        }
    }

    public void endElement(String uri, String localName, String name) {
        if ((IReqIFSerializationConstants.SerializationStrategy.REQIF == this.serializationStrategy || IReqIFSerializationConstants.SerializationStrategy.TOOL_EXTENSION == this.serializationStrategy) && this.isEmptyFeature(uri, localName, name)) {
            this.setFeatureValue((EObject)this.objects.peek(), (EStructuralFeature)this.deferredFeatures.peek(), null, -2);
        }
        super.endElement(uri, localName, name);
        if (IReqIFSerializationConstants.SerializationStrategy.TOOL_EXTENSION == this.serializationStrategy && this.level - 1 <= this.toolExtensionsLevel) {
            this.serializationStrategy = IReqIFSerializationConstants.SerializationStrategy.REQIF;
            if (this.isFeatureExpected()) {
                this.deferredFeatures.pop();
            }
        } else if (IReqIFSerializationConstants.SerializationStrategy.REQIF == this.serializationStrategy || IReqIFSerializationConstants.SerializationStrategy.TOOL_EXTENSION == this.serializationStrategy) {
            if (this.isFeatureExpected()) {
                this.deferredFeatures.pop();
            }
        } else if (IReqIFSerializationConstants.SerializationStrategy.XHTML == this.serializationStrategy && this.level - 1 <= this.xhtmlLevel) {
            this.serializationStrategy = IReqIFSerializationConstants.SerializationStrategy.REQIF;
            if (this.level - 1 < this.xhtmlLevel && this.isFeatureExpected()) {
                this.deferredFeatures.pop();
            }
        }
        this.previousLevel = this.level--;
        this.previousElement = name;
    }

    protected boolean isEmptyFeature(String uri, String localName, String name) {
        EStructuralFeature feature;
        if (name.equals(this.previousElement) && this.previousLevel + 1 == this.level && this.isFeatureExpected() && (feature = (EStructuralFeature)this.deferredFeatures.peek()) != null && feature instanceof EReference) {
            EReference reference = (EReference)feature;
            return reference.isContainment();
        }
        return false;
    }

    protected boolean isFeatureExpected() {
        if (IReqIFSerializationConstants.SerializationStrategy.REQIF == this.serializationStrategy) {
            return this.level % 2 == 0;
        }
        return this.level % 2 != 0;
    }

    protected void handleObjectAttribs(EObject obj) {
        if (this.attribs != null) {
            InternalEObject internalEObject = (InternalEObject)obj;
            int i = 0;
            int size = this.attribs.getLength();
            while (i < size) {
                String name = this.attribs.getQName(i);
                if (name.equals(this.idAttribute)) {
                    this.xmlResource.setID((EObject)internalEObject, this.attribs.getValue(i));
                } else if (name.equals(this.hrefAttribute) && (!this.recordUnknownFeature || this.types.peek() != "unknownFeature" || obj.eClass() != this.anyType)) {
                    this.handleProxy(internalEObject, this.attribs.getValue(i));
                } else if (!name.startsWith("xmlns") && !this.notFeatures.contains(name)) {
                    this.setAttribValue(obj, name, this.attribs.getValue(i));
                }
                ++i;
            }
        }
    }

    protected void setAttribValue(EObject object, String name, String value) {
        if (IReqIFSerializationConstants.SerializationStrategy.REQIF != this.serializationStrategy && IReqIFSerializationConstants.SerializationStrategy.TOOL_EXTENSION != this.serializationStrategy) {
            super.setAttribValue(object, name, value);
        } else {
            EStructuralFeature feature;
            int index = name.indexOf(58, 0);
            String prefix = null;
            String localName = name;
            if (index != -1) {
                prefix = name.substring(0, index);
                localName = name.substring(index + 1);
            }
            if ((feature = this.getFeature(object, prefix, localName, false)) == null) {
                this.handleUnknownFeature(prefix, localName, false, object, value);
            } else {
                int kind = this.helper.getFeatureKind(feature);
                if (kind == 1 || kind == 2) {
                    this.setFeatureValue(object, feature, value, -2);
                } else {
                    this.setValueFromId(object, (EReference)feature, value);
                }
            }
        }
    }
}

