/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.EditorActivationEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;

public class EditorActivationStrategy {
    private AgileGrid agileGrid;
    private KeyListener keyboardActivationListener;

    public EditorActivationStrategy(AgileGrid agileGrid) {
        this(agileGrid, true);
    }

    public EditorActivationStrategy(AgileGrid agileGrid, boolean keyboardActivation) {
        this.agileGrid = agileGrid;
        this.setEnableEditorActivationWithKeyboard(keyboardActivation);
    }

    protected boolean isEditorActivationEvent(EditorActivationEvent event) {
        if (event.eventType == 3 && ((MouseEvent)event.sourceEvent).button == 1) {
            return true;
        }
        if (event.eventType == 4 || event.eventType == 5) {
            return true;
        }
        if (event.sourceEvent.getClass() == KeyEvent.class) {
            KeyEvent keyEvent = (KeyEvent)event.sourceEvent;
            switch (keyEvent.character) {
                case '\b': 
                case '\r': 
                case ' ': 
                case '\u007f': {
                    return true;
                }
            }
            if ((Character.isLetterOrDigit(keyEvent.character) || keyEvent.keyCode == 0x100000B || keyEvent.keyCode > 32 && keyEvent.keyCode < 254 && keyEvent.keyCode != 127) && keyEvent.keyCode != 262144 && keyEvent.keyCode != 65536 && (keyEvent.stateMask & 0x40000) == 0 && (keyEvent.stateMask & 0x10000) == 0) {
                return true;
            }
        }
        return false;
    }

    protected Cell getFocusCell() {
        return this.agileGrid.getFocusCell();
    }

    public AgileGrid getAgileGrid() {
        return this.agileGrid;
    }

    public void setEnableEditorActivationWithKeyboard(boolean enable) {
        if (enable) {
            if (this.keyboardActivationListener == null) {
                this.keyboardActivationListener = new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        Cell cell = EditorActivationStrategy.this.getFocusCell();
                        if (cell != null) {
                            EditorActivationStrategy.this.agileGrid.triggerEditorActivationEvent(new EditorActivationEvent(cell, null, e), null);
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                };
                this.agileGrid.addKeyListener(this.keyboardActivationListener);
            }
        } else if (this.keyboardActivationListener != null) {
            this.agileGrid.removeKeyListener(this.keyboardActivationListener);
            this.keyboardActivationListener = null;
        }
    }
}

