/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.editors;

import java.text.MessageFormat;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ComboBoxCellEditor
extends CellEditor {
    private String[] items;
    protected int selection;
    private CCombo combo;
    private static final int defaultStyle = 0;
    private Cursor arrowCursor = new Cursor((Device)Display.getDefault(), 0);

    public ComboBoxCellEditor(AgileGrid agileGrid) {
        super(agileGrid, 0);
    }

    public ComboBoxCellEditor(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
    }

    public ComboBoxCellEditor(AgileGrid agileGrid, String[] items, int style) {
        super(agileGrid, style);
        this.setItems(items);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        this.items = items;
        this.populateComboBoxItems();
    }

    protected Control createControl(AgileGrid agileGrid) {
        this.combo = new CCombo((Composite)agileGrid, this.getStyle());
        this.combo.setFont(agileGrid.getFont());
        this.populateComboBoxItems();
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent e) {
                ComboBoxCellEditor.this.selection = ComboBoxCellEditor.this.combo.getSelectionIndex();
            }
        });
        this.combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxCellEditor.this.focusLost();
            }
        });
        return this.combo;
    }

    protected Object doGetValue() {
        return this.combo.getText();
    }

    protected void doSetValue(Object value) {
        if (value instanceof Integer) {
            this.selection = (Integer)value;
            this.combo.select(this.selection);
        } else if (value instanceof String) {
            this.setSelectionToClosestMatch((String)value);
        } else {
            this.setSelectionToClosestMatch(value.toString());
        }
    }

    private void populateComboBoxItems() {
        if (this.combo != null && this.items != null) {
            this.combo.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.combo.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    protected void applyEditorValueAndDeactivate() {
        this.selection = this.combo.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            if (this.items.length > 0 && this.selection >= 0 && this.selection < this.items.length) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.combo.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void onKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void onTraverse(TraverseEvent e) {
        switch (e.keyCode) {
            case 0x1000001: 
            case 0x1000002: {
                break;
            }
            default: {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                    break;
                }
                super.onTraverse(e);
            }
        }
    }

    private void setSelectionToClosestMatch(String content) {
        content = content.toLowerCase();
        String[] citems = this.combo.getItems();
        String[] items = new String[citems.length];
        int i = 0;
        while (i < citems.length) {
            items[i] = citems[i].toLowerCase();
            ++i;
        }
        int length = content.length();
        while (length >= 0) {
            String part = content.substring(0, length);
            int i2 = 0;
            while (i2 < items.length) {
                if (items[i2].startsWith(part)) {
                    this.combo.select(i2);
                    return;
                }
                ++i2;
            }
            --length;
        }
    }

    public void dispose() {
        if (this.arrowCursor != null) {
            this.arrowCursor.dispose();
            this.arrowCursor = null;
        }
        super.dispose();
    }
}

