/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.CellDoubleClickEvent;
import org.agilemore.agilegrid.CellResizeAdapter;
import org.agilemore.agilegrid.EditorActivationStrategy;
import org.agilemore.agilegrid.ICellDoubleClickListener;
import org.agilemore.agilegrid.ICellEditorProvider;
import org.agilemore.agilegrid.ICellRendererProvider;
import org.agilemore.agilegrid.ICellResizeListener;
import org.agilemore.agilegrid.IContentProvider;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.agilemore.agilegrid.ISelectionChangedListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rmf.reqif10.Identifiable;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.configuration.Column;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationPackage;
import org.eclipse.rmf.reqif10.pror.configuration.ProrSpecViewConfiguration;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.AgileCellEditorActionHandler;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrAgileGrid;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrAgileGridContentProvider;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrCellEditorProvider;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrCellRendererProvider;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrLayoutAdvisor;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrRow;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class ProrAgileGridViewer
extends Viewer {
    private final ProrAgileGrid agileGrid;
    private Specification specification;
    private ProrSpecViewConfiguration specViewConfig;
    private ProrAgileGridContentProvider contentProvider;
    private final EditingDomain editingDomain;
    private IStructuredSelection selection;
    private ISelectionChangedListener selectionChangedistener;
    private EContentAdapter specHierarchyRootContentAdapter;
    private Adapter emfColumnListener;
    private ICellResizeListener agColumnListener;
    private ICellDoubleClickListener doubleClickListener;
    private boolean settingSelection = false;
    protected SpecHierarchy dragTarget;
    private EContentAdapter specRelationContentAdapter;
    private AdapterFactory adapterFactory;
    private AgileCellEditorActionHandler agileCellEditorActionHandler;

    public ProrAgileGridViewer(Composite composite, AdapterFactory adapterFactory, EditingDomain editingDomain, AgileCellEditorActionHandler agileCellEditorActionHandler) {
        this.agileGrid = new ProrAgileGrid(composite, 0x20020302);
        this.agileGrid.setLayoutAdvisor((ILayoutAdvisor)new ProrLayoutAdvisor(this.agileGrid));
        this.agileGrid.setEditorActivationStrategy(new EditorActivationStrategy((AgileGrid)this.agileGrid, true));
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.agileCellEditorActionHandler = agileCellEditorActionHandler;
        this.enableDragNDrop();
        this.enableKeyHandling();
    }

    private void enableKeyHandling() {
        this.agileGrid.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && (e.keyCode == 13 || e.keyCode == 0x1000050)) {
                    e.doit = false;
                    if (ProrAgileGridViewer.this.selection.isEmpty()) {
                        return;
                    }
                    Object obj = ProrAgileGridViewer.this.selection.getFirstElement();
                    if (!(obj instanceof SpecHierarchy)) {
                        return;
                    }
                    SpecHierarchy specHierarchy = (SpecHierarchy)obj;
                    if (specHierarchy.getObject() == null) {
                        return;
                    }
                    ProrAgileGridViewer.this.insertNewRowAndEdit(specHierarchy);
                }
            }
        });
    }

    private void insertNewRowAndEdit(SpecHierarchy specHierarchy) {
        int pos;
        EReference childFeature;
        if (specHierarchy.getObject() == null || specHierarchy.getObject().getType() == null) {
            return;
        }
        SpecHierarchy newSpecHierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
        SpecObject newSpecObject = ReqIF10Factory.eINSTANCE.createSpecObject();
        newSpecHierarchy.setObject(newSpecObject);
        EObject parent = specHierarchy.eContainer();
        if (parent instanceof SpecHierarchy) {
            childFeature = ReqIF10Package.Literals.SPEC_HIERARCHY__CHILDREN;
            pos = ((SpecHierarchy)specHierarchy.eContainer()).getChildren().indexOf((Object)specHierarchy) + 1;
        } else if (parent instanceof Specification) {
            childFeature = ReqIF10Package.Literals.SPECIFICATION__CHILDREN;
            pos = ((Specification)specHierarchy.eContainer()).getChildren().indexOf((Object)specHierarchy) + 1;
        } else {
            throw new IllegalStateException("Wrong parent: " + parent);
        }
        CompoundCommand cmd = ProrUtil.createAddTypedElementCommand((Object)ReqIF10Util.getReqIF((Object)specHierarchy).getCoreContent(), (EReference)ReqIF10Package.Literals.REQ_IF_CONTENT__SPEC_OBJECTS, (Identifiable)newSpecObject, (EReference)ReqIF10Package.Literals.SPEC_OBJECT__TYPE, (SpecType)specHierarchy.getObject().getType(), (int)-1, (int)0, (EditingDomain)this.editingDomain, (AdapterFactory)this.adapterFactory);
        cmd.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)specHierarchy.eContainer(), (Object)childFeature, (Object)newSpecHierarchy, (int)pos));
        this.editingDomain.getCommandStack().execute((Command)cmd);
        Cell activeCell = this.agileGrid.getCellSelection()[0];
        int row = activeCell.row + 1;
        ProrRow.ProrRowSpecHierarchy prorRowSpecHierarchy = (ProrRow.ProrRowSpecHierarchy)this.contentProvider.getProrRow(row);
        while (prorRowSpecHierarchy.getSpecHierarchy() != newSpecHierarchy && row <= this.contentProvider.getRowCount()) {
            ++row;
        }
        this.agileGrid.editCell(row, activeCell.column);
    }

    public Control getControl() {
        return this.agileGrid;
    }

    public Object getInput() {
        return this.specification;
    }

    public ISelection getSelection() {
        return this.selection != null ? this.selection : StructuredSelection.EMPTY;
    }

    public void refresh() {
        this.agileGrid.redraw();
    }

    public void setInput(Object input) {
        this.unregisterColumnListener();
        this.unregisterSelectionChangedListener();
        this.unregisterSpecHierarchyListener();
        this.unregisterSpecRelationListener();
        this.unregisterDoubleClickListener();
        this.specification = (Specification)input;
        this.specViewConfig = ConfigurationUtil.createSpecViewConfiguration((Specification)this.specification, (EditingDomain)this.editingDomain);
        this.contentProvider = new ProrAgileGridContentProvider(this.specification, this.specViewConfig);
        this.agileGrid.setContentProvider((IContentProvider)this.contentProvider);
        this.agileGrid.setCellRendererProvider((ICellRendererProvider)new ProrCellRendererProvider(this.agileGrid, this.adapterFactory, this.editingDomain));
        this.agileGrid.setCellEditorProvider((ICellEditorProvider)new ProrCellEditorProvider(this.agileGrid, this.editingDomain, this.adapterFactory, this.agileCellEditorActionHandler));
        this.agileGrid.setRowResizeCursor(new Cursor((Device)this.agileGrid.getDisplay(), 0));
        this.updateRowCount();
        this.updateColumnInformation();
        this.registerColumnListener();
        this.registerSelectionChangedListener();
        this.registerSpecHierarchyListener();
        this.registerSpecRelationListener();
        this.registerDoubleClickListener();
        this.resolveSpecObjectReferences();
    }

    private void resolveSpecObjectReferences() {
        Job job = new Job("Resolving SpecObject References"){

            protected IStatus run(IProgressMonitor monitor) {
                HashSet specHierarchies = new HashSet();
                specHierarchies.addAll(ProrAgileGridViewer.this.specification.getChildren());
                monitor.beginTask("Resolving SpecObject References", ProrAgileGridViewer.this.contentProvider.getRowCount());
                while (!specHierarchies.isEmpty()) {
                    SpecHierarchy specHierarchy = (SpecHierarchy)specHierarchies.iterator().next();
                    specHierarchies.remove(specHierarchy);
                    specHierarchies.addAll(specHierarchy.getChildren());
                    specHierarchy.getObject();
                    monitor.worked(1);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void dispose() {
        this.unregisterColumnListener();
        this.unregisterSelectionChangedListener();
        this.unregisterSpecHierarchyListener();
        this.unregisterSpecRelationListener();
        this.unregisterDoubleClickListener();
        if (!this.agileGrid.isDisposed()) {
            this.agileGrid.dispose();
        }
    }

    private void unregisterColumnListener() {
        if (this.emfColumnListener != null) {
            this.specViewConfig.eAdapters().remove((Object)this.emfColumnListener);
        }
    }

    private void registerColumnListener() {
        this.emfColumnListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (!ProrAgileGridViewer.this.agileGrid.isDisposed()) {
                    ProrAgileGridViewer.this.updateColumnInformation();
                    ProrAgileGridViewer.this.refresh();
                }
            }
        };
        this.specViewConfig.eAdapters().add((Object)this.emfColumnListener);
        this.agColumnListener = new CellResizeAdapter(){

            public void columnResized(int col, int newWidth) {
                Column column;
                Column column2 = column = col == -1 ? ConfigurationUtil.getLeftHeaderColumn((Specification)ProrAgileGridViewer.this.specification, (EditingDomain)ProrAgileGridViewer.this.editingDomain) : (Column)ProrAgileGridViewer.this.specViewConfig.getColumns().get(col);
                if (column != null) {
                    Command cmd = SetCommand.create((EditingDomain)ProrAgileGridViewer.this.editingDomain, (Object)column, (Object)ConfigurationPackage.Literals.COLUMN__WIDTH, (Object)newWidth);
                    ProrAgileGridViewer.this.editingDomain.getCommandStack().execute(cmd);
                }
            }
        };
        this.agileGrid.addCellResizeListener(this.agColumnListener);
    }

    private void unregisterSpecHierarchyListener() {
        if (this.specHierarchyRootContentAdapter != null) {
            this.specification.eAdapters().remove((Object)this.specHierarchyRootContentAdapter);
        }
    }

    private void unregisterSpecRelationListener() {
        if (this.specRelationContentAdapter != null) {
            ReqIF10Util.getReqIF((Object)this.specification).getCoreContent().eAdapters().remove((Object)this.specHierarchyRootContentAdapter);
        }
    }

    private void registerSpecHierarchyListener() {
        this.specHierarchyRootContentAdapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getNewValue() instanceof SpecObject && notification.getEventType() == 1) {
                    SpecObject specObject = (SpecObject)notification.getNewValue();
                    ProrAgileGridViewer.this.contentProvider.updateElement((SpecElementWithAttributes)specObject);
                } else if (notification.getFeature() == ReqIF10Package.Literals.SPECIFICATION__CHILDREN || notification.getFeature() == ReqIF10Package.Literals.SPEC_HIERARCHY__CHILDREN) {
                    ProrAgileGridViewer.this.updateRowCount();
                    ProrAgileGridViewer.this.refresh();
                }
            }
        };
        this.specification.eAdapters().add((Object)this.specHierarchyRootContentAdapter);
    }

    private void registerSpecRelationListener() {
        this.specRelationContentAdapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                SpecRelation specRelation = null;
                if (notification.getNotifier() instanceof SpecRelation) {
                    specRelation = (SpecRelation)notification.getNotifier();
                }
                if (notification.getNewValue() instanceof SpecRelation) {
                    specRelation = (SpecRelation)notification.getNewValue();
                }
                if (specRelation != null) {
                    if (specRelation.getSource() != null) {
                        ProrAgileGridViewer.this.contentProvider.updateElement((SpecElementWithAttributes)specRelation.getSource());
                    }
                    if (specRelation.getTarget() != null) {
                        ProrAgileGridViewer.this.contentProvider.updateElement((SpecElementWithAttributes)specRelation.getTarget());
                    }
                    ProrAgileGridViewer.this.updateRowCount();
                    ProrAgileGridViewer.this.refresh();
                }
            }
        };
        ReqIF10Util.getReqIF((Object)this.specification).getCoreContent().eAdapters().add((Object)this.specRelationContentAdapter);
    }

    private void registerDoubleClickListener() {
        this.doubleClickListener = new ICellDoubleClickListener(){

            public void cellDoubleClicked(CellDoubleClickEvent event) {
                Object source = event.getSource();
                if (source instanceof Cell) {
                    Cell cell = (Cell)source;
                    ProrRow prorRow = ProrAgileGridViewer.this.contentProvider.getProrRow(cell.row);
                    if (prorRow instanceof ProrRow.ProrRowSpecHierarchy && cell.column == ProrAgileGridViewer.this.specViewConfig.getColumns().size()) {
                        ProrRow.ProrRowSpecHierarchy prorRowSH;
                        prorRowSH.setShowSpecRelation(!(prorRowSH = (ProrRow.ProrRowSpecHierarchy)prorRow).isShowSpecRelation());
                        ProrAgileGridViewer.this.contentProvider.flushCache();
                        ProrAgileGridViewer.this.updateRowCount();
                        ProrAgileGridViewer.this.refresh();
                    }
                }
            }
        };
        this.agileGrid.addCellDoubleClickListener(this.doubleClickListener);
    }

    private void unregisterDoubleClickListener() {
        if (this.doubleClickListener != null && !this.agileGrid.isDisposed()) {
            this.agileGrid.removeDoubleClickListener(this.doubleClickListener);
        }
    }

    private void unregisterSelectionChangedListener() {
        if (this.selectionChangedistener != null && !this.agileGrid.isDisposed()) {
            this.agileGrid.removeSelectionChangedListener(this.selectionChangedistener);
        }
    }

    private void registerSelectionChangedListener() {
        if (this.selectionChangedistener != null) {
            this.agileGrid.removeSelectionChangedListener(this.selectionChangedistener);
        }
        this.selectionChangedistener = new ISelectionChangedListener(){

            public void selectionChanged(org.agilemore.agilegrid.SelectionChangedEvent event) {
                if (ProrAgileGridViewer.this.settingSelection) {
                    return;
                }
                Set cells = event.getNewSelections();
                ArrayList<Object> items = new ArrayList<Object>();
                for (Cell cell : cells) {
                    if (cell.row <= -1) continue;
                    ProrRow row = ProrAgileGridViewer.this.contentProvider.getProrRow(cell.row);
                    if (row instanceof ProrRow.ProrRowSpecRelation && cell.column == ProrAgileGridViewer.this.specViewConfig.getColumns().size()) {
                        SpecRelation relation = (SpecRelation)row.getSpecElement();
                        if (relation.getTarget() == null) continue;
                        items.add(relation.getTarget());
                        continue;
                    }
                    if (row instanceof ProrRow.ProrRowSpecRelation && cell.column < ProrAgileGridViewer.this.specViewConfig.getColumns().size()) {
                        items.add(row.getSpecElement());
                        continue;
                    }
                    if (row instanceof ProrRow.ProrRowSpecHierarchy) {
                        items.add(((ProrRow.ProrRowSpecHierarchy)row).getSpecHierarchy());
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                if (items.size() == 0) {
                    items.add(ProrAgileGridViewer.this.getInput());
                }
                ProrAgileGridViewer.this.selection = (IStructuredSelection)new StructuredSelection(items);
                ProrAgileGridViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)ProrAgileGridViewer.this, (ISelection)ProrAgileGridViewer.this.selection));
            }
        };
        this.agileGrid.addSelectionChangedListener(this.selectionChangedistener);
    }

    private void updateRowCount() {
        this.agileGrid.getLayoutAdvisor().setRowCount(this.contentProvider.getRowCount());
    }

    private void updateColumnInformation() {
        EList cols = this.specViewConfig.getColumns();
        Column leftHeaderColumn = ConfigurationUtil.getLeftHeaderColumn((Specification)this.specification, (EditingDomain)this.editingDomain);
        if (leftHeaderColumn != null) {
            this.agileGrid.getLayoutAdvisor().setLeftHeaderWidth(leftHeaderColumn.getWidth());
        }
        if (!this.agileGrid.isDisposed()) {
            this.agileGrid.getLayoutAdvisor().setColumnCount(cols.size() + 1);
            int i = 0;
            while (i < cols.size()) {
                this.agileGrid.getLayoutAdvisor().setTopHeaderLabel(i, ((Column)cols.get(i)).getLabel());
                this.agileGrid.getLayoutAdvisor().setColumnWidth(i, ((Column)cols.get(i)).getWidth());
                ++i;
            }
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (this.settingSelection) {
            return;
        }
        this.settingSelection = true;
        this.selection = (IStructuredSelection)selection;
        HashSet<Cell> cells = new HashSet<Cell>();
        int row = 0;
        while (row < this.contentProvider.getRowCount()) {
            ProrRow prorRow = this.contentProvider.getProrRow(row);
            Object current = prorRow instanceof ProrRow.ProrRowSpecHierarchy ? ((ProrRow.ProrRowSpecHierarchy)prorRow).getSpecHierarchy() : prorRow.getSpecElement();
            for (Object item : ((IStructuredSelection)selection).toList()) {
                if (!item.equals(current)) continue;
                boolean added = false;
                int col = 0;
                while (col < this.agileGrid.getLayoutAdvisor().getColumnCount()) {
                    if (this.agileGrid.isCellSelected(row, col)) {
                        cells.add(new Cell((AgileGrid)this.agileGrid, row, col));
                        added = true;
                    }
                    ++col;
                }
                if (added) break;
                cells.add(new Cell((AgileGrid)this.agileGrid, row, 0));
                break;
            }
            ++row;
        }
        Cell[] cellArray = new Cell[cells.size()];
        cells.toArray(cellArray);
        this.agileGrid.clearSelection();
        if (cellArray.length > 0) {
            if (!this.agileGrid.isCellEditorActive()) {
                this.agileGrid.focusCell(cellArray[0]);
            }
            this.agileGrid.selectCells(cellArray);
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            this.fireSelectionChanged(event);
        }
        this.settingSelection = false;
    }

    public void setContextMenu(MenuManager contextMenu) {
        Menu menu = contextMenu.createContextMenu((Control)this.agileGrid);
        this.agileGrid.setMenu(menu);
    }

    private void enableDragNDrop() {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        this.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter(this){

            public void dragStart(DragSourceEvent event) {
                Cell cell = ProrAgileGridViewer.this.agileGrid.getCell(event.x, event.y);
                if (cell.row == -1 || cell.column == -1) {
                    event.doit = false;
                }
                super.dragStart(event);
            }

            public void dragFinished(DragSourceEvent event) {
                super.dragFinished(event);
            }
        });
        this.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.editingDomain, this){
            protected boolean prevTargetIsSpecHierarchy;
            protected SpecHierarchy prevTarget;
            protected float prevLocation;

            public void dragEnter(DropTargetEvent event) {
                this.prevTargetIsSpecHierarchy = false;
                this.prevTarget = null;
                this.prevLocation = -1.0f;
                super.dragEnter(event);
            }

            public void dragLeave(DropTargetEvent event) {
                if (this.prevTargetIsSpecHierarchy) {
                    ((ProrAgileGridViewer)ProrAgileGridViewer.this).agileGrid.dndHoverCell = null;
                    ProrAgileGridViewer.this.agileGrid.redraw();
                    this.prevTargetIsSpecHierarchy = false;
                }
                super.dragLeave(event);
            }

            protected Object extractDropTarget(Widget item) {
                return ProrAgileGridViewer.this.dragTarget;
            }

            public void dragOver(DropTargetEvent e) {
                Point pos = ProrAgileGridViewer.this.agileGrid.toControl(e.x, e.y);
                Cell cell = ProrAgileGridViewer.this.agileGrid.getCell(pos.x, pos.y);
                if (cell.equals((Object)Cell.NULLCELL)) {
                    ProrAgileGridViewer.this.dragTarget = null;
                    super.dragOver(e);
                    return;
                }
                ProrRow row = cell.row >= 0 ? ProrAgileGridViewer.this.contentProvider.getProrRow(cell.row) : null;
                SpecHierarchy target = null;
                if (row instanceof ProrRow.ProrRowSpecHierarchy) {
                    target = ((ProrRow.ProrRowSpecHierarchy)row).getSpecHierarchy();
                } else if (row instanceof ProrRow.ProrRowSpecRelation) {
                    target = row.getSpecElement();
                }
                if (target instanceof SpecHierarchy) {
                    ProrAgileGridViewer.this.dragTarget = target;
                    float location = this.getLocation(e);
                    if (location != this.prevLocation || ProrAgileGridViewer.this.dragTarget != this.prevTarget) {
                        if ((double)location == 0.5) {
                            ((ProrAgileGridViewer)ProrAgileGridViewer.this).agileGrid.dndHoverCell = cell;
                            ((ProrAgileGridViewer)ProrAgileGridViewer.this).agileGrid.dndHoverDropMode = 1;
                        }
                        if ((double)location == 0.0) {
                            Cell prevCell;
                            ((ProrAgileGridViewer)ProrAgileGridViewer.this).agileGrid.dndHoverCell = prevCell = ProrAgileGridViewer.this.agileGrid.getNeighbor(cell, 1, true);
                            ((ProrAgileGridViewer)ProrAgileGridViewer.this).agileGrid.dndHoverDropMode = 0;
                        }
                        if ((double)location == 1.0) {
                            ((ProrAgileGridViewer)ProrAgileGridViewer.this).agileGrid.dndHoverCell = cell;
                            ((ProrAgileGridViewer)ProrAgileGridViewer.this).agileGrid.dndHoverDropMode = 0;
                        }
                        ProrAgileGridViewer.this.agileGrid.redraw();
                    }
                    this.prevTargetIsSpecHierarchy = true;
                    this.prevTarget = ProrAgileGridViewer.this.dragTarget;
                    this.prevLocation = location;
                } else if (this.prevTargetIsSpecHierarchy) {
                    ((ProrAgileGridViewer)ProrAgileGridViewer.this).agileGrid.dndHoverCell = null;
                    ProrAgileGridViewer.this.dragTarget = null;
                    ProrAgileGridViewer.this.agileGrid.redraw();
                    this.prevTargetIsSpecHierarchy = false;
                }
                super.dragOver(e);
            }

            public void drop(DropTargetEvent event) {
                super.drop(event);
                ((ProrAgileGridViewer)ProrAgileGridViewer.this).agileGrid.dndHoverCell = null;
                ProrAgileGridViewer.this.agileGrid.redraw();
            }

            protected float getLocation(DropTargetEvent event) {
                Point pos = ProrAgileGridViewer.this.agileGrid.toControl(event.x, event.y);
                Cell cell = ProrAgileGridViewer.this.agileGrid.getCell(pos.x, pos.y);
                if (ProrAgileGridViewer.this.agileGrid.getLayoutAdvisor() instanceof ProrLayoutAdvisor) {
                    ProrLayoutAdvisor layoutAdvisor = (ProrLayoutAdvisor)ProrAgileGridViewer.this.agileGrid.getLayoutAdvisor();
                    int rowHeight = layoutAdvisor.getRowHeight(cell.row);
                    int y = ProrAgileGridViewer.this.agileGrid.getYForRow(cell.row);
                    int mouseY = pos.y - y;
                    float location = (float)mouseY / (float)rowHeight;
                    if ((double)location < 0.3) {
                        return 0.0f;
                    }
                    if ((double)location <= 0.7) {
                        return 0.5f;
                    }
                    return 1.0f;
                }
                return 1.0f;
            }
        });
    }

    private void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
        Control myControl = this.getControl();
        DragSource dragSource = new DragSource(myControl, operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener(listener);
    }

    private void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
        DropTarget dropTarget = new DropTarget((Control)this.agileGrid, operations);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener(listener);
    }

    public void setShowSpecRelations(boolean status) {
        this.contentProvider.setShowSpecRelations(status);
        this.updateRowCount();
        this.agileGrid.redraw();
    }
}

