/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.propertiesview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.agilemore.agilegrid.AbstractContentProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProrPropertyContentProvider
extends AbstractContentProvider {
    public static String SPEC_HIERARCHY_NAME = "Spec Hierarchy";
    public static String SPEC_OBJECT_NAME = "Spec Object";
    public static String SPEC_RELATION_NAME = "Spec Relation";
    public static String SPECIFICATION_NAME = "Specification";
    public static String RELATION_GROUP_NAME = "Relation Group";
    private List<PropertyRow> rows;
    private Object content;
    private boolean showAllProps;
    private AdapterFactory adapterFactory;

    public ProrPropertyContentProvider(AdapterFactory adapterFactory, boolean showAllProps) {
        this.adapterFactory = adapterFactory;
        this.showAllProps = showAllProps;
    }

    public Object doGetContentAt(int row, int col) {
        return this.getRows().get(row).getContent(col);
    }

    Object getElement() {
        return this.content;
    }

    public void doSetContentAt(int row, int col, Object value) {
        super.firePropertyChange("", null, null);
    }

    public PropertyRow getRowContent(int row) {
        if (row >= this.getRowCount()) {
            return null;
        }
        return this.getRows().get(row);
    }

    public IItemLabelProvider getItemLabelProvider(int row) {
        return null;
    }

    public void setContent(Object content) {
        this.content = content;
        this.rows = null;
    }

    public int getRowCount() {
        return this.getRows().size();
    }

    private List<PropertyRow> getRows() {
        if (this.rows != null) {
            return this.rows;
        }
        this.rows = new ArrayList<PropertyRow>();
        ItemProviderAdapter provider = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.content);
        if (provider == null) {
            return this.rows;
        }
        TreeMap<String, TreeSet<Descriptor>> categoryMap = new TreeMap<String, TreeSet<Descriptor>>();
        for (IItemPropertyDescriptor prop : provider.getPropertyDescriptors(this.content)) {
            TreeSet<Descriptor> categorySet;
            if (!this.showAllProps && this.isAdvancedProperty(prop)) continue;
            String categoryName = prop.getCategory(this.content);
            if (categoryName == null) {
                categoryName = "Misc";
            }
            if ((categorySet = categoryMap.get(categoryName)) == null) {
                categorySet = new TreeSet();
                categoryMap.put(categoryName, categorySet);
            }
            categorySet.add(new Descriptor(prop));
        }
        this.addCategoryAndRemoveFromMap(categoryMap, SPEC_OBJECT_NAME);
        this.addCategoryAndRemoveFromMap(categoryMap, SPEC_RELATION_NAME);
        this.addCategoryAndRemoveFromMap(categoryMap, SPEC_HIERARCHY_NAME);
        this.addCategoryAndRemoveFromMap(categoryMap, SPECIFICATION_NAME);
        this.addCategoryAndRemoveFromMap(categoryMap, RELATION_GROUP_NAME);
        for (String categoryName : categoryMap.keySet()) {
            this.rows.add(0, new Category(categoryName));
            this.rows.addAll(1, (Collection<PropertyRow>)categoryMap.get(categoryName));
        }
        return this.rows;
    }

    private void addCategoryAndRemoveFromMap(TreeMap<String, TreeSet<Descriptor>> categoryMap, String categoryName) {
        if (categoryMap.containsKey(categoryName)) {
            this.rows.add(new Category(categoryName));
            this.rows.addAll((Collection<PropertyRow>)categoryMap.get(categoryName));
            categoryMap.remove(categoryName);
        }
    }

    private boolean isAdvancedProperty(IItemPropertyDescriptor prop) {
        String name = prop.getId(this.content);
        String category = prop.getCategory(this.content);
        if (category == null && "identifier".equals(name) || "desc".equals(name) || "lastChange".equals(name)) {
            return true;
        }
        if (!(SPEC_HIERARCHY_NAME.equals(category) || SPEC_RELATION_NAME.equals(category) || SPEC_OBJECT_NAME.equals(category) || SPECIFICATION_NAME.equals(category) || RELATION_GROUP_NAME.equals(category))) {
            return false;
        }
        return "identifier".equals(name) || "desc".equals(name) || "lastChange".equals(name) || "editable".equals(name) || "longName".equals(name) || "tableInternal".equals(name) || "object".equals(name) || "editableAtts".equals(name);
    }

    class Category
    implements PropertyRow {
        String name;

        public Category(String name) {
            this.name = name;
        }

        public Object getContent(int column) {
            return column == 0 ? this.name : null;
        }

        public int compareTo(PropertyRow that) {
            return this.name.compareTo(((Category)that).name);
        }

        public boolean equals(Object that) {
            if (!(that instanceof Category)) {
                return false;
            }
            return this.compareTo((PropertyRow)that) == 0;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    class Descriptor
    implements PropertyRow {
        IItemPropertyDescriptor descriptor;
        AttributeValue attributeValue;

        public Descriptor(IItemPropertyDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public IItemPropertyDescriptor getItemPropertyDescriptor() {
            return this.descriptor;
        }

        public boolean isRMFSpecific() {
            Object feature = this.descriptor.getFeature(ProrPropertyContentProvider.this.content);
            return feature == ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES || this.descriptor.getFeature(ProrPropertyContentProvider.this.content) == ReqIF10Package.Literals.ATTRIBUTE_VALUE_BOOLEAN__THE_VALUE || this.descriptor.getFeature(ProrPropertyContentProvider.this.content) == ReqIF10Package.Literals.ATTRIBUTE_VALUE_DATE__THE_VALUE || this.descriptor.getFeature(ProrPropertyContentProvider.this.content) == ReqIF10Package.Literals.ATTRIBUTE_VALUE_ENUMERATION__VALUES || this.descriptor.getFeature(ProrPropertyContentProvider.this.content) == ReqIF10Package.Literals.ATTRIBUTE_VALUE_INTEGER__THE_VALUE || this.descriptor.getFeature(ProrPropertyContentProvider.this.content) == ReqIF10Package.Literals.ATTRIBUTE_VALUE_REAL__THE_VALUE || this.descriptor.getFeature(ProrPropertyContentProvider.this.content) == ReqIF10Package.Literals.ATTRIBUTE_VALUE_STRING__THE_VALUE || this.descriptor.getFeature(ProrPropertyContentProvider.this.content) == ReqIF10Package.Literals.ATTRIBUTE_VALUE_XHTML__THE_VALUE;
        }

        public Object getContent(int column) {
            return column == 0 ? this.descriptor.getDisplayName(ProrPropertyContentProvider.this.content) : this.descriptor.getPropertyValue(ProrPropertyContentProvider.this.content);
        }

        public int compareTo(PropertyRow that) {
            return this.descriptor.getDisplayName(ProrPropertyContentProvider.this.content).compareTo(((Descriptor)that).descriptor.getDisplayName(ProrPropertyContentProvider.this.content));
        }

        public String toString() {
            ItemPropertyDescriptor.PropertyValueWrapper propertyValueWrapper = (ItemPropertyDescriptor.PropertyValueWrapper)this.descriptor.getPropertyValue(ProrPropertyContentProvider.this.content);
            return propertyValueWrapper == null ? "" : propertyValueWrapper.getText(ProrPropertyContentProvider.this.content);
        }

        public boolean equals(Object that) {
            if (!(that instanceof Descriptor)) {
                return false;
            }
            return this.compareTo((Descriptor)that) == 0;
        }

        public int hashCode() {
            return this.descriptor.hashCode();
        }

        public AttributeValue getAttributeValue() {
            if (!this.isRMFSpecific()) {
                return null;
            }
            SpecElementWithAttributes specElement = null;
            if (ProrPropertyContentProvider.this.content instanceof SpecElementWithAttributes) {
                specElement = (SpecElementWithAttributes)ProrPropertyContentProvider.this.content;
            } else if (ProrPropertyContentProvider.this.content instanceof SpecHierarchy) {
                specElement = ((SpecHierarchy)ProrPropertyContentProvider.this.content).getObject();
            }
            if (specElement == null && ProrPropertyContentProvider.this.content instanceof AttributeDefinition) {
                AttributeDefinition ad = (AttributeDefinition)ProrPropertyContentProvider.this.content;
                EStructuralFeature defaultValueFeature = ReqIF10Util.getDefaultValueFeature((AttributeDefinition)ad);
                return (AttributeValue)((AttributeDefinition)ProrPropertyContentProvider.this.content).eGet(defaultValueFeature);
            }
            return ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)specElement, (String)this.descriptor.getDisplayName((Object)specElement));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface PropertyRow
    extends Comparable<PropertyRow> {
        public Object getContent(int var1);
    }
}

