/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.Locator;
import ch.ethz.iks.slp.ServiceLocationEnumeration;
import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.AttributeRequest;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPUtils;
import ch.ethz.iks.slp.impl.ServiceLocationEnumerationImpl;
import ch.ethz.iks.slp.impl.ServiceRequest;
import ch.ethz.iks.slp.impl.ServiceTypeRequest;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class LocatorImpl
implements Locator {
    private Locale locale;

    public LocatorImpl() {
        this.locale = SLPCore.DEFAULT_LOCALE;
    }

    public LocatorImpl(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ServiceLocationEnumeration findServiceTypes(String namingAuthority, List scopes) throws ServiceLocationException {
        ServiceTypeRequest srvTypeReq = new ServiceTypeRequest(namingAuthority, scopes, this.locale);
        return new ServiceLocationEnumerationImpl(this.sendRequest(srvTypeReq, scopes));
    }

    public ServiceLocationEnumeration findServices(ServiceType type, List scopes, String searchFilter) throws ServiceLocationException {
        try {
            ServiceRequest srvReq = new ServiceRequest(type, scopes, searchFilter, this.locale);
            return new ServiceLocationEnumerationImpl(this.sendRequest(srvReq, scopes));
        }
        catch (IllegalArgumentException ise) {
            throw new ServiceLocationException(20, String.valueOf(ise.getMessage()) + ": " + searchFilter);
        }
    }

    public ServiceLocationEnumeration findAttributes(ServiceURL url, List scopes, List attributeIds) throws ServiceLocationException {
        return this.findAttributes(new AttributeRequest(url, scopes, attributeIds, this.locale));
    }

    public ServiceLocationEnumeration findAttributes(ServiceType type, List scopes, List attributeIds) throws ServiceLocationException {
        return this.findAttributes(new AttributeRequest(type, scopes, attributeIds, this.locale));
    }

    private ServiceLocationEnumeration findAttributes(AttributeRequest attReq) throws ServiceLocationException {
        return new ServiceLocationEnumerationImpl(this.sendRequest(attReq, attReq.scopeList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List sendRequest(RequestMessage req, List scopeList) throws ServiceLocationException {
        List<String> scopes = scopeList != null ? scopeList : Arrays.asList("default");
        ArrayList result = new ArrayList();
        Iterator<String> scopeIter = scopes.iterator();
        while (scopeIter.hasNext()) {
            String scope = scopeIter.next();
            scope = scope.toLowerCase();
            List dAs = (List)SLPCore.dAs.get(scope);
            SLPCore.platform.logDebug("DAS FOR SCOPE " + scope + ": " + dAs);
            if ((dAs == null || dAs.isEmpty()) && !SLPCore.noDiscovery) {
                SLPCore.daLookup(Arrays.asList(scope));
                Map map = SLPCore.dAs;
                synchronized (map) {
                    try {
                        SLPCore.dAs.wait(SLPCore.CONFIG.getWaitTime() / 4);
                    }
                    catch (InterruptedException e) {
                        SLPCore.platform.logError(e.getMessage(), e);
                        Thread.currentThread().interrupt();
                    }
                }
                dAs = (List)SLPCore.dAs.get(scope);
            }
            if (dAs != null && !dAs.isEmpty()) {
                try {
                    result.addAll(this.sendRequestToDA(req, dAs));
                }
                catch (ServiceLocationException serviceLocationException) {
                    result.addAll(SLPCore.multicastConvergence(req));
                }
                continue;
            }
            if (SLPCore.noDiscovery) {
                throw new ServiceLocationException(4, "Scope " + scope + " is not supported");
            }
            result.addAll(SLPCore.multicastConvergence(req));
        }
        return result;
    }

    private List sendRequestToDA(RequestMessage req, List dAaddresses) throws ServiceLocationException {
        int index = 0;
        while (index < dAaddresses.size()) {
            ReplyMessage reply = null;
            try {
                req.address = InetAddress.getByName((String)dAaddresses.get(index));
                req.port = 427;
                reply = SLPCore.sendMessage(req, true);
                if (reply.errorCode == 0) {
                    return reply.getResult();
                }
            }
            catch (Exception e) {
                SLPCore.platform.logError(e.getMessage(), e.fillInStackTrace());
                Object url = dAaddresses.get(index);
                SLPUtils.removeValueFromAll(SLPCore.dAs, url);
                SLPCore.dASPIs.remove(url);
            }
            ++index;
        }
        throw new ServiceLocationException(20, "No DA reachable");
    }
}

