/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.clients;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.BaseSharedObject;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectActivatedEvent;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.IEventProcessor;

public class TestSharedObject
extends BaseSharedObject {
    public static final String NAME_PROPERTY = "name";
    String name;

    public TestSharedObject(String name) {
        this.name = name;
        Assert.isNotNull((Object)name);
    }

    public TestSharedObject() {
    }

    protected void initialize() throws SharedObjectInitException {
        super.initialize();
        if (this.isPrimary()) {
            this.addEventProcessor(new IEventProcessor(){

                public boolean processEvent(Event event) {
                    if (event instanceof ISharedObjectActivatedEvent && TestSharedObject.this.isPrimary() && TestSharedObject.this.isConnected()) {
                        TestSharedObject.this.replicateToRemoteContainers(null);
                    }
                    return false;
                }
            });
            System.out.println("Primary(" + this.getContext().getLocalContainerID() + ") says Hello " + this.name);
        } else {
            this.name = (String)this.getConfig().getProperties().get(NAME_PROPERTY);
            System.out.println("Replica(" + this.getContext().getLocalContainerID() + ") says Hello " + this.name);
        }
    }

    protected ReplicaSharedObjectDescription getReplicaDescription(ID receiver) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(NAME_PROPERTY, this.name);
        return new ReplicaSharedObjectDescription(((Object)((Object)this)).getClass(), this.getConfig().getSharedObjectID(), this.getConfig().getHomeContainerID(), properties);
    }
}

