/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DiscoveredServiceID;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.LogUtility;
import org.eclipse.ecf.internal.osgi.services.distribution.RemoteServiceRegistration;
import org.eclipse.ecf.osgi.services.discovery.IRemoteServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.discovery.RemoteServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IProxyDistributionListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.discovery.DiscoveredServiceNotification;
import org.osgi.service.discovery.DiscoveredServiceTracker;
import org.osgi.service.discovery.ServiceEndpointDescription;

public class DiscoveredServiceTrackerImpl
implements DiscoveredServiceTracker {
    private DistributionProviderImpl distributionProvider;
    private IExecutor executor;
    private List serviceLocations = new ArrayList();
    private Map discoveredRemoteServiceRegistrations = Collections.synchronizedMap(new HashMap());
    private List ecfRemoteServiceProperties = Arrays.asList("ecf.rsvc.id", "ecf.robjectClass", "osgi.remote.endpoint.id", "osgi.remote.endpoint.interfaces", "osgi.remote.endpoint.location", "osgi.remote.service.interfaces", "osgi.remote.service.interfaces.version", "osgi.remote.discovery.publication.service.properties");
    static /* synthetic */ Class class$0;

    public DiscoveredServiceTrackerImpl(DistributionProviderImpl dp, IExecutor executor) {
        this.distributionProvider = dp;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serviceChanged(DiscoveredServiceNotification notification) {
        if (notification == null) {
            return;
        }
        int notificationType = notification.getType();
        switch (notificationType) {
            case 1: {
                RemoteServiceEndpointDescription adesc = null;
                try {
                    adesc = this.getECFserviceEndpointDescription(notification.getServiceEndpointDescription());
                }
                catch (Exception e) {
                    this.logError("serviceChanged.AVAILABLE", "Error creating ECF endpoint description", e);
                    return;
                }
                if (adesc == null) {
                    return;
                }
                if (!this.isValidService(adesc)) {
                    this.trace("serviceChanged.AVAILABLE", "Duplicate or invalid description=" + adesc);
                    return;
                }
                final RemoteServiceEndpointDescription ecfASED = adesc;
                this.executor.execute(new IProgressRunnable(){

                    public Object run(IProgressMonitor monitor) throws Exception {
                        try {
                            DiscoveredServiceTrackerImpl.this.handleDiscoveredServiceAvailable(ecfASED, monitor);
                        }
                        catch (Exception e) {
                            DiscoveredServiceTrackerImpl.this.logError("handleDiscoveredServiceAvailble", "Unexpected exception with ecfSED=" + ecfASED, e);
                            throw e;
                        }
                        return null;
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
                return;
            }
            case 4: {
                try {
                    RemoteServiceEndpointDescription udesc = this.getECFserviceEndpointDescription(notification.getServiceEndpointDescription());
                    if (udesc == null) {
                        return;
                    }
                    List list = this.serviceLocations;
                    synchronized (list) {
                        ServiceRegistration[] proxyServiceRegistrations = this.removeProxyServiceRegistrations((ServiceEndpointDescription)udesc);
                        if (proxyServiceRegistrations == null) return;
                        int i = 0;
                        while (i < proxyServiceRegistrations.length) {
                            this.trace("handleDiscoveredServiceUnavailable", "proxyServiceRegistrations=" + proxyServiceRegistrations[i] + ",serviceEndpointDesc=" + udesc);
                            this.unregisterProxyServiceRegistration((IRemoteServiceEndpointDescription)udesc, proxyServiceRegistrations[i]);
                            ++i;
                        }
                        this.removeDiscoveredServiceID(udesc);
                        return;
                    }
                }
                catch (Exception e) {
                    this.logError("serviceChanged", "UNAVAILABLE", e);
                }
                return;
            }
            case 2: {
                return;
            }
            case 8: {
                return;
            }
            default: {
                this.logWarning("serviceChanged", "DiscoveredServiceNotification type=" + notificationType + " not found.  Ignoring");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidService(RemoteServiceEndpointDescription desc) {
        if (desc == null) {
            return false;
        }
        List list = this.serviceLocations;
        synchronized (list) {
            block5: {
                if (!this.containsDiscoveredServiceID(desc)) break block5;
                return false;
            }
            this.addDiscoveredServiceID(desc);
            return true;
        }
    }

    private IRemoteServiceContainer[] findRemoteServiceContainers(IServiceID serviceID, IRemoteServiceEndpointDescription description, IProgressMonitor monitor) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return new IRemoteServiceContainer[0];
        }
        IProxyContainerFinder[] finders = activator.getProxyRemoteServiceContainerFinders();
        if (finders == null) {
            this.logError("findRemoteServiceContainersViaService", "No container finders available");
            return new IRemoteServiceContainer[0];
        }
        HashMap<ID, IRemoteServiceContainer> rsContainers = new HashMap<ID, IRemoteServiceContainer>();
        int i = 0;
        while (i < finders.length) {
            IRemoteServiceContainer[] candidates = finders[i].findProxyContainers(serviceID, description, monitor);
            if (candidates != null) {
                int j = 0;
                while (j < candidates.length) {
                    ID containerID = candidates[i].getContainer().getID();
                    if (containerID != null) {
                        rsContainers.put(containerID, candidates[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        ArrayList results = new ArrayList();
        Iterator i2 = rsContainers.keySet().iterator();
        while (i2.hasNext()) {
            results.add(rsContainers.get(i2.next()));
        }
        return results.toArray(new IRemoteServiceContainer[0]);
    }

    private void handleDiscoveredServiceAvailable(RemoteServiceEndpointDescription ecfSED, IProgressMonitor monitor) {
        IRemoteServiceContainer[] rsContainers = this.findRemoteServiceContainers(ecfSED.getServiceID(), (IRemoteServiceEndpointDescription)ecfSED, monitor);
        if (rsContainers == null || rsContainers.length == 0) {
            this.logError("handleDiscoveredServiceAvailable", "No RemoteServiceContainerAdapters found for description=" + ecfSED, null);
            return;
        }
        ID ecfEndpointID = ecfSED.getEndpointAsID();
        String remoteServiceFilter = ecfSED.getRemoteServicesFilter();
        Collection providedInterfaces = ecfSED.getProvidedInterfaces();
        int i = 0;
        while (i < rsContainers.length) {
            Iterator j = providedInterfaces.iterator();
            while (j.hasNext()) {
                String providedInterface = (String)j.next();
                IRemoteServiceReference[] remoteReferences = null;
                this.firePreGetRemoteServiceReferences((IRemoteServiceEndpointDescription)ecfSED, rsContainers[i]);
                try {
                    remoteReferences = rsContainers[i].getContainerAdapter().getRemoteServiceReferences(ecfEndpointID, providedInterface, remoteServiceFilter);
                }
                catch (ContainerConnectException e) {
                    this.logError("handleDiscoveredServiceAvailable", "rsca=" + rsContainers[i] + ",endpointId=" + ecfEndpointID + ",intf=" + providedInterface + ". Connect error in getRemoteServiceReferences", e);
                    continue;
                }
                catch (InvalidSyntaxException e) {
                    this.logError("handleDiscoveredServiceAvailable", "rsca=" + rsContainers[i] + ",endpointId=" + ecfEndpointID + ",intf=" + providedInterface + " Filter syntax error in getRemoteServiceReferences", e);
                    continue;
                }
                if (remoteReferences == null || remoteReferences.length == 0) {
                    this.logError("handleDiscoveredServiceAvailable", "getRemoteServiceReferences result is empty. containerHelper=" + rsContainers[i] + "remoteReferences=" + (remoteReferences == null ? "null" : Arrays.asList(remoteReferences).toString()), null);
                    continue;
                }
                this.registerRemoteServiceReferences(ecfSED, rsContainers[i], remoteReferences);
            }
            ++i;
        }
    }

    private void firePreGetRemoteServiceReferences(final IRemoteServiceEndpointDescription endpointDescription, final IRemoteServiceContainer remoteServiceContainer) {
        IProxyDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getProxyDistributionListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IProxyDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        DiscoveredServiceTrackerImpl.this.logError("firePreGetRemoteServiceReferences", "Exception calling proxy distribution listener", exception);
                    }

                    public void run() throws Exception {
                        l.retrievingRemoteServiceReferences(endpointDescription, remoteServiceContainer);
                    }
                });
                ++i;
            }
        }
    }

    private void firePreRegister(final IRemoteServiceEndpointDescription endpointDescription, final IRemoteServiceContainer remoteServiceContainer, final IRemoteServiceReference remoteServiceReference) {
        IProxyDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getProxyDistributionListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IProxyDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        DiscoveredServiceTrackerImpl.this.logError("firePreRegister", "Exception calling proxy distribution listener", exception);
                    }

                    public void run() throws Exception {
                        l.registering(endpointDescription, remoteServiceContainer, remoteServiceReference);
                    }
                });
                ++i;
            }
        }
    }

    private void firePostRegister(final IRemoteServiceEndpointDescription endpointDescription, final IRemoteServiceContainer remoteServiceContainer, final IRemoteServiceReference remoteServiceReference, final ServiceRegistration serviceRegistration) {
        IProxyDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getProxyDistributionListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IProxyDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        DiscoveredServiceTrackerImpl.this.logError("firePreRegister", "Exception calling proxy distribution listener", exception);
                    }

                    public void run() throws Exception {
                        l.registered(endpointDescription, remoteServiceContainer, remoteServiceReference, serviceRegistration);
                    }
                });
                ++i;
            }
        }
    }

    private void fireUnregister(final IRemoteServiceEndpointDescription endpointDescription, final ServiceRegistration registration) {
        IProxyDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getProxyDistributionListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IProxyDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        DiscoveredServiceTrackerImpl.this.logError("fireUnregister", "Exception calling proxy distribution listener", exception);
                    }

                    public void run() throws Exception {
                        l.unregistered(endpointDescription, registration);
                    }
                });
                ++i;
            }
        }
    }

    private RemoteServiceEndpointDescription getECFserviceEndpointDescription(ServiceEndpointDescription aServiceEndpointDesc) {
        RemoteServiceEndpointDescription ecfSED;
        if (!(aServiceEndpointDesc instanceof RemoteServiceEndpointDescription)) {
            IAdapterManager iAdapterManager = Activator.getDefault().getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.osgi.services.discovery.RemoteServiceEndpointDescription");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ecfSED = (RemoteServiceEndpointDescription)iAdapterManager.loadAdapter((Object)aServiceEndpointDesc, clazz.getName());
        } else {
            ecfSED = (RemoteServiceEndpointDescription)aServiceEndpointDesc;
        }
        return ecfSED;
    }

    private boolean findProxyServiceRegistration(ServiceEndpointDescription sed) {
        Iterator i = this.discoveredRemoteServiceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            ID containerID = (ID)i.next();
            RemoteServiceRegistration reg = (RemoteServiceRegistration)this.discoveredRemoteServiceRegistrations.get(containerID);
            if (!sed.equals(reg.getServiceEndpointDescription())) continue;
            return true;
        }
        return false;
    }

    private ServiceRegistration[] removeProxyServiceRegistrations(ServiceEndpointDescription sed) {
        ArrayList results = new ArrayList();
        Iterator i = this.discoveredRemoteServiceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            ID containerID = (ID)i.next();
            RemoteServiceRegistration reg = (RemoteServiceRegistration)this.discoveredRemoteServiceRegistrations.get(containerID);
            if (!sed.equals(reg.getServiceEndpointDescription())) continue;
            i.remove();
            results.addAll(reg.removeAllServiceRegistrations());
            reg.dispose();
        }
        return results.toArray(new ServiceRegistration[0]);
    }

    private void unregisterProxyServiceRegistration(IRemoteServiceEndpointDescription endpointDescription, ServiceRegistration reg) {
        try {
            this.distributionProvider.removeRemoteService(reg.getReference());
            reg.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            this.logWarning("unregisterProxyServiceRegistration", "Exception unregistering serviceRegistration=" + reg);
        }
        catch (Exception e) {
            this.logError("unregisterProxyServiceRegistration", "Exception unregistering serviceRegistration=" + reg, e);
        }
        this.fireUnregister(endpointDescription, reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRemoteServiceReferences(RemoteServiceEndpointDescription sed, IRemoteServiceContainer ch, IRemoteServiceReference[] remoteReferences) {
        List list = this.serviceLocations;
        synchronized (list) {
            if (!this.containsDiscoveredServiceID(sed)) {
                this.logError("registerRemoteServiceReferences", "serviceLocation=" + sed + " no longer present", null);
                return;
            }
            if (this.findProxyServiceRegistration((ServiceEndpointDescription)sed)) {
                this.logError("registerRemoteServiceReferences", "serviceEndpointDesc=" + sed + " previously registered locally...ignoring", null);
                return;
            }
            int i = 0;
            while (i < remoteReferences.length) {
                IRemoteService remoteService = ch.getContainerAdapter().getRemoteService(remoteReferences[i]);
                if (remoteService == null) {
                    this.logError("registerRemoteServiceReferences", "Remote service is null for remote reference " + remoteReferences[i], null);
                } else {
                    String[] clazzes = (String[])remoteReferences[i].getProperty("ecf.robjectClass");
                    if (clazzes == null || clazzes.length == 0) {
                        this.logError("registerRemoteServiceReferences", "No classes specified for remote service reference " + remoteReferences[i], null);
                    } else {
                        Dictionary properties = this.getPropertiesForRemoteService((ServiceEndpointDescription)sed, ch.getContainerAdapter(), remoteReferences[i], remoteService);
                        Object proxy = null;
                        try {
                            proxy = remoteService.getProxy();
                            if (proxy == null) {
                                this.logError("registerRemoteServiceReferences", "Remote service proxy is null", null);
                            } else {
                                this.firePreRegister((IRemoteServiceEndpointDescription)sed, ch, remoteReferences[i]);
                                this.trace("registerRemoteServiceReferences", "rsca=" + ch + ",remoteReference=" + remoteReferences[i]);
                                ServiceRegistration registration = Activator.getDefault().getContext().registerService(clazzes, proxy, properties);
                                IRemoteServiceReference ref = remoteReferences[i];
                                ID containerID = ch.getContainer().getID();
                                RemoteServiceRegistration reg = (RemoteServiceRegistration)this.discoveredRemoteServiceRegistrations.get(containerID);
                                if (reg == null) {
                                    reg = new RemoteServiceRegistration(sed, ch, new RemoteServiceReferenceUnregisteredListener());
                                    this.discoveredRemoteServiceRegistrations.put(containerID, reg);
                                }
                                reg.addServiceRegistration(ref, registration);
                                this.distributionProvider.addRemoteService(registration.getReference());
                                this.trace("addLocalServiceRegistration.COMPLETE", "containerHelper=" + ch + ",remoteServiceReference=" + ref + ",localServiceRegistration=" + registration);
                                this.firePostRegister((IRemoteServiceEndpointDescription)sed, ch, remoteReferences[i], registration);
                            }
                        }
                        catch (Exception e) {
                            this.logError("registerRemoteServiceReferences", "Exception creating or registering remote reference " + remoteReferences[i], e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private boolean isRemoteServiceProperty(String propertyKey) {
        return this.ecfRemoteServiceProperties.contains(propertyKey);
    }

    private Dictionary getPropertiesForRemoteService(ServiceEndpointDescription description, IRemoteServiceContainerAdapter containerAdapter, IRemoteServiceReference remoteReference, IRemoteService remoteService) {
        Properties results = new Properties();
        String[] propKeys = remoteReference.getPropertyKeys();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.isRemoteServiceProperty(propKeys[i])) {
                results.put(propKeys[i], remoteReference.getProperty(propKeys[i]));
            }
            ++i;
        }
        results.put("osgi.remote", remoteService);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDiscoveredServiceID(RemoteServiceEndpointDescription desc) {
        List list = this.serviceLocations;
        synchronized (list) {
            return this.serviceLocations.add(new DiscoveredServiceID(desc.getServiceID().getLocation(), desc.getRemoteServiceId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeDiscoveredServiceID(RemoteServiceEndpointDescription desc) {
        List list = this.serviceLocations;
        synchronized (list) {
            return this.serviceLocations.remove(new DiscoveredServiceID(desc.getServiceID().getLocation(), desc.getRemoteServiceId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsDiscoveredServiceID(RemoteServiceEndpointDescription desc) {
        List list = this.serviceLocations;
        synchronized (list) {
            return this.serviceLocations.contains(new DiscoveredServiceID(desc.getServiceID().getLocation(), desc.getRemoteServiceId()));
        }
    }

    protected void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), message);
    }

    protected void traceException(String methodName, String message, Throwable t) {
        LogUtility.traceException(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/exceptions/catching", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message, Throwable t) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), message);
    }

    protected void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), message);
    }

    class RemoteServiceReferenceUnregisteredListener
    implements IRemoteServiceListener {
        RemoteServiceReferenceUnregisteredListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleServiceEvent(IRemoteServiceEvent event) {
            if (event instanceof IRemoteServiceUnregisteredEvent) {
                DiscoveredServiceTrackerImpl.this.trace("handleRemoteServiceUnregisteredEvent", "localContainerID=" + event.getLocalContainerID() + ",containerID=" + event.getContainerID() + ",remoteReference=" + event.getReference());
                ServiceRegistration[] proxyServiceRegistrations = null;
                List list = DiscoveredServiceTrackerImpl.this.serviceLocations;
                synchronized (list) {
                    RemoteServiceRegistration rsRegs = (RemoteServiceRegistration)DiscoveredServiceTrackerImpl.this.discoveredRemoteServiceRegistrations.get(event.getLocalContainerID());
                    if (rsRegs != null) {
                        proxyServiceRegistrations = rsRegs.removeServiceRegistration(event.getReference());
                        if (rsRegs.isEmpty()) {
                            rsRegs.dispose();
                            DiscoveredServiceTrackerImpl.this.discoveredRemoteServiceRegistrations.remove(event.getContainerID());
                        }
                    }
                }
                if (proxyServiceRegistrations != null) {
                    int i = 0;
                    while (i < proxyServiceRegistrations.length) {
                        DiscoveredServiceTrackerImpl.this.trace("handleRemoteServiceUnregisteredEvent.unregister", "localContainerID=" + event.getLocalContainerID() + ",containerID=" + event.getContainerID() + ",remoteReference=" + event.getReference() + ",proxyServiceRegistrations=" + proxyServiceRegistrations[i]);
                        DiscoveredServiceTrackerImpl.this.unregisterProxyServiceRegistration(null, proxyServiceRegistrations[i]);
                        ++i;
                    }
                }
            }
        }
    }
}

