/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.osgi.services.distribution.AbstractContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;
import org.osgi.framework.ServiceReference;

public class DefaultHostContainerFinder
extends AbstractContainerFinder
implements IHostContainerFinder {
    static /* synthetic */ Class class$0;

    public IRemoteServiceContainer[] findHostContainers(ServiceReference serviceReference, String[] remoteInterfaces, String[] remoteConfigurationType, String[] remoteRequiresIntents) {
        Collection rsContainers = this.findRemoteContainersSatisfyingRequiredIntents(remoteRequiresIntents);
        ArrayList<IRemoteServiceContainer> results = new ArrayList<IRemoteServiceContainer>();
        Iterator i = rsContainers.iterator();
        while (i.hasNext()) {
            IRemoteServiceContainer rsContainer = (IRemoteServiceContainer)i.next();
            if (!this.includeContainer(serviceReference, rsContainer)) continue;
            results.add(rsContainer);
        }
        return results.toArray(new IRemoteServiceContainer[0]);
    }

    protected Collection findRemoteContainersSatisfyingRequiredIntents(String[] remoteRequiresIntents) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        IContainer[] containers = Activator.getDefault().getContainerManager().getAllContainers();
        if (containers == null || containers.length == 0) {
            return null;
        }
        int i = 0;
        while (i < containers.length) {
            ContainerTypeDescription description;
            IRemoteServiceContainerAdapter adapter;
            IContainer iContainer = containers[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IRemoteServiceContainerAdapter)iContainer.getAdapter((Class)clazz)) != null && (description = Activator.getDefault().getContainerManager().getContainerTypeDescription(containers[i].getID())) != null) {
                List<String> supportedIntents = Arrays.asList(description.getSupportedIntents());
                boolean hasIntents = true;
                if (remoteRequiresIntents != null) {
                    int j = 0;
                    while (j < remoteRequiresIntents.length) {
                        if (!supportedIntents.contains(remoteRequiresIntents[j])) {
                            hasIntents = false;
                        }
                        ++j;
                    }
                }
                if (hasIntents) {
                    this.trace("findRemoteContainersSatisfyingRequiredIntents", "include containerID=" + containers[i].getID());
                    results.add(new RemoteServiceContainer(containers[i], adapter));
                } else {
                    this.trace("findRemoteContainersSatisfyingRequiredIntents", "exclude containerID=" + containers[i].getID() + " supported intents=" + supportedIntents);
                }
            }
            ++i;
        }
        return results;
    }

    protected boolean includeContainer(ServiceReference serviceReference, IRemoteServiceContainer rsContainer) {
        IContainer container = rsContainer.getContainer();
        Object cID = serviceReference.getProperty("ecf.rsvc.cid");
        if (cID == null || !(cID instanceof ID)) {
            this.trace("includeContainer", "serviceReference=" + serviceReference + " does not set remote service container id service property.  INCLUDING containerID=" + container.getID() + " in remote registration");
            return true;
        }
        ID containerID = (ID)cID;
        if (container.getID().equals((Object)containerID)) {
            this.trace("includeContainer", "serviceReference=" + serviceReference + " has MATCHING container id=" + containerID + ".  INCLUDING rsca=" + container.getID() + " in remote registration");
            return true;
        }
        this.trace("includeContainer", "serviceReference=" + serviceReference + " has non-matching id=" + containerID + ".  EXCLUDING id=" + container.getID() + " in remote registration");
        return false;
    }
}

