/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.msn;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import org.eclipse.ecf.protocol.msn.Contact;
import org.eclipse.ecf.protocol.msn.ContactList;
import org.eclipse.ecf.protocol.msn.MsnClient;
import org.eclipse.ecf.protocol.msn.Session;
import org.eclipse.ecf.protocol.msn.events.IChatSessionListener;
import org.eclipse.ecf.protocol.msn.internal.encode.StringUtils;

public final class ChatSession
extends Session {
    private final ArrayList contacts;
    private final ContactList contactList;
    private final String email;

    ChatSession(String host, MsnClient client) throws IOException {
        super(host, client);
        this.email = this.client.getUserEmail();
        this.listeners = new ArrayList();
        this.contacts = new ArrayList();
        this.contactList = client.getContactList();
    }

    ChatSession(String host, MsnClient client, String username, String info) throws IOException {
        this(host, client);
        this.authenticate(username, info);
    }

    private void authenticate(String username, String info) throws IOException {
        this.write("USR", String.valueOf(username) + ' ' + info);
        String input = super.read();
        if (input == null || input.indexOf("USR") == -1) {
            throw new ConnectException("Authentication has failed with the switchboard server.");
        }
        this.idle();
    }

    public void close() {
        try {
            this.write("OUT");
        }
        catch (Exception exception) {}
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invite(String userEmail) throws IOException {
        ArrayList arrayList = this.contacts;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.contacts.size()) {
                if (((Contact)this.contacts.get(i)).getEmail().equals(userEmail)) {
                    return;
                }
                ++i;
            }
        }
        this.write("CAL", userEmail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContactJoinedEvent(Contact contact) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IChatSessionListener)this.listeners.get(i)).contactJoined(contact);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContactLeftEvent(Contact contact) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IChatSessionListener)this.listeners.get(i)).contactLeft(contact);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContactIsTypingEvent(Contact contact) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IChatSessionListener)this.listeners.get(i)).contactIsTyping(contact);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageReceivedEvent(Contact contact, String message) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IChatSessionListener)this.listeners.get(i)).messageReceived(contact, message);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionTimedOutEvent() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((IChatSessionListener)this.listeners.get(i)).sessionTimedOut();
                ++i;
            }
        }
    }

    private Contact findContact(String userEmail) throws IllegalArgumentException {
        int i = 0;
        while (i < this.contacts.size()) {
            Contact contact = (Contact)this.contacts.get(i);
            if (contact.getEmail().equals(userEmail)) {
                return contact;
            }
            ++i;
        }
        throw new IllegalArgumentException("A contact with the email " + userEmail + " could not be found in this ChatSession.");
    }

    String read() throws IOException {
        String input = super.read();
        if (input == null) {
            return null;
        }
        String[] lines = StringUtils.split(input, "\r\n");
        int i = 0;
        while (i < lines.length) {
            Contact contact;
            if (lines[i].startsWith("IRO")) {
                String[] split = StringUtils.splitOnSpace(lines[i]);
                contact = this.contactList.getContact(split[4]);
                if (contact == null) {
                    contact = new Contact(split[4], split[5]);
                }
                this.contacts.add(contact);
                this.fireContactJoinedEvent(contact);
            } else if (lines[i].startsWith("JOI")) {
                String[] split = StringUtils.splitOnSpace(lines[i]);
                contact = this.contactList.getContact(split[2]);
                if (contact == null) {
                    contact = new Contact(split[1], split[2]);
                }
                this.contacts.add(contact);
                this.fireContactJoinedEvent(contact);
            } else if (lines[i].startsWith("BYE")) {
                String[] split = StringUtils.splitOnSpace(lines[i]);
                if (split.length == 2) {
                    contact = this.findContact(split[1]);
                    this.contacts.remove(contact);
                    this.fireContactLeftEvent(contact);
                    if (this.contacts.isEmpty()) {
                        this.close();
                    }
                } else {
                    this.fireSessionTimedOutEvent();
                    this.close();
                }
            } else if (lines[i].startsWith("MSG")) {
                if (input.indexOf("TypingUser:") != -1) {
                    String trim = input.substring(input.indexOf("MSG"));
                    String content = StringUtils.splitSubstring(trim, "\r\n", 3);
                    this.fireContactIsTypingEvent(this.findContact(StringUtils.splitOnSpace(content)[1]));
                } else if (input.indexOf("text/plain") != -1) {
                    int index = input.indexOf("ANS") == -1 ? 2 : 3;
                    String[] contents = StringUtils.split(input, "\r\n", index);
                    String[] split = StringUtils.splitOnSpace(contents[index - 2]);
                    Contact contact2 = this.findContact(split[1]);
                    int count = Integer.parseInt(split[3]);
                    split = StringUtils.split(contents[index - 1], "\r\n\r\n", 2);
                    int text = count - (split[0].getBytes("UTF-8").length + 4);
                    this.fireMessageReceivedEvent(contact2, new String(split[1].getBytes("UTF-8"), 0, text, "UTF-8"));
                }
            }
            ++i;
        }
        return input;
    }

    public Contact[] getParticipants() {
        return this.contacts.toArray(new Contact[this.contacts.size()]);
    }

    public void sendMessage(String message) throws IOException {
        message = "MIME-Version: 1.0\r\nContent-Type: text/plain; charset=UTF-8\r\nX-MMS-IM-Format: FN=MS%20Sans%20Serif; EF=; CO=0; PF=0\r\n\r\n" + message;
        this.write("MSG", "N " + message.getBytes("UTF-8").length + "\r\n" + message, false);
    }

    public void sendTypingNotification() throws IOException {
        String message = "MIME-Version: 1.0\r\nContent-Type: text/x-msmsgscontrol\r\nTypingUser: " + this.email + "\r\n\r\n\r\n";
        this.write("MSG", "U " + message.length() + "\r\n" + message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatSessionListener(IChatSessionListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChatSessionListener(IChatSessionListener listener) {
        if (listener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(listener);
            }
        }
    }
}

