/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.datashare.nio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.datashare.events.IChannelConnectEvent;
import org.eclipse.ecf.datashare.events.IChannelDisconnectEvent;
import org.eclipse.ecf.datashare.events.IChannelEvent;
import org.eclipse.ecf.datashare.events.IChannelMessageEvent;
import org.eclipse.ecf.provider.datashare.nio.ChannelData;
import org.eclipse.ecf.provider.datashare.nio.Messages;
import org.eclipse.ecf.provider.datashare.nio.NIODatashareContainer;
import org.eclipse.ecf.provider.datashare.nio.Util;

public abstract class NIOChannel
implements IChannel {
    private NIODatashareContainer datashareContainer;
    private final ID containerId;
    private final ID id;
    private ServerSocketChannel serverSocketChannel;
    private final int localPort;
    private Map connectedSockets;
    private List pendingSockets;
    private LinkedList messages;
    private IChannelListener listener;
    private Thread processingThread;

    public NIOChannel(NIODatashareContainer datashareContainer, ID containerId, ID id, IChannelListener listener) throws ECFException {
        Assert.isNotNull((Object)datashareContainer, (String)"Datashare container cannot be null");
        Assert.isNotNull((Object)containerId, (String)"Container id cannot be null");
        Assert.isNotNull((Object)id, (String)"Channel id cannot be null");
        this.datashareContainer = datashareContainer;
        this.containerId = containerId;
        this.id = id;
        this.listener = listener;
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
        }
        catch (IOException e) {
            throw new ECFException((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", Messages.NIOChannel_CouldNotCreateServerSocket, (Throwable)e));
        }
        try {
            ServerSocket socket = this.serverSocketChannel.socket();
            socket.bind(this.getBindAddress(), this.getBackLog());
        }
        catch (IOException e) {
            throw new ECFException((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", Messages.NIOChannel_BindOperationFailed, (Throwable)e));
        }
        this.localPort = this.serverSocketChannel.socket().getLocalPort();
        this.connectedSockets = new HashMap();
        this.pendingSockets = new ArrayList();
        this.messages = new LinkedList();
        this.processingThread = new Thread((Runnable)new ProcessingRunnable(), String.valueOf(this.getClass().getName()) + "Thread-" + id.toString());
        this.processingThread.start();
    }

    void fireChannelConnectEvent(final ID containerId) {
        IChannelListener listener = this.getListener();
        if (listener != null) {
            this.fireChannelEvent(listener, (IChannelEvent)new IChannelConnectEvent(){

                public ID getChannelID() {
                    return NIOChannel.this.id;
                }

                public ID getTargetID() {
                    return containerId;
                }

                public String toString() {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("IChannelConnectEvent[");
                    buffer.append("channel=").append(NIOChannel.this.id);
                    buffer.append(",target=").append(containerId).append(']');
                    return buffer.toString();
                }
            });
        }
    }

    void fireChannelDisconnectEvent(final ID containerId) {
        IChannelListener listener = this.getListener();
        if (listener != null) {
            this.fireChannelEvent(listener, (IChannelEvent)new IChannelDisconnectEvent(){

                public ID getChannelID() {
                    return NIOChannel.this.id;
                }

                public ID getTargetID() {
                    return containerId;
                }

                public String toString() {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("IChannelDisconnectEvent[");
                    buffer.append("channel=").append(NIOChannel.this.id);
                    buffer.append(",target=").append(containerId).append(']');
                    return buffer.toString();
                }
            });
        }
    }

    protected abstract void log(IStatus var1);

    protected SocketAddress getBindAddress() {
        return null;
    }

    protected int getBackLog() {
        return 0;
    }

    private void sendPendingMessages() {
        HashSet<ID> deadSockets = null;
        LinkedList<ChannelMessage> processedMessages = null;
        Iterator it = this.messages.iterator();
        while (it.hasNext()) {
            ChannelMessage message = (ChannelMessage)it.next();
            ID id = message.getId();
            SocketChannel channel = (SocketChannel)this.connectedSockets.get(id);
            if (channel == null) continue;
            byte[] data = message.getData();
            try {
                channel.configureBlocking(true);
                channel.socket().getOutputStream().write(data);
                channel.socket().getOutputStream().flush();
                channel.configureBlocking(false);
            }
            catch (IOException e) {
                this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "Error occurred while sending message", (Throwable)e));
                if (deadSockets == null) {
                    deadSockets = new HashSet<ID>();
                }
                deadSockets.add(id);
            }
            if (processedMessages == null) {
                processedMessages = new LinkedList<ChannelMessage>();
            }
            processedMessages.add(message);
        }
        if (processedMessages != null) {
            this.messages.removeAll(processedMessages);
        }
        if (deadSockets != null) {
            it = deadSockets.iterator();
            while (it.hasNext()) {
                ID id = (ID)it.next();
                SocketChannel channel = (SocketChannel)this.connectedSockets.remove(id);
                Util.closeChannel(channel);
            }
        }
    }

    private void processIncomingMessages(ByteBuffer buffer) throws IOException {
        HashSet deadSockets = null;
        Iterator it = this.connectedSockets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            SocketChannel socketChannel = (SocketChannel)entry.getValue();
            try {
                if (this.processIncomingMessages(socketChannel, buffer)) continue;
                if (deadSockets == null) {
                    deadSockets = new HashSet();
                }
                deadSockets.add(entry.getKey());
            }
            catch (IOException e) {
                this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "Error occurred while sending message", (Throwable)e));
                if (deadSockets == null) {
                    deadSockets = new HashSet();
                }
                deadSockets.add(entry.getKey());
            }
        }
        if (deadSockets != null) {
            it = deadSockets.iterator();
            while (it.hasNext()) {
                ID id = (ID)it.next();
                SocketChannel channel = (SocketChannel)this.connectedSockets.remove(id);
                Util.closeChannel(channel);
            }
        }
    }

    private boolean processIncomingMessages(SocketChannel socketChannel, ByteBuffer buffer) throws IOException {
        ChannelData channelData = Util.read(socketChannel, buffer);
        byte[] message = channelData.getData();
        if (message != null) {
            this.processIncomingMessage(socketChannel, message);
        }
        return channelData.isOpen();
    }

    void processIncomingMessage(SocketChannel socketChannel, byte[] message) {
        byte[][] messages;
        IChannelListener listener = this.getListener();
        if (listener != null && (messages = this.convert(message)) != null) {
            this.fireMessageEvents(listener, socketChannel, messages);
        }
    }

    private byte[][] convert(byte[] message) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(message);
            byte[] bytes = (byte[])new ObjectInputStream(bais).readObject();
            if (bais.available() == 0) {
                return new byte[][]{bytes};
            }
            ArrayList<byte[]> c = new ArrayList<byte[]>();
            c.add(bytes);
            while (bais.available() != 0) {
                bytes = (byte[])new ObjectInputStream(bais).readObject();
                c.add(bytes);
            }
            return (byte[][])c.toArray((T[])new byte[c.size()][]);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private void fireMessageEvents(IChannelListener listener, SocketChannel socketChannel, byte[][] messages) {
        int i = 0;
        while (i < messages.length) {
            IChannelEvent event = this.createMessageEvent(socketChannel, messages[i]);
            if (event != null) {
                this.fireChannelEvent(listener, event);
            }
            ++i;
        }
    }

    private void fireChannelEvent(final IChannelListener listener, final IChannelEvent event) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                listener.handleChannelEvent(event);
            }

            public void handleException(Throwable t) {
                NIOChannel.this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "Error handling channel event", t));
            }
        });
    }

    private IChannelEvent createMessageEvent(SocketChannel channel, final byte[] data) {
        Iterator it = this.connectedSockets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (channel != entry.getValue()) continue;
            final ID fromId = (ID)entry.getKey();
            return new IChannelMessageEvent(){

                public byte[] getData() {
                    return data;
                }

                public ID getFromContainerID() {
                    return fromId;
                }

                public ID getChannelID() {
                    return NIOChannel.this.id;
                }

                public String toString() {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("IChannelMessageEvent[");
                    buffer.append("container=").append(fromId);
                    buffer.append(",channel=").append(NIOChannel.this.id);
                    buffer.append(",data=").append(data).append(']');
                    return buffer.toString();
                }
            };
        }
        return null;
    }

    void put(ID id, SocketChannel socketChannel) {
        this.connectedSockets.put(id, socketChannel);
    }

    private boolean handshake(SocketChannel socketChannel, ByteBuffer buffer) throws ClassNotFoundException, IOException {
        ChannelData data = Util.read(socketChannel, buffer);
        if (!data.isOpen()) {
            Util.closeChannel(socketChannel);
            return true;
        }
        byte[] bytes = data.getData();
        if (bytes == null) {
            return false;
        }
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object object = ois.readObject();
        if (object instanceof ID) {
            socketChannel.configureBlocking(true);
            byte[] one = Util.serialize(this.id);
            byte[] two = Util.serialize(this.containerId);
            bytes = new byte[one.length + two.length];
            System.arraycopy(one, 0, bytes, 0, one.length);
            System.arraycopy(two, 0, bytes, one.length, two.length);
            socketChannel.socket().getOutputStream().write(bytes);
            socketChannel.socket().getOutputStream().flush();
            socketChannel.configureBlocking(false);
            this.put((ID)object, socketChannel);
        }
        return true;
    }

    protected final int getLocalPort() {
        return this.localPort;
    }

    protected abstract void sendRequest(ID var1) throws ECFException;

    public void sendMessage(byte[] message) throws ECFException {
        throw new ECFException((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", Messages.NIOChannel_ReceiverUnspecified));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ID receiver, byte[] message) throws ECFException {
        Assert.isNotNull((Object)receiver, (String)"A receiver must be specified");
        Assert.isNotNull((Object)message, (String)"Message cannot be null");
        if (!this.connectedSockets.containsKey(receiver)) {
            this.sendRequest(receiver);
        }
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            this.messages.add(new ChannelMessage(receiver, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.processingThread.interrupt();
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (IOException iOException) {
            this.serverSocketChannel = null;
        }
        Map map = this.connectedSockets;
        synchronized (map) {
            Iterator it = this.connectedSockets.values().iterator();
            while (it.hasNext()) {
                SocketChannel socket = (SocketChannel)it.next();
                Util.closeChannel(socket);
            }
            this.connectedSockets.clear();
        }
        this.datashareContainer.fireChannelContainerDeactivatedEvent(this.id);
    }

    public IChannelListener getListener() {
        return this.listener;
    }

    public IChannelListener setListener(IChannelListener listener) {
        IChannelListener previous = this.listener;
        this.listener = listener;
        return previous;
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    public ID getID() {
        return this.id;
    }

    private final class ChannelMessage {
        private ID fromId;
        private byte[] data;

        ChannelMessage(ID fromId, byte[] data) throws ECFException {
            this.fromId = fromId;
            this.data = this.convert(data);
        }

        private byte[] convert(byte[] data) throws ECFException {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(data);
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new ECFException((Throwable)e);
            }
        }

        public ID getId() {
            return this.fromId;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    private final class ProcessingRunnable
    implements Runnable {
        private ProcessingRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(50L);
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        int i22 = 0;
                        while (i22 < NIOChannel.this.pendingSockets.size()) {
                            SocketChannel channel = (SocketChannel)NIOChannel.this.pendingSockets.get(i22);
                            if (NIOChannel.this.handshake(channel, buffer)) {
                                NIOChannel.this.pendingSockets.remove(i22);
                                --i22;
                            }
                            ++i22;
                        }
                        NIOChannel.this.processIncomingMessages(buffer);
                        LinkedList i22 = NIOChannel.this.messages;
                        synchronized (i22) {
                            if (!NIOChannel.this.messages.isEmpty()) {
                                NIOChannel.this.sendPendingMessages();
                            }
                        }
                        SocketChannel socketChannel = NIOChannel.this.serverSocketChannel.accept();
                        if (socketChannel == null) continue;
                        socketChannel.configureBlocking(false);
                        NIOChannel.this.pendingSockets.add(socketChannel);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    return;
                }
                catch (ClassNotFoundException e) {
                    NIOChannel.this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "Could not deserialize", (Throwable)e));
                    continue;
                }
                catch (IOException e) {
                    NIOChannel.this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "An IO error occurred", (Throwable)e));
                    continue;
                }
                catch (RuntimeException e) {
                    NIOChannel.this.log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare.nio", "A runtime error occurred", (Throwable)e));
                    continue;
                }
                break;
            }
        }
    }
}

