/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.r_osgi;

import ch.ethz.iks.r_osgi.RemoteOSGiService;
import ch.ethz.iks.r_osgi.RemoteServiceEvent;
import ch.ethz.iks.r_osgi.RemoteServiceListener;
import ch.ethz.iks.r_osgi.RemoteServiceReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisposeEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.provider.r_osgi.Activator;
import org.eclipse.ecf.internal.provider.r_osgi.LocalRemoteServiceReferenceImpl;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteFilterImpl;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteServiceImpl;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteServiceReferenceImpl;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiID;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiNamespace;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceRegisteredEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

final class R_OSGiRemoteServiceContainer
implements IRemoteServiceContainerAdapter,
IContainer,
RemoteServiceListener {
    private BundleContext context;
    private RemoteOSGiService remoteService;
    private final List containerListeners = new ArrayList(0);
    R_OSGiID containerID;
    private R_OSGiID connectedID;
    private ServiceTracker remoteServicesTracker;
    private Map remoteServicesRegs = new HashMap(0);
    private Map remoteServiceListeners = new HashMap(0);
    private IConnectContext connectContext;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public R_OSGiRemoteServiceContainer(RemoteOSGiService service, ID containerID) throws IDCreateException {
        Assert.isNotNull((Object)service);
        Assert.isNotNull((Object)containerID);
        this.context = Activator.getDefault().getContext();
        this.remoteService = service;
        if (containerID instanceof StringID) {
            this.containerID = new R_OSGiID(((StringID)containerID).getName());
        } else if (containerID instanceof R_OSGiID) {
            this.containerID = (R_OSGiID)containerID;
        } else {
            throw new IDCreateException("Incompatible ID " + containerID);
        }
        this.startRegTracker();
    }

    private void startRegTracker() {
        try {
            String filter = "(ecf.rsvc.cid=" + (Object)((Object)this.containerID) + ")";
            this.remoteServicesTracker = new ServiceTracker(this.context, this.context.createFilter(filter), new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public void removedService(ServiceReference reference, Object service) {
                }
            });
            this.remoteServicesTracker.open();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void addRemoteServiceListener(final IRemoteServiceListener listener) {
        Assert.isNotNull((Object)listener);
        RemoteServiceListener l = new RemoteServiceListener(){

            public void remoteServiceEvent(RemoteServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        listener.handleServiceEvent((IRemoteServiceEvent)new IRemoteServiceRegisteredEvent(this, event){
                            IRemoteServiceReference reference;
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ RemoteServiceEvent val$event;
                            {
                                this.this$1 = var1_1;
                                this.val$event = remoteServiceEvent;
                                this.reference = new RemoteServiceReferenceImpl(2.access$0(var1_1).createRemoteServiceID(remoteServiceEvent.getRemoteReference()), remoteServiceEvent.getRemoteReference());
                            }

                            public String[] getClazzes() {
                                return this.val$event.getRemoteReference().getServiceInterfaces();
                            }

                            public ID getContainerID() {
                                return this.getReference().getContainerID();
                            }

                            public IRemoteServiceReference getReference() {
                                return this.reference;
                            }

                            public String toString() {
                                return "RemoteServiceRegisteredEvent(" + (Object)((Object)2.access$0(this.this$1).containerID) + "," + this.getReference();
                            }

                            public ID getLocalContainerID() {
                                return 2.access$0(this.this$1).getID();
                            }
                        });
                        return;
                    }
                    case 4: {
                        listener.handleServiceEvent((IRemoteServiceEvent)new IRemoteServiceUnregisteredEvent(this, event){
                            IRemoteServiceReference reference;
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ RemoteServiceEvent val$event;
                            {
                                this.this$1 = var1_1;
                                this.val$event = remoteServiceEvent;
                                this.reference = new RemoteServiceReferenceImpl(2.access$0(var1_1).createRemoteServiceID(remoteServiceEvent.getRemoteReference()), remoteServiceEvent.getRemoteReference());
                            }

                            public String[] getClazzes() {
                                return this.val$event.getRemoteReference().getServiceInterfaces();
                            }

                            public ID getContainerID() {
                                return 2.access$0(this.this$1).containerID;
                            }

                            public IRemoteServiceReference getReference() {
                                return this.reference;
                            }

                            public String toString() {
                                return "RemoteServiceUnregisteredEvent(" + (Object)((Object)2.access$0(this.this$1).containerID) + "," + this.getReference();
                            }

                            public ID getLocalContainerID() {
                                return 2.access$0(this.this$1).getID();
                            }
                        });
                        return;
                    }
                }
            }

            static /* synthetic */ R_OSGiRemoteServiceContainer access$0(2 var0) {
                return var0.R_OSGiRemoteServiceContainer.this;
            }
        };
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.ethz.iks.r_osgi.RemoteServiceListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceRegistration reg = this.context.registerService(clazz.getName(), (Object)l, null);
        this.remoteServiceListeners.put(listener, reg);
    }

    public IRemoteService getRemoteService(IRemoteServiceReference reference) {
        Assert.isNotNull((Object)reference);
        if (!(reference instanceof RemoteServiceReferenceImpl)) {
            return null;
        }
        RemoteServiceReferenceImpl impl = (RemoteServiceReferenceImpl)reference;
        Object rs = this.remoteService.getRemoteService(impl.getR_OSGiServiceReference());
        if (rs == null) {
            return null;
        }
        return new RemoteServiceImpl(impl, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference[] getRemoteServiceReferences(ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException {
        IRemoteFilter remoteFilter;
        if (clazz == null) {
            return null;
        }
        IRemoteFilter iRemoteFilter = remoteFilter = filter == null ? null : this.createRemoteFilter(filter);
        if (idFilter == null) {
            IRemoteServiceReference[] refs = this.getRemoteServiceReferencesConnected(clazz, remoteFilter).toArray(new IRemoteServiceReference[0]);
            return refs.length == 0 ? null : refs;
        }
        R_OSGiRemoteServiceContainer r_OSGiRemoteServiceContainer = this;
        synchronized (r_OSGiRemoteServiceContainer) {
            ArrayList results = new ArrayList();
            int i = 0;
            while (i < idFilter.length) {
                results.addAll(this.connectAndGetRemoteServiceReferencesForTarget(this.getConnectedID(), idFilter[i], clazz, remoteFilter));
                ++i;
            }
            IRemoteServiceReference[] refs = results.toArray(new IRemoteServiceReference[0]);
            IRemoteServiceReference[] iRemoteServiceReferenceArray = refs.length == 0 ? null : refs;
            return iRemoteServiceReferenceArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference[] getRemoteServiceReferences(ID targetID, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        if (clazz == null) {
            return null;
        }
        IRemoteFilter remoteFilter = filter == null ? null : this.createRemoteFilter(filter);
        R_OSGiRemoteServiceContainer r_OSGiRemoteServiceContainer = this;
        synchronized (r_OSGiRemoteServiceContainer) {
            List results;
            block5: {
                results = new ArrayList();
                this.connect(targetID, this.connectContext);
                results = this.getRemoteServiceReferencesConnected(clazz, remoteFilter);
                if (results != null && results.size() != 0) break block5;
                return null;
            }
            return results.toArray(new IRemoteServiceReference[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference[] getAllRemoteServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        RemoteServiceReference[] refs;
        IRemoteFilter remoteFilter;
        ArrayList<IRemoteServiceReference> results = new ArrayList<IRemoteServiceReference>();
        Map map = this.remoteServicesRegs;
        synchronized (map) {
            Iterator i1 = this.remoteServicesRegs.keySet().iterator();
            while (i1.hasNext()) {
                ServiceReference ref = (ServiceReference)i1.next();
                Dictionary refProperties = this.prepareProperties(ref);
                if (clazz == null) {
                    results.add(this.createLocalRemoteServiceReference(ref));
                    continue;
                }
                IRemoteFilter rf = this.createRemoteFilter(filter != null ? "(&" + filter + "(" + "objectClass" + "=" + clazz + "))" : "(objectClass=" + clazz + ")");
                if (!rf.match(refProperties)) continue;
                results.add(this.createLocalRemoteServiceReference(ref));
            }
        }
        IRemoteFilter iRemoteFilter = remoteFilter = filter == null ? null : this.createRemoteFilter(filter);
        if (this.getConnectedID() != null && (refs = this.remoteService.getRemoteServiceReferences(this.connectedID.getURI(), clazz, (Filter)remoteFilter)) != null) {
            int i = 0;
            while (i < refs.length) {
                results.add(new RemoteServiceReferenceImpl(this.createRemoteServiceID(refs[i]), refs[i]));
                ++i;
            }
        }
        return results.toArray(new IRemoteServiceReference[0]);
    }

    private IRemoteServiceReference createLocalRemoteServiceReference(ServiceReference ref) {
        return new LocalRemoteServiceReferenceImpl(this.createRemoteServiceID(this.containerID, (Long)ref.getProperty("service.id")), ref);
    }

    private List connectAndGetRemoteServiceReferencesForTarget(ID currentlyConnectedID, ID targetID, String clazz, IRemoteFilter remoteFilter) {
        ArrayList results = new ArrayList();
        if (currentlyConnectedID != null) {
            if (targetID.equals((Object)currentlyConnectedID)) {
                results.addAll(this.getRemoteServiceReferencesConnected(clazz, remoteFilter));
            } else {
                this.disconnect();
                results.addAll(this.connectAndGetRemoteServiceReferencesForTarget(targetID, clazz, remoteFilter, true));
                try {
                    this.connect(currentlyConnectedID, this.connectContext);
                }
                catch (ContainerConnectException e) {
                    this.logException("connectAndGetRemoteServiceReferencesForTarget.  Could not reconnect to " + currentlyConnectedID, e);
                }
            }
        } else {
            results.addAll(this.connectAndGetRemoteServiceReferencesForTarget(targetID, clazz, remoteFilter, false));
        }
        return results;
    }

    private List connectAndGetRemoteServiceReferencesForTarget(ID targetID, String clazz, IRemoteFilter remoteFilter, boolean doDisconnect) {
        ArrayList results = new ArrayList();
        try {
            this.connect(targetID, this.connectContext);
            results.addAll(this.getRemoteServiceReferencesConnected(clazz, remoteFilter));
            if (doDisconnect) {
                this.disconnect();
            }
        }
        catch (ContainerConnectException e) {
            this.logException("connectAndGetRemoteServiceReferencesForTarget=" + targetID + ",class=" + clazz + ",remoteFilter=" + remoteFilter, e);
        }
        return results;
    }

    private void logException(String message, Throwable e) {
        System.err.println(message);
        if (e != null) {
            e.printStackTrace(System.err);
        }
    }

    private synchronized List getRemoteServiceReferencesConnected(String clazz, IRemoteFilter filter) {
        ArrayList<RemoteServiceReferenceImpl> results = new ArrayList<RemoteServiceReferenceImpl>();
        RemoteServiceReference[] refs = this.remoteService.getRemoteServiceReferences(this.connectedID.getURI(), clazz, (Filter)filter);
        if (refs == null) {
            return results;
        }
        int i = 0;
        while (i < refs.length) {
            results.add(new RemoteServiceReferenceImpl(this.createRemoteServiceID(refs[i]), refs[i]));
            ++i;
        }
        return results;
    }

    IRemoteServiceID createRemoteServiceID(R_OSGiID cID, Long l) {
        return (IRemoteServiceID)IDFactory.getDefault().createID(this.getRemoteServiceNamespace(), new Object[]{cID, l});
    }

    IRemoteServiceID createRemoteServiceID(RemoteServiceReference rref) {
        return this.createRemoteServiceID(new R_OSGiID(rref.getURI().toString()), (Long)rref.getProperty("service.id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties) {
        if (this.containerID == null) {
            throw new IllegalStateException("Container is not connected");
        }
        Hashtable props = properties == null ? new Hashtable() : this.clone(properties);
        ((Dictionary)props).put("service.remote.registration", Boolean.TRUE);
        ((Dictionary)props).remove("osgi.remote.interfaces");
        ((Dictionary)props).put("ecf.rsvc.cid", this.containerID);
        ((Dictionary)props).put("ecf.robjectClass", clazzes);
        Integer serviceRanking = (Integer)((Dictionary)props).get("ecf.rsvc.ranking");
        serviceRanking = serviceRanking == null ? new Integer(0) : serviceRanking;
        ((Dictionary)props).put("ecf.rsvc.ranking", serviceRanking);
        ServiceRegistration reg = this.context.registerService(clazzes, service, (Dictionary)props);
        reg.setProperties(this.prepareProperties(reg.getReference()));
        Map map = this.remoteServicesRegs;
        synchronized (map) {
            this.remoteServicesRegs.put(reg.getReference(), reg);
        }
        return new RemoteServiceRegistrationImpl(this.createRemoteServiceID(this.containerID, (Long)reg.getReference().getProperty("service.id")), reg);
    }

    Dictionary prepareProperties(ServiceReference reference) {
        String[] propKeys = reference.getPropertyKeys();
        Properties newDictionary = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            Object v = reference.getProperty(propKeys[i]);
            ((Dictionary)newDictionary).put(propKeys[i], v);
            if ("service.id".equals(propKeys[i])) {
                ((Dictionary)newDictionary).put("ecf.rsvc.id", v);
            }
            ++i;
        }
        return newDictionary;
    }

    public void removeRemoteServiceListener(IRemoteServiceListener listener) {
        this.remoteServiceListeners.remove(listener);
    }

    public boolean ungetRemoteService(IRemoteServiceReference reference) {
        if (!(reference instanceof RemoteServiceReferenceImpl)) {
            return false;
        }
        RemoteServiceReferenceImpl impl = (RemoteServiceReferenceImpl)reference;
        RemoteServiceReference rsr = impl.getR_OSGiServiceReference();
        if (!rsr.isActive()) {
            return false;
        }
        this.remoteService.ungetRemoteService(rsr);
        return true;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        return null;
    }

    public void addListener(IContainerListener listener) {
        this.containerListeners.add(listener);
    }

    public synchronized void connect(ID targetID, IConnectContext cc) throws ContainerConnectException {
        if (targetID == null) {
            throw new ContainerConnectException("targetID may not be null");
        }
        if (!(targetID instanceof R_OSGiID) && !(targetID instanceof StringID)) {
            throw new ContainerConnectException("targetID is of incorrect type for this container: " + targetID.toString());
        }
        if (this.connectedID != null) {
            throw new ContainerConnectException("Container is already connected to " + (Object)((Object)this.connectedID));
        }
        this.connectContext = cc;
        try {
            R_OSGiID target;
            if (targetID instanceof StringID) {
                target = new R_OSGiID(((StringID)targetID).getName());
            } else if (targetID instanceof R_OSGiID) {
                target = (R_OSGiID)targetID;
            } else {
                throw new ContainerConnectException("Incompatible target id " + targetID);
            }
            this.fireListeners((IContainerEvent)new ContainerConnectingEvent((ID)this.containerID, (ID)this.connectedID));
            RemoteServiceReference[] refs = this.doConnect(target);
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    this.checkImport(refs[i]);
                    ++i;
                }
            }
            this.connectedID = target;
            this.startRegTracker();
        }
        catch (IOException ioe) {
            throw new ContainerConnectException((Throwable)ioe);
        }
        catch (IDCreateException e) {
            throw new ContainerConnectException((Throwable)e);
        }
        this.fireListeners((IContainerEvent)new ContainerConnectedEvent((ID)this.containerID, (ID)this.connectedID));
    }

    private RemoteServiceReference[] doConnect(R_OSGiID targetID) throws IOException {
        return this.remoteService.connect(targetID.getURI());
    }

    private void doDisconnect(R_OSGiID targetID) {
        this.remoteService.disconnect(targetID.getURI());
    }

    public synchronized void disconnect() {
        if (this.connectedID != null) {
            this.fireListeners((IContainerEvent)new ContainerDisconnectingEvent((ID)this.containerID, (ID)this.connectedID));
            this.doDisconnect(this.connectedID);
            this.connectedID = null;
            this.remoteService = null;
            this.fireListeners((IContainerEvent)new ContainerDisconnectedEvent((ID)this.containerID, (ID)this.connectedID));
        }
    }

    public void dispose() {
        int i;
        if (this.remoteServicesTracker != null) {
            ServiceReference[] refs = this.remoteServicesTracker.getServiceReferences();
            if (refs != null) {
                i = 0;
                while (i < refs.length) {
                    ServiceRegistration reg = (ServiceRegistration)this.remoteServicesRegs.get(refs[i]);
                    if (reg != null) {
                        reg.unregister();
                    }
                    ++i;
                }
            }
            this.remoteServicesTracker.close();
            this.remoteServicesTracker = null;
        }
        ServiceRegistration[] lstn = this.remoteServiceListeners.values().toArray(new ServiceRegistration[this.remoteServiceListeners.size()]);
        i = 0;
        while (i < lstn.length) {
            try {
                lstn[i].unregister();
            }
            catch (Throwable throwable) {}
            ++i;
        }
        if (this.connectedID != null) {
            this.disconnect();
        }
        this.fireListeners((IContainerEvent)new ContainerDisposeEvent((ID)this.containerID));
        this.containerListeners.clear();
    }

    public Namespace getConnectNamespace() {
        return R_OSGiNamespace.getDefault();
    }

    public synchronized ID getConnectedID() {
        return this.connectedID;
    }

    public void removeListener(IContainerListener listener) {
        this.containerListeners.remove(listener);
    }

    public ID getID() {
        return this.containerID;
    }

    private void fireListeners(final IContainerEvent event) {
        final IContainerListener[] listeners = this.containerListeners.toArray(new IContainerListener[this.containerListeners.size()]);
        new Thread(){

            public void run() {
                int i = 0;
                while (i < listeners.length) {
                    listeners[i].handleEvent(event);
                    ++i;
                }
            }
        }.start();
    }

    public void remoteServiceEvent(RemoteServiceEvent event) {
        if (event.getType() == 1) {
            this.checkImport(event.getRemoteReference());
        }
    }

    private void checkImport(RemoteServiceReference ref) {
        Object target = ref.getProperty("ecf.rsvc.reg.targets");
        if (target instanceof ID && ((ID)target).equals((Object)this.containerID)) {
            this.remoteService.getRemoteService(ref);
        } else if (target instanceof ID[]) {
            ID[] targets = (ID[])target;
            int i = 0;
            while (i < targets.length) {
                if (targets[i].equals((Object)this.containerID)) {
                    this.remoteService.getRemoteService(ref);
                }
                ++i;
            }
        }
    }

    private Hashtable clone(Dictionary props) {
        Hashtable clone = new Hashtable();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            clone.put(key, props.get(key));
        }
        return clone;
    }

    public IFuture asyncGetRemoteServiceReferences(final ID[] idFilter, final String clazz, final String filter) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return R_OSGiRemoteServiceContainer.this.getRemoteServiceReferences(idFilter, clazz, filter);
            }
        }, null);
    }

    public IFuture asyncGetRemoteServiceReferences(final ID target, final String clazz, final String filter) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return R_OSGiRemoteServiceContainer.this.getRemoteServiceReferences(target, clazz, filter);
            }
        }, null);
    }

    public Namespace getRemoteServiceNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.namespace.r_osgi.remoteservice");
    }

    public IRemoteFilter createRemoteFilter(String filter) throws InvalidSyntaxException {
        return new RemoteFilterImpl(this.context, filter);
    }

    public IRemoteServiceID getRemoteServiceID(ID containerId, long containerRelativeId) {
        return (IRemoteServiceID)IDFactory.getDefault().createID(this.getRemoteServiceNamespace(), new Object[]{this.containerID, new Long(containerRelativeId)});
    }

    public IRemoteServiceReference getRemoteServiceReference(IRemoteServiceID serviceId) {
        if (serviceId == null) {
            return null;
        }
        ID cID = serviceId.getContainerID();
        if (cID instanceof R_OSGiID && cID.equals((Object)this.getConnectedID())) {
            RemoteServiceReference[] refs;
            block5: {
                String filter = "(service.id=" + serviceId + ")";
                try {
                    refs = this.remoteService.getRemoteServiceReferences(((R_OSGiID)cID).getURI(), null, this.context.createFilter(filter));
                    if (refs != null && refs.length != 0) break block5;
                    return null;
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    return null;
                }
            }
            return new RemoteServiceReferenceImpl(this.createRemoteServiceID(refs[0]), refs[0]);
        }
        return null;
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.connectContext = connectContext;
    }
}

