/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.sync.doc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.internal.sync.Activator;
import org.eclipse.ecf.sync.IModelChange;
import org.eclipse.ecf.sync.IModelChangeMessage;
import org.eclipse.ecf.sync.ModelUpdateException;
import org.eclipse.ecf.sync.SerializationException;
import org.eclipse.ecf.sync.doc.IDocumentChange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentChangeMessage
implements IDocumentChange,
IModelChangeMessage,
Serializable {
    private static final long serialVersionUID = -3195542805471664496L;
    private String text;
    private int offset;
    private int length;

    public static DocumentChangeMessage deserialize(byte[] bytes) throws SerializationException {
        try {
            ByteArrayInputStream bins = new ByteArrayInputStream(bytes);
            ObjectInputStream oins = new ObjectInputStream(bins);
            return (DocumentChangeMessage)oins.readObject();
        }
        catch (Exception e) {
            throw new SerializationException("Exception deserializing DocumentChangeMessage", e);
        }
    }

    public DocumentChangeMessage(int offset, int length, String text) {
        this.offset = offset;
        this.length = length;
        this.text = text;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int updatedOffset) {
        this.offset = updatedOffset;
    }

    public int getLengthOfReplacedText() {
        return this.length;
    }

    public void setLengthOfReplacedText(int length) {
        this.length = length;
    }

    public String getText() {
        return this.text;
    }

    public int getLengthOfInsertedText() {
        return this.text.length();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DocumentChangeMessage[");
        buf.append("offset=").append(this.offset);
        buf.append(";length=").append(this.length).append(";text=").append(this.text).append("]");
        return buf.toString();
    }

    private byte[] serializeLocal() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this);
        return bos.toByteArray();
    }

    public byte[] serialize() throws SerializationException {
        try {
            return this.serializeLocal();
        }
        catch (IOException e) {
            throw new SerializationException("Exception serializing DocumentChangeMessage", e);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        IAdapterManager manager = Activator.getDefault().getAdapterManager();
        if (manager == null) {
            return null;
        }
        return manager.loadAdapter((Object)this, adapter.getName());
    }

    public void applyToModel(Object model) throws ModelUpdateException {
        if (model == null) {
            throw new ModelUpdateException("Model cannot be null", (IModelChange)this, null);
        }
        if (model instanceof IDocument) {
            try {
                ((IDocument)model).replace(this.getOffset(), this.getLengthOfReplacedText(), this.getText());
            }
            catch (BadLocationException badLocationException) {
                throw new ModelUpdateException("Exception applying change to document", (IModelChange)this, model);
            }
        } else {
            throw new ModelUpdateException("Incorrect type of model to apply change", (IModelChange)this, model);
        }
    }
}

