/*
 * Decompiled with CFR 0.152.
 */
package com.mycorp.examples.timeservice.internal.provider.rest.host;

import com.mycorp.examples.timeservice.ITimeService;
import com.mycorp.examples.timeservice.internal.provider.rest.host.TimeServiceHttpServiceComponent;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.provider.RemoteServiceContainerInstantiator;
import org.eclipse.ecf.remoteservice.rest.identity.RestNamespace;
import org.eclipse.ecf.remoteservice.servlet.HttpServiceComponent;
import org.eclipse.ecf.remoteservice.servlet.RemoteServiceHttpServlet;
import org.eclipse.ecf.remoteservice.servlet.ServletServerContainer;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.http.NamespaceException;

public class TimeServiceServerContainer
extends ServletServerContainer {
    public static final String TIMESERVICE_HOST_CONFIG_NAME = "com.mycorp.examples.timeservice.rest.host";
    public static final String TIMESERVICE_SERVLET_NAME = "/" + ITimeService.class.getName();

    TimeServiceServerContainer(ID id) throws ServletException, NamespaceException {
        super(id);
        TimeServiceHttpServiceComponent.getDefault().registerServlet(TIMESERVICE_SERVLET_NAME, (Servlet)new TimeRemoteServiceHttpServlet(), null, null);
    }

    public void dispose() {
        TimeServiceHttpServiceComponent.getDefault().unregisterServlet(TIMESERVICE_SERVLET_NAME);
        super.dispose();
    }

    public Namespace getConnectNamespace() {
        return RestNamespace.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Instantiator
    extends RemoteServiceContainerInstantiator {
        public IContainer createInstance(ContainerTypeDescription description, Map<String, ?> parameters) throws ContainerCreateException {
            try {
                return new TimeServiceServerContainer(RestNamespace.INSTANCE.createInstance(new Object[]{(String)parameters.get("id")}));
            }
            catch (Exception e) {
                throw new ContainerCreateException("Could not create time service server", (Throwable)e);
            }
        }

        public String[] getSupportedConfigs(ContainerTypeDescription description) {
            return new String[]{TimeServiceServerContainer.TIMESERVICE_HOST_CONFIG_NAME};
        }
    }

    class TimeRemoteServiceHttpServlet
    extends RemoteServiceHttpServlet {
        private static final long serialVersionUID = 3906126401901826462L;

        TimeRemoteServiceHttpServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            ITimeService timeService = (ITimeService)HttpServiceComponent.getDefault().getService(ITimeService.class);
            Long currentTime = timeService.getCurrentTime();
            try {
                resp.getOutputStream().print(new JSONObject().put("time", (Object)currentTime).toString());
            }
            catch (JSONException e) {
                throw new ServletException("json response object could not be created for time service", (Throwable)e);
            }
        }
    }
}

