/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.LogUtility;
import org.eclipse.ecf.internal.osgi.services.distribution.RemoteServiceRegistration;
import org.eclipse.ecf.osgi.services.discovery.DiscoveredServiceNotification;
import org.eclipse.ecf.osgi.services.discovery.DiscoveredServiceTracker;
import org.eclipse.ecf.osgi.services.discovery.IRemoteServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.discovery.RemoteServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.discovery.ServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IProxyDistributionListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class DiscoveredServiceTrackerImpl
implements DiscoveredServiceTracker {
    private DistributionProviderImpl distributionProvider;
    private IExecutor executor;
    private List serviceLocations = new ArrayList();
    private Map discoveredRemoteServiceRegistrations = Collections.synchronizedMap(new HashMap());
    private List ecfRemoteServiceProperties = Arrays.asList("ecf.rsvc.id", "ecf.robjectClass", "ecf.rsvc.id", "ecf.rsvc.cid", "ecf.rsvc.ranking", "osgi.remote.endpoint.id", "osgi.remote.endpoint.interfaces", "osgi.remote.endpoint.location", "osgi.remote.service.interfaces", "osgi.remote.service.interfaces.version", "osgi.remote.discovery.publication.service.properties", "service.uri");
    static /* synthetic */ Class class$0;

    public DiscoveredServiceTrackerImpl(DistributionProviderImpl dp, IExecutor executor) {
        this.distributionProvider = dp;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serviceChanged(DiscoveredServiceNotification notification) {
        if (notification == null) {
            return;
        }
        int notificationType = notification.getType();
        switch (notificationType) {
            case 1: {
                RemoteServiceEndpointDescription adesc = null;
                try {
                    adesc = this.getECFDescription(notification.getServiceEndpointDescription());
                }
                catch (Exception e) {
                    this.logError("serviceChanged.AVAILABLE", "Error creating ECF endpoint description", e);
                    return;
                }
                if (adesc == null) {
                    return;
                }
                if (!this.isValidDescription(adesc)) {
                    this.trace("serviceChanged.AVAILABLE", "Duplicate or invalid description=" + adesc);
                    return;
                }
                final RemoteServiceEndpointDescription rsEndpointDescription = adesc;
                this.executor.execute(new IProgressRunnable(){

                    public Object run(IProgressMonitor monitor) throws Exception {
                        try {
                            DiscoveredServiceTrackerImpl.this.handleDiscoveredServiceAvailable(rsEndpointDescription, monitor);
                        }
                        catch (Exception e) {
                            DiscoveredServiceTrackerImpl.this.logError("handleDiscoveredServiceAvailble", "Unexpected exception with rsEndpointDescription=" + rsEndpointDescription, e);
                            throw e;
                        }
                        return null;
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
                return;
            }
            case 4: {
                try {
                    RemoteServiceEndpointDescription udesc = this.getECFDescription(notification.getServiceEndpointDescription());
                    if (udesc == null) {
                        return;
                    }
                    List list = this.serviceLocations;
                    synchronized (list) {
                        ServiceRegistration[] proxyServiceRegistrations = this.removeProxyServiceRegistrations((ServiceEndpointDescription)udesc);
                        if (proxyServiceRegistrations == null) return;
                        int i = 0;
                        while (i < proxyServiceRegistrations.length) {
                            this.trace("handleDiscoveredServiceUnavailable", "proxyServiceRegistrations=" + proxyServiceRegistrations[i] + ",serviceEndpointDesc=" + udesc);
                            this.unregisterProxyServiceRegistration((IRemoteServiceEndpointDescription)udesc, proxyServiceRegistrations[i]);
                            ++i;
                        }
                        this.removeDiscoveredServiceID(udesc);
                        return;
                    }
                }
                catch (Exception e) {
                    this.logError("serviceChanged", "UNAVAILABLE", e);
                }
                return;
            }
            case 2: {
                return;
            }
            case 8: {
                return;
            }
            default: {
                this.logWarning("serviceChanged", "DiscoveredServiceNotification type=" + notificationType + " not found.  Ignoring");
            }
        }
    }

    private void handleDiscoveredServiceAvailable(RemoteServiceEndpointDescription endpointDescription, IProgressMonitor monitor) {
        IRemoteServiceContainer[] rsContainers;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((rsContainers = this.findProxyContainers(endpointDescription)) == null || rsContainers.length == 0) {
            this.logWarning("handleDiscoveredServiceAvailable", "No local RemoteServiceContainers found for endpoint description=" + endpointDescription);
            return;
        }
        ID endpointID = endpointDescription.getEndpointAsID();
        String remoteServiceFilter = endpointDescription.getRemoteServicesFilter();
        Collection providedInterfaces = endpointDescription.getProvidedInterfaces();
        int i = 0;
        while (i < rsContainers.length) {
            Iterator j = providedInterfaces.iterator();
            while (j.hasNext()) {
                String providedInterface = (String)j.next();
                IRemoteServiceReference[] remoteReferences = null;
                this.firePreGetRemoteServiceReferences((IRemoteServiceEndpointDescription)endpointDescription, rsContainers[i]);
                try {
                    remoteReferences = rsContainers[i].getContainerAdapter().getRemoteServiceReferences(endpointID, providedInterface, remoteServiceFilter);
                }
                catch (ContainerConnectException e) {
                    this.logError("handleDiscoveredServiceAvailable", "rsca=" + rsContainers[i] + ",endpointId=" + endpointID + ",intf=" + providedInterface + ". Connect error in getRemoteServiceReferences", e);
                    continue;
                }
                catch (InvalidSyntaxException e) {
                    this.logError("handleDiscoveredServiceAvailable", "rsca=" + rsContainers[i] + ",endpointId=" + endpointID + ",intf=" + providedInterface + " Filter syntax error in getRemoteServiceReferences", e);
                    continue;
                }
                if (remoteReferences == null || remoteReferences.length == 0) {
                    this.logError("handleDiscoveredServiceAvailable", "getRemoteServiceReferences result is empty. containerHelper=" + rsContainers[i] + "remoteReferences=" + (remoteReferences == null ? "null" : Arrays.asList(remoteReferences).toString()), null);
                    continue;
                }
                this.registerRemoteServiceReferences(endpointDescription, rsContainers[i], remoteReferences);
            }
            ++i;
        }
    }

    private void firePreGetRemoteServiceReferences(final IRemoteServiceEndpointDescription endpointDescription, final IRemoteServiceContainer remoteServiceContainer) {
        IProxyDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getProxyDistributionListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IProxyDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        DiscoveredServiceTrackerImpl.this.logError("firePreGetRemoteServiceReferences", "Exception calling proxy distribution listener", exception);
                    }

                    public void run() throws Exception {
                        l.retrievingRemoteServiceReferences(endpointDescription, remoteServiceContainer);
                    }
                });
                ++i;
            }
        }
    }

    private void firePreRegister(final IRemoteServiceEndpointDescription endpointDescription, final IRemoteServiceContainer remoteServiceContainer, final IRemoteServiceReference remoteServiceReference) {
        IProxyDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getProxyDistributionListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IProxyDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        DiscoveredServiceTrackerImpl.this.logError("firePreRegister", "Exception calling proxy distribution listener", exception);
                    }

                    public void run() throws Exception {
                        l.registering(endpointDescription, remoteServiceContainer, remoteServiceReference);
                    }
                });
                ++i;
            }
        }
    }

    private void firePostRegister(final IRemoteServiceEndpointDescription endpointDescription, final IRemoteServiceContainer remoteServiceContainer, final IRemoteServiceReference remoteServiceReference, final ServiceRegistration serviceRegistration) {
        IProxyDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getProxyDistributionListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IProxyDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        DiscoveredServiceTrackerImpl.this.logError("firePreRegister", "Exception calling proxy distribution listener", exception);
                    }

                    public void run() throws Exception {
                        l.registered(endpointDescription, remoteServiceContainer, remoteServiceReference, serviceRegistration);
                    }
                });
                ++i;
            }
        }
    }

    private void fireUnregister(final IRemoteServiceEndpointDescription endpointDescription, final ServiceRegistration registration) {
        IProxyDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getProxyDistributionListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IProxyDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        DiscoveredServiceTrackerImpl.this.logError("fireUnregister", "Exception calling proxy distribution listener", exception);
                    }

                    public void run() throws Exception {
                        l.unregistered(endpointDescription, registration);
                    }
                });
                ++i;
            }
        }
    }

    private RemoteServiceEndpointDescription getECFDescription(ServiceEndpointDescription aServiceEndpointDesc) {
        RemoteServiceEndpointDescription ecfSED;
        if (!(aServiceEndpointDesc instanceof RemoteServiceEndpointDescription)) {
            IAdapterManager iAdapterManager = Activator.getDefault().getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.osgi.services.discovery.RemoteServiceEndpointDescription");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ecfSED = (RemoteServiceEndpointDescription)iAdapterManager.loadAdapter((Object)aServiceEndpointDesc, clazz.getName());
        } else {
            ecfSED = (RemoteServiceEndpointDescription)aServiceEndpointDesc;
        }
        return ecfSED;
    }

    private boolean findProxyServiceRegistration(RemoteServiceEndpointDescription sed) {
        Iterator i = this.discoveredRemoteServiceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            ID containerID = (ID)i.next();
            RemoteServiceRegistration reg = (RemoteServiceRegistration)this.discoveredRemoteServiceRegistrations.get(containerID);
            if (!sed.equals(reg.getServiceEndpointDescription())) continue;
            return true;
        }
        return false;
    }

    private ServiceRegistration[] removeProxyServiceRegistrations(ServiceEndpointDescription sed) {
        ArrayList results = new ArrayList();
        Iterator i = this.discoveredRemoteServiceRegistrations.keySet().iterator();
        while (i.hasNext()) {
            ID containerID = (ID)i.next();
            RemoteServiceRegistration reg = (RemoteServiceRegistration)this.discoveredRemoteServiceRegistrations.get(containerID);
            if (!sed.equals(reg.getServiceEndpointDescription())) continue;
            i.remove();
            results.addAll(reg.removeAllServiceRegistrations());
            reg.dispose();
        }
        return results.toArray(new ServiceRegistration[0]);
    }

    private void unregisterProxyServiceRegistration(IRemoteServiceEndpointDescription endpointDescription, ServiceRegistration reg) {
        try {
            this.distributionProvider.removeRemoteService(reg.getReference());
            reg.unregister();
        }
        catch (IllegalStateException e) {
            this.logWarning("unregisterProxyServiceRegistration", "Exception unregistering serviceRegistration=" + reg);
        }
        catch (Exception e) {
            this.logError("unregisterProxyServiceRegistration", "Exception unregistering serviceRegistration=" + reg, e);
        }
        this.fireUnregister(endpointDescription, reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRemoteServiceReferences(RemoteServiceEndpointDescription sed, IRemoteServiceContainer remoteServiceContainer, IRemoteServiceReference[] remoteReferences) {
        List list = this.serviceLocations;
        synchronized (list) {
            if (!this.containsDiscoveredServiceID(sed)) {
                this.logError("registerRemoteServiceReferences", "serviceLocation=" + sed + " no longer present", null);
                return;
            }
            if (this.findProxyServiceRegistration(sed)) {
                this.logError("registerRemoteServiceReferences", "serviceEndpointDesc=" + sed + " previously registered locally...ignoring", null);
                return;
            }
            int i = 0;
            while (i < remoteReferences.length) {
                IRemoteService remoteService = remoteServiceContainer.getContainerAdapter().getRemoteService(remoteReferences[i]);
                if (remoteService == null) {
                    this.logError("registerRemoteServiceReferences", "Remote service is null for remote reference " + remoteReferences[i], null);
                } else {
                    String[] clazzes = (String[])remoteReferences[i].getProperty("ecf.robjectClass");
                    if (clazzes == null || clazzes.length == 0) {
                        this.logError("registerRemoteServiceReferences", "No classes specified for remote service reference " + remoteReferences[i], null);
                    } else {
                        Dictionary properties = this.getPropertiesForRemoteService(sed, remoteServiceContainer, remoteReferences[i], remoteService);
                        Object proxy = null;
                        try {
                            proxy = remoteService.getProxy();
                            if (proxy == null) {
                                this.logError("registerRemoteServiceReferences", "Remote service proxy is null", null);
                            } else {
                                this.firePreRegister((IRemoteServiceEndpointDescription)sed, remoteServiceContainer, remoteReferences[i]);
                                this.trace("registerRemoteServiceReferences", "rsca=" + remoteServiceContainer + ",remoteReference=" + remoteReferences[i]);
                                ServiceRegistration registration = Activator.getDefault().getContext().registerService(clazzes, proxy, properties);
                                ID containerID = remoteServiceContainer.getContainer().getID();
                                RemoteServiceRegistration reg = (RemoteServiceRegistration)this.discoveredRemoteServiceRegistrations.get(containerID);
                                if (reg == null) {
                                    reg = new RemoteServiceRegistration(sed, remoteServiceContainer, new RemoteServiceReferenceUnregisteredListener());
                                    this.discoveredRemoteServiceRegistrations.put(containerID, reg);
                                }
                                reg.addServiceRegistration(remoteReferences[i], registration);
                                this.distributionProvider.addRemoteService(registration.getReference());
                                this.trace("addLocalServiceRegistration.COMPLETE", "containerHelper=" + remoteServiceContainer + ",remoteServiceReference=" + remoteReferences[i] + ",localServiceRegistration=" + registration);
                                this.firePostRegister((IRemoteServiceEndpointDescription)sed, remoteServiceContainer, remoteReferences[i], registration);
                            }
                        }
                        catch (Exception e) {
                            this.logError("registerRemoteServiceReferences", "Exception creating or registering remote reference " + remoteReferences[i], e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private boolean isRemoteServiceProperty(String propertyKey) {
        return this.ecfRemoteServiceProperties.contains(propertyKey);
    }

    private Dictionary getPropertiesForRemoteService(RemoteServiceEndpointDescription rsEndpointDescription, IRemoteServiceContainer rsContainer, IRemoteServiceReference rsReference, IRemoteService remoteService) {
        Properties props = new Properties();
        props.put("service.imported", remoteService);
        String[] serviceIntents = rsEndpointDescription.getServiceIntents();
        if (serviceIntents != null) {
            props.put("service.intents", serviceIntents);
        }
        String[] propKeys = rsReference.getPropertyKeys();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.isRemoteServiceProperty(propKeys[i])) {
                props.put(propKeys[i], rsReference.getProperty(propKeys[i]));
            }
            ++i;
        }
        this.addImportedConfigsProperties(this.getContainerTypeDescription(rsContainer.getContainer()), rsEndpointDescription.getSupportedConfigs(), props);
        return props;
    }

    private void addImportedConfigsProperties(ContainerTypeDescription containerTypeDescription, String[] remoteExportedConfigs, Dictionary exportedProperties) {
        String[] importedConfigs;
        if (containerTypeDescription == null) {
            return;
        }
        if (remoteExportedConfigs != null && (importedConfigs = containerTypeDescription.getImportedConfigs(remoteExportedConfigs)) != null) {
            exportedProperties.put("service.imported.configs", importedConfigs);
            Dictionary localConfigProperties = containerTypeDescription.getPropertiesForImportedConfigs(importedConfigs, exportedProperties);
            if (localConfigProperties != null) {
                Enumeration e = localConfigProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    exportedProperties.put(key, localConfigProperties.get(key));
                }
            }
        }
    }

    protected ContainerTypeDescription getContainerTypeDescription(IContainer container) {
        IContainerManager containerManager = this.getContainerManager();
        if (containerManager == null) {
            return null;
        }
        return containerManager.getContainerTypeDescription(container.getID());
    }

    protected IContainerManager getContainerManager() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        return activator.getContainerManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDiscoveredServiceID(RemoteServiceEndpointDescription desc) {
        List list = this.serviceLocations;
        synchronized (list) {
            return this.serviceLocations.add(desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeDiscoveredServiceID(RemoteServiceEndpointDescription desc) {
        List list = this.serviceLocations;
        synchronized (list) {
            return this.serviceLocations.remove(desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsDiscoveredServiceID(RemoteServiceEndpointDescription desc) {
        List list = this.serviceLocations;
        synchronized (list) {
            return this.serviceLocations.contains(desc);
        }
    }

    protected void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), message);
    }

    protected void traceException(String methodName, String message, Throwable t) {
        LogUtility.traceException(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/exceptions/catching", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message, Throwable t) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), message);
    }

    protected void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/discoveredservicetracker", this.getClass(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidDescription(RemoteServiceEndpointDescription rsEndpointDescription) {
        if (rsEndpointDescription == null) {
            return false;
        }
        List list = this.serviceLocations;
        synchronized (list) {
            block5: {
                if (!this.containsDiscoveredServiceID(rsEndpointDescription)) break block5;
                return false;
            }
            this.addDiscoveredServiceID(rsEndpointDescription);
            return true;
        }
    }

    private IRemoteServiceContainer[] findProxyContainers(RemoteServiceEndpointDescription rsEndpointDescription) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        IProxyContainerFinder finder = activator.getProxyRemoteServiceContainerFinder();
        if (finder == null) {
            this.logError("findRemoteServiceContainersViaService", "No container finders available");
            return null;
        }
        return finder.findProxyContainers(rsEndpointDescription.getServiceID(), (IRemoteServiceEndpointDescription)rsEndpointDescription);
    }

    class RemoteServiceReferenceUnregisteredListener
    implements IRemoteServiceListener {
        RemoteServiceReferenceUnregisteredListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleServiceEvent(IRemoteServiceEvent event) {
            if (event instanceof IRemoteServiceUnregisteredEvent) {
                DiscoveredServiceTrackerImpl.this.trace("handleRemoteServiceUnregisteredEvent", "localContainerID=" + event.getLocalContainerID() + ",containerID=" + event.getContainerID() + ",remoteReference=" + event.getReference());
                ServiceRegistration[] proxyServiceRegistrations = null;
                List list = DiscoveredServiceTrackerImpl.this.serviceLocations;
                synchronized (list) {
                    RemoteServiceRegistration rsRegs = (RemoteServiceRegistration)DiscoveredServiceTrackerImpl.this.discoveredRemoteServiceRegistrations.get(event.getLocalContainerID());
                    if (rsRegs != null) {
                        proxyServiceRegistrations = rsRegs.removeServiceRegistration(event.getReference());
                        if (rsRegs.isEmpty()) {
                            rsRegs.dispose();
                            DiscoveredServiceTrackerImpl.this.discoveredRemoteServiceRegistrations.remove(event.getContainerID());
                        }
                    }
                }
                if (proxyServiceRegistrations != null) {
                    int i = 0;
                    while (i < proxyServiceRegistrations.length) {
                        DiscoveredServiceTrackerImpl.this.trace("handleRemoteServiceUnregisteredEvent.unregister", "localContainerID=" + event.getLocalContainerID() + ",containerID=" + event.getContainerID() + ",remoteReference=" + event.getReference() + ",proxyServiceRegistrations=" + proxyServiceRegistrations[i]);
                        DiscoveredServiceTrackerImpl.this.unregisterProxyServiceRegistration(null, proxyServiceRegistrations[i]);
                        ++i;
                    }
                }
            }
        }
    }
}

