/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.LogUtility;
import org.eclipse.ecf.osgi.services.discovery.ServicePublication;
import org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IHostDistributionListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;

public class EventHookImpl
implements EventHook {
    private final DistributionProviderImpl distributionProvider;
    private final Map srvRefToRemoteSrvRegistration = new HashMap();
    private final Map srvRefToServicePublicationRegistration = new HashMap();
    private static final List excludedProperties = Arrays.asList("service.id", "objectClass", "service.exported.interfaces", "service.intents", "service.exported.intents", "service.exported.intents.extra", "service.imported", "service.exported.configs", "org.eclipse.ecf.containerID", "org.eclipse.ecf.containerConnectContext", "org.eclipse.ecf.containerConnectTarget", "org.eclipse.ecf.containerFactoryArgs", "ecf.rsvc.cid");
    static /* synthetic */ Class class$0;

    public EventHookImpl(DistributionProviderImpl distributionProvider) {
        this.distributionProvider = distributionProvider;
    }

    public void event(ServiceEvent event, Collection contexts) {
        switch (event.getType()) {
            case 2: {
                this.handleModifiedServiceEvent(event.getServiceReference(), contexts);
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                this.handleRegisteredServiceEvent(event.getServiceReference(), contexts);
                break;
            }
            case 4: {
                this.handleUnregisteringServiceEvent(event.getServiceReference(), contexts);
                break;
            }
        }
    }

    private String[] getExportedConfigs(ServiceReference serviceReference) {
        return this.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.configs"));
    }

    void handleRegisteredServiceEvent(ServiceReference serviceReference, Collection contexts) {
        String[] serviceIntents;
        String[] exportedInterfaces = this.getExportedInterfaces(serviceReference);
        if (exportedInterfaces == null) {
            return;
        }
        String[] exportedConfigs = this.getExportedConfigs(serviceReference);
        IRemoteServiceContainer[] rsContainers = this.findHostContainers(serviceReference, exportedInterfaces, exportedConfigs, serviceIntents = this.getServiceIntents(serviceReference));
        if (rsContainers == null || rsContainers.length == 0) {
            LogUtility.logWarning("handleRegisteredServiceEvent", "org.eclipse.ecf.osgi.services.distribution/debug/eventhook", this.getClass(), "No remote service containers found for serviceReference=" + serviceReference + ". Service NOT EXPORTED");
            return;
        }
        Dictionary remoteServiceProperties = this.getPropertiesForRemoteService(serviceReference);
        Object remoteService = this.getService(serviceReference);
        int i = 0;
        while (i < rsContainers.length) {
            IRemoteServiceRegistration remoteRegistration = rsContainers[i].getContainerAdapter().registerRemoteService(exportedInterfaces, remoteService, remoteServiceProperties);
            this.trace("registerRemoteService", "containerID=" + rsContainers[i].getContainer().getID() + " serviceReference=" + serviceReference + " remoteRegistration=" + remoteRegistration);
            this.fireRemoteServiceRegistered(serviceReference, remoteRegistration);
            this.publishRemoteService(rsContainers[i], serviceReference, exportedInterfaces, remoteRegistration, serviceIntents, exportedConfigs, remoteServiceProperties);
            this.fireHostRegisteredUnregistered(serviceReference, rsContainers[i], remoteRegistration, true);
            ++i;
        }
    }

    private String[] getServiceIntents(ServiceReference serviceReference) {
        String[] extraIntents;
        String[] exportedIntents;
        ArrayList<String> results = new ArrayList<String>();
        String[] intents = this.getStringArrayFromPropertyValue(serviceReference.getProperty("service.intents"));
        if (intents != null) {
            results.addAll(Arrays.asList(intents));
        }
        if ((exportedIntents = this.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.intents"))) != null) {
            results.addAll(Arrays.asList(exportedIntents));
        }
        if ((extraIntents = this.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.intents.extra"))) != null) {
            results.addAll(Arrays.asList(extraIntents));
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new String[0]);
    }

    private IRemoteServiceContainer[] findHostContainers(ServiceReference serviceReference, String[] exportedInterfaces, String[] exportedConfigs, String[] serviceIntents) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        IHostContainerFinder finder = activator.getHostRemoteServiceContainerFinder();
        if (finder == null) {
            this.logError("findRemoteServiceContainers", "No container finders available");
            return null;
        }
        return finder.findHostContainers(serviceReference, exportedInterfaces, exportedConfigs, serviceIntents);
    }

    private Dictionary getServicePublicationProperties(IRemoteServiceContainer rsContainer, ServiceReference ref, String[] remoteInterfaces, IRemoteServiceRegistration remoteRegistration, String[] serviceIntents, String[] supportedConfigs, Dictionary remoteProperties) {
        Namespace rsnamespace;
        Properties result = new Properties();
        IContainer container = rsContainer.getContainer();
        ((Dictionary)result).put("osgi.remote.service.interfaces", this.getAsCollection(remoteInterfaces));
        if (supportedConfigs != null) {
            ((Dictionary)result).put("ecf.sp.ect", this.getAsCollection(supportedConfigs));
        }
        if (serviceIntents != null) {
            ((Dictionary)result).put("ecf.sp.esi", this.getAsCollection(serviceIntents));
        }
        ((Dictionary)result).put("osgi.remote.discovery.publication.service.properties", remoteProperties);
        ID endpointID = container.getID();
        ((Dictionary)result).put("ecf.sp.cid", endpointID);
        ID targetID = container.getConnectedID();
        if (targetID != null && !targetID.equals((Object)endpointID)) {
            ((Dictionary)result).put("ecf.sp.tid", targetID);
        }
        if ((rsnamespace = rsContainer.getContainerAdapter().getRemoteServiceNamespace()) != null) {
            ((Dictionary)result).put("ecf.rsvc.ns", rsnamespace.getName());
        }
        Long serviceId = (Long)remoteRegistration.getProperty("ecf.rsvc.id");
        byte[] serviceIdAsBytes = null;
        if (serviceId != null) {
            serviceIdAsBytes = serviceId.toString().getBytes();
        } else {
            this.logError("getServicePublicationProperties", "RemoteRegistration property remote.service.id is not set in remoteRegistration=" + remoteRegistration);
            serviceIdAsBytes = "0".getBytes();
        }
        ((Dictionary)result).put("ecf.rsvc.id", serviceIdAsBytes);
        return result;
    }

    private void publishRemoteService(IRemoteServiceContainer rsContainer, final ServiceReference ref, String[] remoteInterfaces, IRemoteServiceRegistration remoteRegistration, String[] serviceIntents, String[] supportedConfigs, Dictionary remoteServiceProperties) {
        Dictionary properties = this.getServicePublicationProperties(rsContainer, ref, remoteInterfaces, remoteRegistration, serviceIntents, supportedConfigs, remoteServiceProperties);
        Activator activator = Activator.getDefault();
        if (activator != null) {
            BundleContext context = activator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.osgi.services.discovery.ServicePublication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ServiceRegistration reg = context.registerService(clazz.getName(), (Object)new ServicePublication(){

                public ServiceReference getReference() {
                    return ref;
                }
            }, properties);
            this.fireRemoteServicePublished(ref, reg);
            this.trace("publishRemoteService", "containerID=" + rsContainer.getContainer().getID() + ",serviceReference=" + ref + " properties=" + properties + ",remoteRegistration=" + remoteRegistration);
        }
    }

    private Collection getAsCollection(String[] remoteInterfaces) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < remoteInterfaces.length) {
            result.add(remoteInterfaces[i]);
            ++i;
        }
        return result;
    }

    private Dictionary getPropertiesForRemoteService(ServiceReference sr) {
        String[] propKeys = sr.getPropertyKeys();
        Properties newProps = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            if (!this.excludeRemoteServiceProperty(propKeys[i])) {
                newProps.put(propKeys[i], sr.getProperty(propKeys[i]));
            }
            ++i;
        }
        return newProps;
    }

    private boolean excludeRemoteServiceProperty(String string) {
        return excludedProperties.contains(string);
    }

    private String[] getStringArrayFromPropertyValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Collection) {
            return ((Collection)value).toArray(new String[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoteServiceRegistered(ServiceReference serviceReference, IRemoteServiceRegistration remoteServiceRegistration) {
        Map map = this.srvRefToRemoteSrvRegistration;
        synchronized (map) {
            ArrayList<IRemoteServiceRegistration> l = (ArrayList<IRemoteServiceRegistration>)this.srvRefToRemoteSrvRegistration.get(serviceReference);
            if (l == null) {
                l = new ArrayList<IRemoteServiceRegistration>();
                this.srvRefToRemoteSrvRegistration.put(serviceReference, l);
            }
            l.add(remoteServiceRegistration);
            this.distributionProvider.addExposedService(serviceReference);
        }
    }

    private void fireHostRegisteredUnregistered(final ServiceReference reference, final IRemoteServiceContainer container, final IRemoteServiceRegistration remoteRegistration, final boolean registered) {
        IHostDistributionListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getHostRegistrationListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IHostDistributionListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        EventHookImpl.this.logError("fireHostRegisteredUnregistered", "Exception calling host distribution listener", exception);
                    }

                    public void run() throws Exception {
                        if (registered) {
                            l.registered(reference, container, remoteRegistration);
                        } else {
                            l.unregistered(reference, remoteRegistration);
                        }
                    }
                });
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoteServiceUnregistered(ServiceReference reference) {
        IRemoteServiceRegistration[] registrations = null;
        Map map = this.srvRefToRemoteSrvRegistration;
        synchronized (map) {
            this.distributionProvider.removeExposedService(reference);
            List l = (List)this.srvRefToRemoteSrvRegistration.remove(reference);
            if (l != null) {
                registrations = l.toArray(new IRemoteServiceRegistration[0]);
                l.clear();
            }
        }
        if (registrations != null) {
            int i = 0;
            while (i < registrations.length) {
                try {
                    registrations[i].unregister();
                }
                catch (IllegalStateException l) {
                }
                catch (Exception e) {
                    this.logError("fireRemoteServiceUnregistered", "Exception unregistering remote registration=" + registrations[i], e);
                }
                this.fireHostRegisteredUnregistered(reference, null, registrations[i], false);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoteServicePublished(ServiceReference serviceReference, ServiceRegistration servicePublicationRegistration) {
        Map map = this.srvRefToServicePublicationRegistration;
        synchronized (map) {
            ArrayList<ServiceRegistration> l = (ArrayList<ServiceRegistration>)this.srvRefToServicePublicationRegistration.get(serviceReference);
            if (l == null) {
                l = new ArrayList<ServiceRegistration>();
                this.srvRefToServicePublicationRegistration.put(serviceReference, l);
            }
            l.add(servicePublicationRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoteServiceUnpublished(ServiceReference reference) {
        ServiceRegistration[] registrations = null;
        Map map = this.srvRefToServicePublicationRegistration;
        synchronized (map) {
            List l = (List)this.srvRefToServicePublicationRegistration.remove(reference);
            if (l != null) {
                registrations = l.toArray(new ServiceRegistration[0]);
                l.clear();
            }
        }
        if (registrations != null) {
            int i = 0;
            while (i < registrations.length) {
                try {
                    registrations[i].unregister();
                }
                catch (Exception e) {
                    this.logError("fireRemoteServiceUnpublished", "Exception unregistering service publication registrations=" + registrations[i], e);
                }
                ++i;
            }
        }
    }

    private String[] getExportedInterfaces(ServiceReference serviceReference) {
        Object propValue = serviceReference.getProperty("service.exported.interfaces");
        if (propValue == null) {
            return null;
        }
        boolean wildcard = false;
        String[] exportedInterfaces = null;
        if (propValue instanceof String) {
            wildcard = propValue.equals("*");
            if (!wildcard) {
                return null;
            }
            exportedInterfaces = new String[]{(String)propValue};
        }
        if (exportedInterfaces == null && propValue instanceof String[]) {
            exportedInterfaces = (String[])propValue;
        }
        if (exportedInterfaces == null) {
            return null;
        }
        String[] serviceInterfaces = (String[])serviceReference.getProperty("objectClass");
        ArrayList<String> results = new ArrayList<String>();
        if (wildcard) {
            return serviceInterfaces;
        }
        List<String> interfaces = Arrays.asList(serviceInterfaces);
        List<String> rsInterfaces = Arrays.asList(exportedInterfaces);
        Iterator<String> i = rsInterfaces.iterator();
        while (i.hasNext()) {
            String rsIntf = i.next();
            if (rsIntf.equals("*")) {
                results.addAll(interfaces);
            }
            if (!interfaces.contains(rsIntf)) continue;
            results.add(rsIntf);
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new String[0]);
    }

    private void trace(String methodName, String message) {
        Trace.trace((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/eventhook", this.getClass(), (String)methodName, (String)message);
    }

    private void traceException(String methodName, String message, Throwable t) {
        Trace.catching((String)"org.eclipse.ecf.osgi.services.distribution", (String)"org.eclipse.ecf.osgi.services.distribution/debug/exceptions/catching", this.getClass(), (String)(String.valueOf(methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message)), (Throwable)t);
    }

    private void logError(String methodName, String message, Throwable t) {
        this.traceException(methodName, message, t);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.distribution", 4, String.valueOf(this.getClass().getName()) + ":" + (methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message), t));
    }

    private void logError(String methodName, String message) {
        this.logError(methodName, message, null);
        this.traceException(methodName, message, null);
    }

    private void handleUnregisteringServiceEvent(ServiceReference serviceReference, Collection contexts) {
        this.fireRemoteServiceUnregistered(serviceReference);
        this.fireRemoteServiceUnpublished(serviceReference);
    }

    private void handleModifiedServiceEvent(ServiceReference serviceReference, Collection contexts) {
        Object osgiRemotes = serviceReference.getProperty("service.exported.interfaces");
        if (osgiRemotes != null) {
            this.trace("org.eclipse.ecf.internal.osgi.services.distribution.EventHookImpl.handleModifiedServiceEvent(ServiceReference, Collection)", "implement!");
        }
    }

    private Object getService(ServiceReference sr) {
        return Activator.getDefault().getContext().getService(sr);
    }
}

