/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.osgi.services.distribution.AbstractHostContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.osgi.framework.ServiceReference;

public class DefaultHostContainerFinder
extends AbstractHostContainerFinder
implements IHostContainerFinder {
    private boolean autoCreateContainer = false;

    public DefaultHostContainerFinder(boolean autoCreateContainer) {
        this.autoCreateContainer = autoCreateContainer;
    }

    public IRemoteServiceContainer[] findHostContainers(ServiceReference serviceReference, String[] serviceExportedInterfaces, String[] serviceExportedConfigs, String[] serviceIntents) {
        Collection rsContainers = this.findExistingHostContainers(serviceReference, serviceExportedInterfaces, serviceExportedConfigs, serviceIntents);
        if (rsContainers.size() == 0 && this.autoCreateContainer) {
            rsContainers = this.createAndConfigureHostContainers(serviceReference, serviceExportedInterfaces, serviceExportedConfigs, serviceIntents);
            Object target = serviceReference.getProperty("org.eclipse.ecf.containerConnectTarget");
            if (target != null) {
                Iterator i = rsContainers.iterator();
                while (i.hasNext()) {
                    IContainer container = ((IRemoteServiceContainer)i.next()).getContainer();
                    try {
                        this.connectHostContainer(serviceReference, container, target);
                    }
                    catch (Exception e) {
                        this.logException("doConnectContainer failure containerID=" + container.getID() + " target=" + target, e);
                    }
                }
            }
        }
        return rsContainers.toArray(new IRemoteServiceContainer[0]);
    }
}

