/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.Collection;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.osgi.services.discovery.IRemoteServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.distribution.AbstractProxyContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;

public class DefaultProxyContainerFinder
extends AbstractProxyContainerFinder
implements IProxyContainerFinder {
    private boolean autoCreateContainer = false;

    public DefaultProxyContainerFinder(boolean autoCreateContainer) {
        this.autoCreateContainer = autoCreateContainer;
    }

    public IRemoteServiceContainer[] findProxyContainers(IServiceID serviceID, IRemoteServiceEndpointDescription endpointDescription) {
        this.trace("findProxyContainers", "serviceID=" + serviceID + " endpointDescription=" + endpointDescription);
        ID endpointID = endpointDescription.getEndpointAsID();
        String[] remoteSupportedConfigs = endpointDescription.getSupportedConfigs();
        ID connectTargetID = endpointDescription.getConnectTargetID();
        Collection rsContainers = this.findExistingProxyContainers(endpointID, remoteSupportedConfigs);
        if (rsContainers.size() == 0 && this.autoCreateContainer) {
            rsContainers = this.createAndConfigureProxyContainers(remoteSupportedConfigs, endpointDescription.getProperties());
        }
        this.connectContainersToTarget(rsContainers, connectTargetID);
        return rsContainers.toArray(new IRemoteServiceContainer[0]);
    }
}

