/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.eventadmin;

import java.io.IOException;
import java.security.Permission;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.sharedobject.BaseSharedObject;
import org.eclipse.ecf.core.sharedobject.SharedObjectMsg;
import org.eclipse.ecf.internal.remoteservice.eventadmin.DistributedEventAdminMessage;
import org.eclipse.ecf.internal.remoteservice.eventadmin.EventHandlerTracker;
import org.eclipse.ecf.internal.remoteservice.eventadmin.EventHandlerWrapper;
import org.eclipse.ecf.internal.remoteservice.eventadmin.LogTracker;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.TopicPermission;

public class DistributedEventAdmin
extends BaseSharedObject
implements EventAdmin {
    private LogTracker log;
    private EventHandlerTracker eventHandlerTracker;
    private EventManager eventManager;

    public DistributedEventAdmin(BundleContext context) {
        Assert.isNotNull((Object)context);
        this.log = new LogTracker(context, System.out);
        this.eventHandlerTracker = new EventHandlerTracker(context, this.log);
    }

    public void start() {
        this.log.open();
        ThreadGroup eventGroup = new ThreadGroup("Distributed EventAdmin");
        eventGroup.setDaemon(true);
        this.eventManager = new EventManager("Distributed EventAdmin Async Event Dispatcher Thread", eventGroup);
        this.eventHandlerTracker.open();
    }

    public void stop() {
        this.eventHandlerTracker.close();
        this.eventManager.close();
        this.eventManager = null;
        this.log.close();
    }

    public void postEvent(Event event) {
        try {
            this.sendSharedObjectMsgTo(null, SharedObjectMsg.createMsg((String)"handlePostEvent", (Object)new DistributedEventAdminMessage(event)));
        }
        catch (IOException e) {
            this.logError(NLS.bind((String)"IOException posting distributed event {0} to {1}", (Object)event, (Object)event.getTopic()), e);
        }
        this.localDispatch(event, true);
    }

    public void sendEvent(Event event) {
        this.localDispatch(event, false);
    }

    protected boolean handleSharedObjectMsg(SharedObjectMsg msg) {
        try {
            msg.invoke((Object)this);
            return true;
        }
        catch (Exception e) {
            this.logError("handleSharedObjectMsg invoke error on msg=" + msg, e);
            return false;
        }
    }

    protected void localDispatch(Event event, boolean isAsync) {
        EventManager currentManager = this.eventManager;
        if (currentManager == null) {
            return;
        }
        if (event == null) {
            this.log.log(1, "Null event passed to EventAdmin was ignored.");
        }
        String eventTopic = event.getTopic();
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new TopicPermission(eventTopic, "publish"));
            }
        }
        catch (SecurityException e) {
            String msg = NLS.bind((String)"Caller bundle does not have TopicPermission to publish topic {0}", (Object)eventTopic);
            this.logError(msg, e);
            throw e;
        }
        Set eventHandlerWrappers = this.eventHandlerTracker.getHandlers(eventTopic);
        SecurityManager sm = System.getSecurityManager();
        TopicPermission perm = sm == null ? null : new TopicPermission(eventTopic, "subscribe");
        CopyOnWriteIdentityMap listeners = new CopyOnWriteIdentityMap();
        Iterator iter = eventHandlerWrappers.iterator();
        while (iter.hasNext()) {
            EventHandlerWrapper wrapper = (EventHandlerWrapper)iter.next();
            listeners.put((Object)wrapper, (Object)perm);
        }
        ListenerQueue listenerQueue = new ListenerQueue(currentManager);
        listenerQueue.queueListeners(listeners.entrySet(), (EventDispatcher)this.eventHandlerTracker);
        if (isAsync) {
            listenerQueue.dispatchEventAsynchronous(0, (Object)event);
        } else {
            listenerQueue.dispatchEventSynchronous(0, (Object)event);
        }
    }

    void handlePostEvent(DistributedEventAdminMessage event) {
        this.localDispatch(event.getEvent(), true);
    }

    protected void logError(String message, Throwable exception) {
        if (this.log != null) {
            this.log.log(1, message, exception);
        } else {
            System.err.println(message);
            if (exception != null) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

