/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.workgroup.agent.InvitationRequest;
import org.jivesoftware.smackx.workgroup.agent.OfferContent;
import org.jivesoftware.smackx.workgroup.agent.TransferRequest;
import org.jivesoftware.smackx.workgroup.agent.UserRequest;
import org.jivesoftware.smackx.workgroup.packet.RoomInvitation;
import org.jivesoftware.smackx.workgroup.packet.RoomTransfer;
import org.jivesoftware.smackx.workgroup.util.MetaDataUtils;
import org.xmlpull.v1.XmlPullParser;

public class OfferRequestProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        String userJID;
        int eventType = parser.getEventType();
        String sessionID = null;
        int timeout = -1;
        OfferContent content = null;
        boolean done = false;
        Map metaData = new HashMap();
        String userID = userJID = parser.getAttributeValue("", "jid");
        while (!done) {
            eventType = parser.next();
            if (eventType == 2) {
                String elemName = parser.getName();
                if ("timeout".equals(elemName)) {
                    timeout = Integer.parseInt(parser.nextText());
                    continue;
                }
                if ("metadata".equals(elemName)) {
                    metaData = MetaDataUtils.parseMetaData(parser);
                    continue;
                }
                if ("session".equals(elemName)) {
                    sessionID = parser.getAttributeValue("", "id");
                    continue;
                }
                if ("user".equals(elemName)) {
                    userID = parser.getAttributeValue("", "id");
                    continue;
                }
                if ("user-request".equals(elemName)) {
                    content = UserRequest.getInstance();
                    continue;
                }
                if ("invite".equals(elemName)) {
                    RoomInvitation invitation = (RoomInvitation)PacketParserUtils.parsePacketExtension("invite", "http://jabber.org/protocol/workgroup", parser);
                    content = new InvitationRequest(invitation.getInviter(), invitation.getRoom(), invitation.getReason());
                    continue;
                }
                if (!"transfer".equals(elemName)) continue;
                RoomTransfer transfer = (RoomTransfer)PacketParserUtils.parsePacketExtension("transfer", "http://jabber.org/protocol/workgroup", parser);
                content = new TransferRequest(transfer.getInviter(), transfer.getRoom(), transfer.getReason());
                continue;
            }
            if (eventType != 3 || !"offer".equals(parser.getName())) continue;
            done = true;
        }
        OfferRequestPacket offerRequest = new OfferRequestPacket(userJID, userID, timeout, metaData, sessionID, content);
        offerRequest.setType(IQ.Type.SET);
        return offerRequest;
    }

    public static class OfferRequestPacket
    extends IQ {
        private int timeout;
        private String userID;
        private String userJID;
        private Map metaData;
        private String sessionID;
        private OfferContent content;

        public OfferRequestPacket(String userJID, String userID, int timeout, Map metaData, String sessionID, OfferContent content) {
            this.userJID = userJID;
            this.userID = userID;
            this.timeout = timeout;
            this.metaData = metaData;
            this.sessionID = sessionID;
            this.content = content;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getUserJID() {
            return this.userJID;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public OfferContent getContent() {
            return this.content;
        }

        public Map getMetaData() {
            return this.metaData;
        }

        public String getChildElementXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<offer xmlns=\"http://jabber.org/protocol/workgroup\" jid=\"").append(this.userJID).append("\">");
            buf.append("<timeout>").append(this.timeout).append("</timeout>");
            if (this.sessionID != null) {
                buf.append('<').append("session");
                buf.append(" session=\"");
                buf.append(this.getSessionID()).append("\" xmlns=\"");
                buf.append("http://jivesoftware.com/protocol/workgroup").append("\"/>");
            }
            if (this.metaData != null) {
                buf.append(MetaDataUtils.serializeMetaData(this.metaData));
            }
            if (this.userID != null) {
                buf.append('<').append("user");
                buf.append(" id=\"");
                buf.append(this.userID).append("\" xmlns=\"");
                buf.append("http://jivesoftware.com/protocol/workgroup").append("\"/>");
            }
            buf.append("</offer>");
            return buf.toString();
        }
    }
}

