/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.remoteservices.hello.consumer;

import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.examples.remoteservices.hello.IHello;
import org.eclipse.ecf.internal.examples.remoteservices.hello.consumer.Activator;
import org.eclipse.ecf.osgi.services.distribution.IDistributionConstants;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxy;
import org.eclipse.ecf.remoteservice.RemoteServiceHelper;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HelloConsumerApplication
implements IApplication,
IDistributionConstants,
ServiceTrackerCustomizer {
    public static final String CONSUMER_NAME = "org.eclipse.ecf.examples.remoteservices.hello.consumer";
    private BundleContext bundleContext;
    private ServiceTracker containerFactoryServiceTracker;
    private String containerType = "ecf.r_osgi.peer";
    private final Object appLock = new Object();
    private boolean done = false;
    private ServiceTracker helloServiceTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Object start(IApplicationContext appContext) throws Exception {
        this.bundleContext = Activator.getContext();
        this.processArgs(appContext);
        this.getContainerFactory().createContainer(this.containerType);
        this.helloServiceTracker = new ServiceTracker(this.bundleContext, this.createRemoteFilter(), (ServiceTrackerCustomizer)this);
        this.helloServiceTracker.open();
        this.startLocalDiscoveryIfPresent();
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    private void startLocalDiscoveryIfPresent() {
        Bundle[] bundles = this.bundleContext.getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].getSymbolicName().equals("org.eclipse.ecf.osgi.services.discovery.local")) {
                try {
                    bundles[i].start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private Filter createRemoteFilter() throws InvalidSyntaxException {
        StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.examples.remoteservices.hello.IHello");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.bundleContext.createFilter(stringBuffer.append(clazz.getName()).append(")(").append("service.imported").append("=*))").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.helloServiceTracker != null) {
            this.helloServiceTracker.close();
            this.helloServiceTracker = null;
        }
        if (this.containerFactoryServiceTracker != null) {
            this.containerFactoryServiceTracker.close();
            this.containerFactoryServiceTracker = null;
        }
        this.bundleContext = null;
        Object object = this.appLock;
        synchronized (object) {
            this.done = true;
            this.notifyAll();
        }
    }

    private IContainerFactory getContainerFactory() {
        if (this.containerFactoryServiceTracker == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.core.IContainerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.containerFactoryServiceTracker = new ServiceTracker(this.bundleContext, clazz.getName(), null);
            this.containerFactoryServiceTracker.open();
        }
        return (IContainerFactory)this.containerFactoryServiceTracker.getService();
    }

    private void processArgs(IApplicationContext appContext) {
        String[] originalArgs = (String[])appContext.getArguments().get("application.args");
        if (originalArgs == null) {
            return;
        }
        int i = 0;
        while (i < originalArgs.length) {
            if (originalArgs[i].equals("-containerType")) {
                this.containerType = originalArgs[i + 1];
                ++i;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForDone() {
        Object object = this.appLock;
        synchronized (object) {
            while (true) {
                if (this.done) {
                    return;
                }
                try {
                    this.appLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public Object addingService(ServiceReference reference) {
        System.out.println("IHello service proxy being added");
        IHello hello = (IHello)this.bundleContext.getService(reference);
        hello.hello(CONSUMER_NAME);
        System.out.println("Completed hello remote service invocation using proxy");
        IRemoteService remoteServiceViaProperty = (IRemoteService)reference.getProperty("service.imported");
        IFuture future = RemoteServiceHelper.futureExec((IRemoteService)remoteServiceViaProperty, (String)"hello", (Object[])new Object[]{"org.eclipse.ecf.examples.remoteservices.hello.consumer future"});
        try {
            future.get();
            System.out.println("Completed hello remote service invocation using future");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IRemoteService remoteServiceViaProxy = ((IRemoteServiceProxy)hello).getRemoteService();
        IRemoteCallListener listener = new IRemoteCallListener(){

            public void handleEvent(IRemoteCallEvent event) {
                if (event instanceof IRemoteCallCompleteEvent) {
                    System.out.println("Completed hello remote service invocation using async");
                }
            }
        };
        RemoteServiceHelper.asyncExec((IRemoteService)remoteServiceViaProxy, (String)"hello", (Object[])new Object[]{"org.eclipse.ecf.examples.remoteservices.hello.consumer async"}, (IRemoteCallListener)listener);
        return hello;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
    }
}

