/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.osgi.services.distribution.AbstractContainerFinder;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;
import org.osgi.framework.ServiceReference;

public abstract class AbstractHostContainerFinder
extends AbstractContainerFinder {
    protected Collection findExistingHostContainers(ServiceReference serviceReference, String[] serviceExportedInterfaces, String[] serviceExportedConfigs, String[] serviceIntents) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        IContainer[] containers = this.getContainers();
        if (containers == null || containers.length == 0) {
            return results;
        }
        int i = 0;
        while (i < containers.length) {
            ContainerTypeDescription description;
            IRemoteServiceContainerAdapter adapter = this.hasRemoteServiceContainerAdapter(containers[i]);
            if (adapter != null && (description = this.getContainerTypeDescription(containers[i])) != null) {
                if (this.matchExistingHostContainer(serviceReference, containers[i], adapter, description, serviceExportedConfigs, serviceIntents)) {
                    this.trace("findExistingContainers", "INCLUDING containerID=" + containers[i].getID() + "configs=" + (serviceExportedConfigs == null ? "null" : Arrays.asList(serviceExportedConfigs).toString()) + "intents=" + (serviceIntents == null ? "null" : Arrays.asList(serviceIntents).toString()));
                    results.add(new RemoteServiceContainer(containers[i], adapter));
                } else {
                    this.trace("findExistingContainers", "EXCLUDING containerID=" + containers[i].getID() + "configs=" + (serviceExportedConfigs == null ? "null" : Arrays.asList(serviceExportedConfigs).toString()) + "intents=" + (serviceIntents == null ? "null" : Arrays.asList(serviceIntents).toString()));
                }
            }
            ++i;
        }
        return results;
    }

    protected boolean matchHostContainerToConnectTarget(ServiceReference serviceReference, IContainer container) {
        Object target = serviceReference.getProperty("org.eclipse.ecf.containerConnectTarget");
        if (target == null) {
            return true;
        }
        ID connectedID = container.getConnectedID();
        if (connectedID == null) {
            try {
                this.connectHostContainer(serviceReference, container, target);
            }
            catch (Exception e) {
                this.logException("doConnectContainer containerID=" + container.getID() + " target=" + target, e);
                return false;
            }
            return true;
        }
        ID targetID = this.createTargetID(container, target);
        return connectedID.equals((Object)targetID);
    }

    protected boolean matchExistingHostContainer(ServiceReference serviceReference, IContainer container, IRemoteServiceContainerAdapter adapter, ContainerTypeDescription description, String[] requiredConfigTypes, String[] requiredServiceIntents) {
        return this.matchHostSupportedConfigTypes(requiredConfigTypes, description) && this.matchHostSupportedIntents(requiredServiceIntents, description) && this.matchHostContainerID(serviceReference, container) && this.matchHostContainerToConnectTarget(serviceReference, container);
    }

    protected boolean matchHostContainerID(ServiceReference serviceReference, IContainer container) {
        ID containerID = container.getID();
        if (containerID == null) {
            return false;
        }
        ID requiredContainerID = (ID)serviceReference.getProperty("org.eclipse.ecf.containerID");
        if (requiredContainerID != null) {
            return requiredContainerID.equals((Object)containerID);
        }
        Namespace ns = containerID.getNamespace();
        Object cid = serviceReference.getProperty("org.eclipse.ecf.containerFactoryArgs");
        if (cid == null) {
            return true;
        }
        ID cID = null;
        if (cid instanceof ID) {
            cID = (ID)cid;
        } else if (cid instanceof String) {
            cID = this.getIDFactory().createID(ns, (String)cid);
        } else if (cid instanceof Object[]) {
            Object cido = ((Object[])cid)[0];
            cID = this.getIDFactory().createID(ns, new Object[]{cido});
        }
        if (cID == null) {
            return true;
        }
        return containerID.equals((Object)cID);
    }

    protected boolean matchHostSupportedConfigTypes(String[] serviceRequiredConfigTypes, ContainerTypeDescription containerTypeDescription) {
        if (serviceRequiredConfigTypes == null) {
            return true;
        }
        String[] supportedConfigTypes = this.getSupportedConfigTypes(containerTypeDescription);
        if (supportedConfigTypes == null) {
            return false;
        }
        List<String> supportedConfigTypeList = Arrays.asList(supportedConfigTypes);
        boolean result = true;
        int i = 0;
        while (i < serviceRequiredConfigTypes.length) {
            result = result && supportedConfigTypeList.contains(serviceRequiredConfigTypes[i]);
            ++i;
        }
        return result;
    }

    protected Collection createAndConfigureHostContainers(ServiceReference serviceReference, String[] serviceExportedInterfaces, String[] requiredConfigs, String[] requiredIntents) {
        ArrayList<IRemoteServiceContainer> results = new ArrayList<IRemoteServiceContainer>();
        ContainerTypeDescription[] descriptions = this.getContainerTypeDescriptions();
        if (descriptions == null) {
            return results;
        }
        int i = 0;
        while (i < descriptions.length) {
            IRemoteServiceContainer rsContainer = this.createMatchingContainer(descriptions[i], serviceReference, serviceExportedInterfaces, requiredConfigs, requiredIntents);
            if (rsContainer != null) {
                results.add(rsContainer);
            }
            ++i;
        }
        return results;
    }

    protected IRemoteServiceContainer createMatchingContainer(ContainerTypeDescription containerTypeDescription, ServiceReference serviceReference, String[] serviceExportedInterfaces, String[] requiredConfigs, String[] requiredIntents) {
        if (this.matchHostSupportedConfigTypes(requiredConfigs, containerTypeDescription) && this.matchHostSupportedIntents(requiredIntents, containerTypeDescription)) {
            try {
                IContainer container = this.createContainer(serviceReference, containerTypeDescription);
                return new RemoteServiceContainer(container);
            }
            catch (Exception e) {
                this.logException("Exception creating container from ContainerTypeDescription=" + containerTypeDescription, e);
            }
        }
        return null;
    }

    protected void connectHostContainer(ServiceReference serviceReference, IContainer container, Object target) throws ContainerConnectException, IDCreateException {
        ID targetID = this.createTargetID(container, target);
        Object context = serviceReference.getProperty("org.eclipse.ecf.containerConnectContext");
        IConnectContext connectContext = null;
        if (context != null) {
            connectContext = this.createConnectContext(serviceReference, container, context);
        }
        container.connect(targetID, connectContext);
    }

    protected boolean matchHostSupportedIntents(String[] serviceRequiredIntents, ContainerTypeDescription containerTypeDescription) {
        if (serviceRequiredIntents == null) {
            return true;
        }
        String[] supportedIntents = this.getSupportedIntents(containerTypeDescription);
        if (supportedIntents == null) {
            return false;
        }
        List<String> supportedIntentsList = Arrays.asList(supportedIntents);
        boolean result = true;
        int i = 0;
        while (i < serviceRequiredIntents.length) {
            result = result && supportedIntentsList.contains(serviceRequiredIntents[i]);
            ++i;
        }
        return result;
    }
}

