/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.osgi.services.distribution.AbstractContainerFinder;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;

public abstract class AbstractProxyContainerFinder
extends AbstractContainerFinder {
    protected Collection findExistingProxyContainers(ID endpointID, String[] remoteSupportedConfigs) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        IContainer[] containers = this.getContainers();
        if (containers == null) {
            return results;
        }
        int i = 0;
        while (i < containers.length) {
            if (!this.matchContainerID(containers[i], endpointID)) {
                IRemoteServiceContainerAdapter adapter = this.hasRemoteServiceContainerAdapter(containers[i]);
                if (adapter != null && this.matchConnectNamespace(containers[i], endpointID) && this.matchProxySupportedConfigs(containers[i], remoteSupportedConfigs)) {
                    this.trace("findExistingProxyContainers", "MATCH of existing remote service container id=" + containers[i].getID() + " endpointID=" + endpointID + " remoteSupportedConfigs=" + (remoteSupportedConfigs == null ? "[]" : Arrays.asList(remoteSupportedConfigs).toString()));
                    results.add(new RemoteServiceContainer(containers[i], adapter));
                } else {
                    this.trace("findExistingProxyContainers", "No match of existing remote service container id=" + containers[i].getID() + " endpointID=" + endpointID + " remoteSupportedConfigs=" + (remoteSupportedConfigs == null ? "[]" : Arrays.asList(remoteSupportedConfigs).toString()));
                }
            }
            ++i;
        }
        return results;
    }

    protected boolean matchProxySupportedConfigs(IContainer container, String[] remoteSupportedConfigs) {
        if (remoteSupportedConfigs == null) {
            return false;
        }
        ContainerTypeDescription description = this.getContainerTypeDescription(container);
        if (description == null) {
            return false;
        }
        return description.getImportedConfigs(remoteSupportedConfigs) != null;
    }

    protected void connectContainersToTarget(Collection rsContainers, ID connectTargetID) {
        if (connectTargetID == null) {
            return;
        }
        Iterator i = rsContainers.iterator();
        while (i.hasNext()) {
            IContainer container = ((IRemoteServiceContainer)i.next()).getContainer();
            ID connectedID = container.getConnectedID();
            if (connectedID != null) continue;
            try {
                this.connectContainer(container, connectTargetID, this.getConnectContext(container, connectTargetID));
            }
            catch (ContainerConnectException e) {
                this.logException("Exception connecting container id=" + container.getID() + " to connectTargetID=" + connectTargetID, (Exception)((Object)e));
            }
        }
    }

    protected IConnectContext getConnectContext(IContainer container, ID connectTargetID) {
        return null;
    }

    protected Collection createAndConfigureProxyContainers(String[] remoteSupportedConfigs, Map remoteExportedProperties) {
        if (remoteSupportedConfigs == null || remoteSupportedConfigs.length == 0) {
            return Collections.EMPTY_LIST;
        }
        IContainerFactory containerFactory = this.getContainerFactory();
        if (containerFactory == null) {
            return Collections.EMPTY_LIST;
        }
        List containerTypeDescriptions = containerFactory.getDescriptions();
        if (containerTypeDescriptions == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IRemoteServiceContainer> results = new ArrayList<IRemoteServiceContainer>();
        Iterator i = containerTypeDescriptions.iterator();
        while (i.hasNext()) {
            IRemoteServiceContainer rsContainer;
            Dictionary importedConfigProperties;
            String selectedConfig;
            ContainerTypeDescription desc = (ContainerTypeDescription)i.next();
            String[] localImportedConfigs = desc.getImportedConfigs(remoteSupportedConfigs);
            if (localImportedConfigs == null || (selectedConfig = this.selectLocalImportedConfig(localImportedConfigs, importedConfigProperties = desc.getPropertiesForImportedConfigs(localImportedConfigs, this.createDictionaryFromMap(remoteExportedProperties)))) == null || (rsContainer = this.createContainer(selectedConfig, this.createMapFromDictionary(importedConfigProperties))) == null) continue;
            this.trace("createAndConfigureProxyContainers", "created new proxy container with config type=" + selectedConfig + " and id=" + rsContainer.getContainer().getID());
            results.add(rsContainer);
        }
        return results;
    }

    private Map createMapFromDictionary(Dictionary input) {
        if (input == null) {
            return null;
        }
        HashMap result = new HashMap();
        Enumeration e = input.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = input.get(key);
            result.put(key, val);
        }
        return result;
    }

    private Dictionary createDictionaryFromMap(Map propMap) {
        if (propMap == null) {
            return null;
        }
        Properties result = new Properties();
        Iterator i = propMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object val = propMap.get(key);
            ((Dictionary)result).put(key, val);
        }
        return result;
    }

    protected IRemoteServiceContainer createContainer(String containerTypeDescriptionName, Map properties) {
        try {
            IContainer container = properties == null ? this.getContainerFactory().createContainer(containerTypeDescriptionName) : this.getContainerFactory().createContainer(containerTypeDescriptionName, properties);
            return new RemoteServiceContainer(container);
        }
        catch (Exception e) {
            this.logException("Cannot create container with container type description name=" + containerTypeDescriptionName, e);
            return null;
        }
    }

    protected String selectLocalImportedConfig(String[] localConfigTypes, Dictionary importedConfigProperties) {
        return localConfigTypes[0];
    }
}

