/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jslp;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceURL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.internal.provider.jslp.Activator;
import org.eclipse.ecf.internal.provider.jslp.JSLPDebugOptions;
import org.eclipse.ecf.internal.provider.jslp.Messages;
import org.eclipse.ecf.internal.provider.jslp.ServicePropertiesAdapter;
import org.eclipse.ecf.internal.provider.jslp.ServiceURLAdapter;
import org.eclipse.ecf.provider.jslp.container.JSLPDiscoveryContainer;
import org.eclipse.ecf.provider.jslp.container.JSLPServiceInfo;

public final class JSLPDiscoveryJob
extends Job {
    private final JSLPDiscoveryContainer discoveryContainer;
    private final Map services;

    public JSLPDiscoveryJob(JSLPDiscoveryContainer container) {
        super(Messages.JSLPDiscoveryJob_TITLE);
        this.discoveryContainer = container;
        this.services = Collections.synchronizedMap(new HashMap());
    }

    protected IStatus run(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        try {
            Map.Entry entry;
            Map availableServices = Activator.getDefault().getLocator().getServiceURLs();
            HashMap removedServices = new HashMap(this.services);
            Iterator itr = availableServices.entrySet().iterator();
            while (itr.hasNext() && !monitor.isCanceled()) {
                entry = itr.next();
                ServiceURL url = (ServiceURL)entry.getKey();
                if (removedServices.containsKey(url)) {
                    removedServices.remove(url);
                } else {
                    ServicePropertiesAdapter spa = new ServicePropertiesAdapter((List)entry.getValue());
                    String serviceName = spa.getServiceName() == null ? url.toString() : spa.getServiceName();
                    JSLPServiceInfo serviceInfo = new JSLPServiceInfo(serviceName, new ServiceURLAdapter(url), spa.getPriority(), spa.getWeight(), spa);
                    this.services.put(url, serviceInfo);
                    this.discoveryContainer.fireServiceTypeDiscovered(serviceInfo.getServiceID().getServiceTypeID());
                    this.discoveryContainer.fireServiceDiscovered(serviceInfo);
                }
                monitor.worked(1);
            }
            itr = removedServices.entrySet().iterator();
            while (itr.hasNext() && !monitor.isCanceled()) {
                entry = itr.next();
                Object key = entry.getKey();
                IServiceInfo value = (IServiceInfo)entry.getValue();
                this.discoveryContainer.fireServiceUndiscovered(value);
                this.services.remove(key);
                monitor.worked(1);
            }
        }
        catch (ServiceLocationException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.jslp", (String)JSLPDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"run", (Throwable)e);
        }
        if (this.discoveryContainer.getConnectedID() != null) {
            this.schedule(JSLPDiscoveryContainer.REDISCOVER);
        }
        return Status.OK_STATUS;
    }

    public boolean shouldRun() {
        if (Activator.getDefault() != null) {
            int state = Activator.getDefault().getBundle().getState();
            return state == 32 || state == 8;
        }
        return false;
    }

    public Collection purgeCache() {
        Set unmodifiableSet = Collections.unmodifiableSet(this.services.entrySet());
        this.services.clear();
        return unmodifiableSet;
    }
}

