/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;

public class RemoteServiceID
extends BaseID
implements IRemoteServiceID {
    private static final String SEPARATOR = "/";
    private static final long serialVersionUID = 8330802303633588267L;
    private ID containerID;
    private long containerRelative;
    private int hash;

    public RemoteServiceID(Namespace namespace, ID containerID, long containerRelative) {
        super(namespace);
        Assert.isNotNull((Object)containerID);
        this.containerID = containerID;
        this.containerRelative = containerRelative;
        this.hash = 7;
        this.hash = 31 * this.hash + containerID.hashCode();
        this.hash = 31 * this.hash + (int)(containerRelative ^ containerRelative >>> 32);
    }

    protected int namespaceCompareTo(BaseID o) {
        if (o == null || !(o instanceof RemoteServiceID)) {
            return Integer.MIN_VALUE;
        }
        RemoteServiceID other = (RemoteServiceID)o;
        int containerIDCompareResult = this.containerID.compareTo(other.containerID);
        if (containerIDCompareResult == 0) {
            return (int)(this.containerRelative - other.containerRelative);
        }
        return containerIDCompareResult;
    }

    protected boolean namespaceEquals(BaseID o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RemoteServiceID)) {
            return false;
        }
        RemoteServiceID other = (RemoteServiceID)o;
        if (this.containerID.equals((Object)other.containerID)) {
            return this.containerRelative == other.containerRelative;
        }
        return false;
    }

    protected String namespaceGetName() {
        return String.valueOf(this.containerID.getName()) + SEPARATOR + this.containerRelative;
    }

    protected int namespaceHashCode() {
        return this.hash;
    }

    public ID getContainerID() {
        return this.containerID;
    }

    public long getContainerRelativeID() {
        return this.containerRelative;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("org.eclipse.ecf.remoteservice.RemoteServiceID[");
        buf.append("containerID=").append(this.getContainerID());
        buf.append(";containerRelativeID=").append(this.getContainerRelativeID()).append("]");
        return buf.toString();
    }
}

