/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.io.NotSerializableException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallStartEvent;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceException;

public abstract class AbstractClientService
implements IRemoteService,
InvocationHandler {
    private long nextID = 0L;
    protected RemoteServiceClientRegistration registration;
    protected AbstractClientContainer container;
    static /* synthetic */ Class class$0;

    public AbstractClientService(AbstractClientContainer container, RemoteServiceClientRegistration registration) {
        this.container = container;
        Assert.isNotNull((Object)container);
        this.registration = registration;
        Assert.isNotNull((Object)this.registration);
    }

    public Object callSync(IRemoteCall call) throws ECFException {
        IRemoteCallable callable = this.getRegistration().lookupCallable(call);
        if (callable == null) {
            throw new ECFException("Callable not found for call=" + call);
        }
        return this.invokeRemoteCall(call, callable);
    }

    public IFuture callAsync(IRemoteCall call) {
        return this.callAsync(call, this.getRegistration().lookupCallable(call));
    }

    public void callAsync(IRemoteCall call, IRemoteCallListener listener) {
        this.callAsync(call, this.getRegistration().lookupCallable(call), listener);
    }

    public void fireAsync(IRemoteCall call) throws ECFException {
        IRemoteCallable callable = this.getRegistration().lookupCallable(call);
        if (callable == null) {
            throw new ECFException("Remote callable not found");
        }
        this.callAsync(call, callable);
    }

    public Object getProxy() throws ECFException {
        Object proxy;
        try {
            String[] clazzes = this.getRegistration().getClazzes();
            Class[] cs = new Class[clazzes.length + 1];
            int i = 0;
            while (i < clazzes.length) {
                cs[i] = Class.forName(clazzes[i], true, this.getClass().getClassLoader());
                ++i;
            }
            int n = clazzes.length;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            cs[n] = clazz;
            proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), cs, (InvocationHandler)this);
        }
        catch (Exception e) {
            throw new ECFException(NLS.bind((String)"Exception creating proxy rsid={0}", (Object)this.registration.getID()), (Throwable)e);
        }
        return proxy;
    }

    protected Object[] getCallParametersForProxyInvoke(String callMethod, Method proxyMethod, Object[] args) {
        return args;
    }

    protected long getCallTimeoutForProxyInvoke(String callMethod, Method proxyMethod, Object[] args) {
        return IRemoteCall.DEFAULT_TIMEOUT;
    }

    protected String getCallMethodNameForProxyInvoke(Method method, Object[] args) {
        return RemoteServiceClientRegistration.getFQMethod(method.getDeclaringClass().getName(), method.getName());
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RemoteServiceClientRegistration reg = this.getRegistration();
        Assert.isNotNull((Object)reg);
        try {
            long callTimeout;
            Object[] callParameters;
            if (method.getName().equals("toString")) {
                String[] clazzes = reg.getClazzes();
                String proxyClass = clazzes.length == 1 ? clazzes[0] : Arrays.asList(clazzes).toString();
                return String.valueOf(proxyClass) + ".proxy@" + reg.getID();
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("equals")) {
                if (args == null || args.length == 0) {
                    return Boolean.FALSE;
                }
                try {
                    return new Boolean(Proxy.getInvocationHandler(args[0]).equals(this));
                }
                catch (IllegalArgumentException e) {
                    return Boolean.FALSE;
                }
            }
            if (method.getName().equals("getRemoteService")) {
                return this;
            }
            if (method.getName().equals("getRemoteServiceReference")) {
                return reg.getReference();
            }
            final String fqCallMethod = this.getCallMethodNameForProxyInvoke(method, args);
            IRemoteCall remoteCall = new IRemoteCall(callParameters = this.getCallParametersForProxyInvoke(fqCallMethod, method, args), callTimeout = this.getCallTimeoutForProxyInvoke(fqCallMethod, method, args)){
                private final /* synthetic */ Object[] val$callParameters;
                private final /* synthetic */ long val$callTimeout;
                {
                    this.val$callParameters = objectArray;
                    this.val$callTimeout = l;
                }

                public String getMethod() {
                    return fqCallMethod;
                }

                public Object[] getParameters() {
                    return this.val$callParameters;
                }

                public long getTimeout() {
                    return this.val$callTimeout;
                }
            };
            IRemoteCallable callable = reg.lookupCallable(remoteCall);
            if (callable == null) {
                throw new ECFException("Callable not found for call=" + remoteCall);
            }
            return this.invokeRemoteCall(remoteCall, callable);
        }
        catch (Throwable t) {
            if (t instanceof ServiceException) {
                throw (ServiceException)t;
            }
            throw new ServiceException("Service exception on remote service proxy rsid=" + reg.getID(), 5, t);
        }
    }

    protected long getNextRequestID() {
        return this.nextID++;
    }

    protected void callAsync(IRemoteCall call, IRemoteCallable restClientCallable, IRemoteCallListener listener) {
        ThreadsExecutor executor = new ThreadsExecutor();
        executor.execute((IProgressRunnable)new AsyncResult(call, restClientCallable, listener), null);
    }

    protected IFuture callAsync(final IRemoteCall call, final IRemoteCallable callable) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                if (callable == null) {
                    throw new ECFException("Callable not found");
                }
                return AbstractClientService.this.invokeRemoteCall(call, callable);
            }
        }, null);
    }

    protected void handleInvokeException(String message, Throwable e) throws ECFException {
        throw new ECFException(message, e);
    }

    protected AbstractClientContainer getClientContainer() {
        return this.container;
    }

    protected RemoteServiceClientRegistration getRegistration() {
        return this.registration;
    }

    protected String prepareEndpointAddress(IRemoteCall call, IRemoteCallable callable) {
        return this.getClientContainer().prepareEndpointAddress(call, callable);
    }

    protected IRemoteCallParameter[] prepareParameters(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        return this.getClientContainer().prepareParameters(uri, call, callable);
    }

    protected Object processResponse(String uri, IRemoteCall call, IRemoteCallable callable, Map responseHeaders, String responseBody) throws NotSerializableException {
        return this.getClientContainer().processResponse(uri, call, callable, responseHeaders, responseBody);
    }

    protected abstract Object invokeRemoteCall(IRemoteCall var1, IRemoteCallable var2) throws ECFException;

    protected class AsyncResult
    implements IProgressRunnable {
        IRemoteCall call;
        IRemoteCallable callable;
        IRemoteCallListener listener;
        Object result;
        Throwable exception;

        public AsyncResult(IRemoteCall call, IRemoteCallable callable, IRemoteCallListener listener) {
            this.call = call;
            this.callable = callable;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(IProgressMonitor monitor) throws Exception {
            Object r = null;
            Throwable e = null;
            long reqID = AbstractClientService.this.getNextRequestID();
            if (this.listener != null) {
                this.listener.handleEvent(new IRemoteCallStartEvent(this, reqID){
                    final /* synthetic */ AsyncResult this$1;
                    private final /* synthetic */ long val$reqID;
                    {
                        this.this$1 = asyncResult;
                        this.val$reqID = l;
                    }

                    public IRemoteCall getCall() {
                        return this.this$1.call;
                    }

                    public IRemoteServiceReference getReference() {
                        return AsyncResult.access$0(this.this$1).getRegistration().getReference();
                    }

                    public long getRequestId() {
                        return this.val$reqID;
                    }
                });
            }
            try {
                if (this.callable == null) {
                    throw new ECFException(NLS.bind((String)"Restcall not found for method={0}", (Object)this.call.getMethod()));
                }
                r = AbstractClientService.this.invokeRemoteCall(this.call, this.callable);
            }
            catch (Throwable t) {
                e = t;
            }
            AsyncResult asyncResult = this;
            synchronized (asyncResult) {
                this.result = r;
                this.exception = e;
                this.notify();
            }
            if (this.listener != null) {
                this.listener.handleEvent(new IRemoteCallCompleteEvent(this, reqID){
                    final /* synthetic */ AsyncResult this$1;
                    private final /* synthetic */ long val$reqID;
                    {
                        this.this$1 = asyncResult;
                        this.val$reqID = l;
                    }

                    public Throwable getException() {
                        return this.this$1.exception;
                    }

                    public Object getResponse() {
                        return this.this$1.result;
                    }

                    public boolean hadException() {
                        return this.this$1.exception != null;
                    }

                    public long getRequestId() {
                        return this.val$reqID;
                    }
                });
            }
            return null;
        }

        static /* synthetic */ AbstractClientService access$0(AsyncResult asyncResult) {
            return asyncResult.AbstractClientService.this;
        }
    }
}

