/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.sharedobject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IIdentifiable;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.ISharedObjectManager;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.SharedObjectMsg;
import org.eclipse.ecf.core.sharedobject.SharedObjectMsgEvent;
import org.eclipse.ecf.core.sharedobject.SharedObjectMsgEventProcessor;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectCreateResponseEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectMessageEvent;
import org.eclipse.ecf.core.sharedobject.events.RemoteSharedObjectEvent;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.sharedobject.util.QueueException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.IEventProcessor;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.core.sharedobject.Activator;

public class BaseSharedObject
implements ISharedObject,
IIdentifiable {
    protected static final int DESTROYREMOTE_CODE = 8001;
    protected static final int DESTROYSELFLOCAL_CODE = 8002;
    private ISharedObjectConfig config = null;
    private List eventProcessors = new Vector();

    public final void init(ISharedObjectConfig initData) throws SharedObjectInitException {
        this.config = initData;
        this.traceEntering("init", initData);
        this.addEventProcessor(new SharedObjectMsgEventProcessor(this));
        this.initialize();
        this.traceExiting("init");
    }

    protected void initialize() throws SharedObjectInitException {
        this.traceEntering("initialize");
    }

    protected void creationCompleted() {
        this.traceEntering("creationCompleted", null);
    }

    public void dispose(ID containerID) {
        this.traceEntering("dispose", containerID);
        this.eventProcessors.clear();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        IAdapterManager adapterManager = activator.getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public void handleEvent(Event event) {
        this.traceEntering("handleEvent", event);
        this.fireEventProcessors(event);
        this.traceExiting("handleEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEventProcessor(IEventProcessor proc) {
        Assert.isNotNull((Object)proc);
        List list = this.eventProcessors;
        synchronized (list) {
            return this.eventProcessors.add(proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEventProcessor(IEventProcessor proc) {
        Assert.isNotNull((Object)proc);
        List list = this.eventProcessors;
        synchronized (list) {
            return this.eventProcessors.remove(proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEventProcessors() {
        List list = this.eventProcessors;
        synchronized (list) {
            this.eventProcessors.clear();
        }
    }

    protected void handleUnhandledEvent(Event event) {
        Activator.getDefault().log((IStatus)new Status(2, "org.eclipse.ecf.sharedobject", 2, "handleUnhandledEvent=" + event, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEventProcessors(Event event) {
        if (event == null) {
            return;
        }
        Event evt = event;
        ArrayList notify = null;
        List list = this.eventProcessors;
        synchronized (list) {
            notify = new ArrayList(this.eventProcessors);
        }
        if (notify.size() == 0) {
            this.handleUnhandledEvent(evt);
            return;
        }
        Iterator i = notify.iterator();
        while (i.hasNext()) {
            IEventProcessor ep = (IEventProcessor)i.next();
            if (ep.processEvent(evt)) break;
        }
    }

    public void handleEvents(Event[] events) {
        this.traceEntering("handleEvents", events);
        if (events == null) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            this.handleEvent(events[i]);
            ++i;
        }
        this.traceExiting("handleEvents");
    }

    public ID getID() {
        return this.getConfig().getSharedObjectID();
    }

    protected final ISharedObjectConfig getConfig() {
        return this.config;
    }

    protected final ISharedObjectContext getContext() {
        return this.getConfig().getContext();
    }

    protected ID getHomeContainerID() {
        return this.getConfig().getHomeContainerID();
    }

    protected ID getLocalContainerID() {
        ISharedObjectContext context = this.getContext();
        return context == null ? null : context.getLocalContainerID();
    }

    protected ID getConnectedID() {
        ISharedObjectContext context = this.getContext();
        return context == null ? null : context.getConnectedID();
    }

    protected final boolean isConnected() {
        return this.getConnectedID() != null;
    }

    protected final boolean isPrimary() {
        ID local = this.getLocalContainerID();
        ID home = this.getHomeContainerID();
        if (local == null || home == null) {
            return false;
        }
        return local.equals((Object)home);
    }

    protected final Map getProperties() {
        return this.getConfig().getProperties();
    }

    protected void destroySelf() {
        this.traceEntering("destroySelf");
        if (this.isPrimary()) {
            try {
                this.destroyRemote(null);
            }
            catch (IOException e) {
                this.traceCatching("destroySelf", e);
                this.log(8001, "destroySelf", e);
            }
        }
        this.destroySelfLocal();
        this.traceExiting("destroySelf");
    }

    protected void destroySelfLocal() {
        this.traceEntering("destroySelfLocal");
        try {
            ISharedObjectManager manager = this.getContext().getSharedObjectManager();
            if (manager != null) {
                manager.removeSharedObject(this.getID());
            }
        }
        catch (Exception e) {
            this.traceCatching("destroySelfLocal", e);
            this.log(8002, "destroySelfLocal", e);
        }
        this.traceExiting("destroySelfLocal");
    }

    protected void destroyRemote(ID remoteID) throws IOException {
        ISharedObjectContext context = this.getContext();
        if (context != null) {
            context.sendDispose(remoteID);
        }
    }

    protected void sendSharedObjectMsgTo(ID toID, SharedObjectMsg msg) throws IOException {
        ISharedObjectContext context = this.getContext();
        if (context != null) {
            Assert.isNotNull((Object)msg, (String)"SharedObjectMsg cannot be null");
            String method = "sendSharedObjectMsgTo";
            this.traceEntering(method, new Object[]{toID, msg});
            context.sendMessage(toID, new SharedObjectMsgEvent(this.getID(), toID, msg));
            this.traceExiting(method);
        }
    }

    protected void sendSharedObjectMsgToPrimary(SharedObjectMsg msg) throws IOException {
        this.sendSharedObjectMsgTo(this.getHomeContainerID(), msg);
    }

    protected void sendSharedObjectMsgToSelf(SharedObjectMsg msg) {
        if (msg == null) {
            throw new NullPointerException("SharedObjectMsg cannot be null");
        }
        ISharedObjectContext context = this.getContext();
        if (context == null) {
            return;
        }
        IQueueEnqueue queue = context.getQueue();
        try {
            queue.enqueue(new SharedObjectMsgEvent(this.getID(), this.getContext().getLocalContainerID(), msg));
        }
        catch (QueueException e) {
            this.traceCatching("sendSharedObjectMsgToSelf", (Throwable)((Object)e));
            this.log(8001, "sendSharedObjectMsgToSelf", (Throwable)((Object)e));
        }
    }

    protected SharedObjectMsg getSharedObjectMsgFromEvent(ISharedObjectMessageEvent event) {
        this.traceEntering("getSharedObjectMsgFromEvent", event);
        Object eventData = event.getData();
        Object msgData = null;
        if (eventData != null && eventData instanceof RemoteSharedObjectEvent) {
            Object rsoeData = ((RemoteSharedObjectEvent)event).getData();
            if (rsoeData != null && rsoeData instanceof SharedObjectMsgEvent) {
                msgData = ((SharedObjectMsgEvent)rsoeData).getData();
            }
        } else {
            msgData = eventData;
        }
        if (msgData != null && msgData instanceof SharedObjectMsg) {
            this.traceExiting("getSharedObjectMsgFromEvent", msgData);
            return (SharedObjectMsg)msgData;
        }
        this.traceExiting("getSharedObjectMsgFromEvent", null);
        return null;
    }

    protected boolean handleSharedObjectMsgEvent(ISharedObjectMessageEvent event) {
        this.traceEntering("handleSharedObjectMsgEvent", event);
        boolean result = false;
        if (event instanceof ISharedObjectCreateResponseEvent) {
            result = this.handleSharedObjectCreateResponseEvent((ISharedObjectCreateResponseEvent)event);
        } else {
            SharedObjectMsg msg = this.getSharedObjectMsgFromEvent(event);
            if (msg != null) {
                result = this.handleSharedObjectMsg(msg);
            }
        }
        this.traceExiting("handleSharedObjectMsgEvent", result ? Boolean.TRUE : Boolean.FALSE);
        return result;
    }

    protected boolean handleSharedObjectCreateResponseEvent(ISharedObjectCreateResponseEvent createResponseEvent) {
        return false;
    }

    protected boolean handleSharedObjectMsg(SharedObjectMsg msg) {
        return false;
    }

    protected ReplicaSharedObjectDescription getReplicaDescription(ID receiver) {
        this.traceEntering("getReplicaDescription", receiver);
        ReplicaSharedObjectDescription result = new ReplicaSharedObjectDescription(this.getClass(), this.getID(), this.getConfig().getHomeContainerID(), this.getConfig().getProperties());
        this.traceExiting("getReplicaDescription", result);
        return result;
    }

    protected ReplicaSharedObjectDescription[] getReplicaDescriptions(ID[] receivers) {
        this.traceEntering("getReplicaDescriptions", receivers);
        ReplicaSharedObjectDescription[] descriptions = null;
        if (receivers == null || receivers.length == 1) {
            descriptions = new ReplicaSharedObjectDescription[]{this.getReplicaDescription(receivers == null ? null : receivers[0])};
        } else {
            descriptions = new ReplicaSharedObjectDescription[receivers.length];
            int i = 0;
            while (i < receivers.length) {
                descriptions[i] = this.getReplicaDescription(receivers[i]);
                ++i;
            }
        }
        this.traceExiting("getReplicaDescriptions", descriptions);
        return descriptions;
    }

    protected ID[] getGroupMemberIDs() {
        ISharedObjectContext context = this.getContext();
        return context == null ? new ID[]{} : context.getGroupMemberIDs();
    }

    protected void replicateToRemoteContainers(ID[] remoteContainers) {
        ISharedObjectContext context = this.getContext();
        if (context != null) {
            this.traceEntering("replicateToRemoteContainers", remoteContainers);
            try {
                ReplicaSharedObjectDescription[] createInfos = this.getReplicaDescriptions(remoteContainers);
                if (createInfos != null) {
                    if (createInfos.length == 1) {
                        context.sendCreate(remoteContainers == null ? null : remoteContainers[0], createInfos[0]);
                    } else {
                        int i = 0;
                        while (i < remoteContainers.length) {
                            context.sendCreate(remoteContainers[i], createInfos[i]);
                            ++i;
                        }
                    }
                }
            }
            catch (IOException e) {
                this.traceCatching("replicateToRemoteContainers.8001", e);
                this.log(8001, "replicateToRemoteContainers", e);
            }
        }
    }

    protected void log(int code, String method, Throwable e) {
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.sharedobject", code, this.getSharedObjectAsString(method), e));
    }

    protected void log(String method, Throwable e) {
        this.log(4, method, e);
    }

    private String getSharedObjectAsString(String suffix) {
        StringBuffer buf = new StringBuffer(String.valueOf(this.getID()));
        buf.append(this.isPrimary() ? ".p." : ".r.");
        buf.append(suffix);
        return buf.toString();
    }

    protected void traceEntering(String methodName) {
        Trace.entering((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/methods/entering", this.getClass(), (String)this.getSharedObjectAsString(methodName));
    }

    protected void traceEntering(String methodName, Object[] params) {
        Trace.entering((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/methods/entering", this.getClass(), (String)this.getSharedObjectAsString(methodName));
    }

    protected void traceEntering(String methodName, Object param) {
        Trace.entering((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/methods/entering", this.getClass(), (String)this.getSharedObjectAsString(methodName));
    }

    protected void traceExiting(String methodName) {
        Trace.entering((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/methods/exiting", this.getClass(), (String)this.getSharedObjectAsString(methodName));
    }

    protected void traceExiting(String methodName, Object result) {
        Trace.entering((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/methods/exiting", this.getClass(), (String)this.getSharedObjectAsString(methodName));
    }

    protected void traceCatching(String method, Throwable t) {
        Trace.catching((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", this.getClass(), (String)this.getSharedObjectAsString(method), (Throwable)t);
    }
}

