/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.messages;

import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class StreamResultMessage
extends RemoteOSGiMessage {
    public static final short RESULT_ARRAY = -2;
    public static final short RESULT_EXCEPTION = -3;
    public static final short RESULT_WRITE_OK = -4;
    private short result;
    private byte[] b;
    private int len;
    private IOException exception;

    public StreamResultMessage() {
        super((short)11);
    }

    StreamResultMessage(ObjectInputStream input) throws IOException, ClassNotFoundException {
        super((short)11);
        this.result = input.readShort();
        switch (this.result) {
            case -2: {
                int read;
                this.len = input.readInt();
                if (this.len <= 0) break;
                this.b = new byte[this.len];
                int rem = this.len;
                while (rem > 0 && (read = input.read(this.b, this.len - rem, rem)) > 0) {
                    rem -= read;
                }
                if (rem <= 0) break;
                throw new IOException("Premature end of input stream.");
            }
            case -3: {
                this.exception = (IOException)input.readObject();
                break;
            }
            case -4: {
                break;
            }
            default: {
                if (this.result >= -1 && this.result <= 255) break;
                throw new IllegalArgumentException("result not within valid range: " + this.result);
            }
        }
    }

    public void writeBody(ObjectOutputStream out) throws IOException {
        out.writeShort(this.result);
        if (this.result == -2) {
            out.writeInt(this.len);
            if (this.len > 0) {
                out.write(this.b, 0, this.len);
            }
        } else if (this.result == -3) {
            out.writeObject(this.exception);
        }
    }

    public boolean causedException() {
        return this.result == -3;
    }

    public short getResult() {
        return this.result;
    }

    public void setResult(short result) {
        this.result = result;
    }

    public byte[] getData() {
        return this.b;
    }

    public void setData(byte[] b) {
        this.b = b;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public IOException getException() {
        return this.exception;
    }

    public void setException(IOException exception) {
        this.exception = exception;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[STREAM_RESULT] - XID: ");
        buffer.append(this.xid);
        buffer.append(", result: ");
        buffer.append(this.result);
        if (this.causedException()) {
            buffer.append(", exception: ");
            buffer.append(this.exception.getMessage());
        }
        return buffer.toString();
    }
}

