/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp;

import java.io.Serializable;

public final class ServiceType
implements Serializable {
    private static final long serialVersionUID = 1652247274399819356L;
    private String type = new String();
    private boolean isService = false;
    private boolean isAbstract = false;
    private String concreteType = new String();
    private String principleType = new String();
    private String abstractType = new String();
    private String namingAuthority = new String();

    public ServiceType(String serviceType) {
        this.type = serviceType;
        if (this.type.startsWith("service:")) {
            this.isService = true;
            int principleStart = 8;
            int principleEnd = this.type.indexOf(":", principleStart);
            if (principleEnd != -1) {
                this.isAbstract = true;
                this.principleType = this.type.substring(principleStart, principleEnd);
                this.abstractType = this.type.substring(0, principleEnd);
                this.concreteType = this.type.substring(principleEnd + 1);
            } else {
                this.isAbstract = false;
                this.principleType = this.type.substring(principleStart);
                this.abstractType = "";
                this.concreteType = "";
            }
            int namingStart = this.type.indexOf(".") + 1;
            if (namingStart != 0) {
                int namingEnd = this.type.indexOf(":", namingStart);
                String na = "";
                na = namingEnd == -1 ? this.type.substring(namingStart) : this.type.substring(namingStart, namingEnd);
                if ("IANA".equalsIgnoreCase(na)) {
                    this.namingAuthority = "";
                    this.type = String.valueOf(this.type.substring(0, namingStart - 1)) + this.type.substring(namingStart + 4, this.type.length());
                } else {
                    this.namingAuthority = na;
                }
            } else {
                this.namingAuthority = "";
            }
        }
    }

    public boolean isServiceURL() {
        return this.isService;
    }

    public boolean isAbstractType() {
        return this.isAbstract;
    }

    public boolean isNADefault() {
        return "".equals(this.namingAuthority);
    }

    public String getConcreteTypeName() {
        return this.concreteType;
    }

    public String getPrincipleTypeName() {
        return this.principleType;
    }

    public String getAbstractTypeName() {
        return this.abstractType;
    }

    public String getNamingAuthority() {
        return this.namingAuthority;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceType)) {
            return false;
        }
        ServiceType t = (ServiceType)obj;
        return this.isService == t.isService && this.isAbstract == t.isAbstract && this.concreteType.equals(t.concreteType) && this.principleType.equals(t.principleType) && this.abstractType.equals(t.abstractType) && this.namingAuthority.equals(t.namingAuthority);
    }

    public boolean matches(Object obj) {
        if (!(obj instanceof ServiceType)) {
            return false;
        }
        ServiceType t = (ServiceType)obj;
        if (!this.isAbstract) {
            return this.equals(t);
        }
        return this.equals(t) || t.toString().equals(this.getAbstractTypeName());
    }

    public String toString() {
        return this.type;
    }

    public int hashCode() {
        int code = 0;
        if (this.concreteType != null) {
            code ^= this.concreteType.hashCode();
        }
        if (this.principleType != null) {
            code ^= this.principleType.hashCode() << 8;
        }
        if (this.abstractType != null) {
            code ^= this.abstractType.hashCode() << 16;
        }
        if (this.namingAuthority != null) {
            code ^= this.namingAuthority.hashCode() << 24;
        }
        return code;
    }
}

