/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.examples.internal.remoteservices.hello.ds.consumer;

import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.examples.remoteservices.hello.IHello;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxy;
import org.eclipse.ecf.remoteservice.RemoteServiceHelper;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;

public class HelloClientComponent {
    private static final String CONSUMER_NAME = "helloclientcomponent";
    private IContainerFactory containerFactory;

    void setContainerFactory(IContainerFactory cf) {
        this.containerFactory = cf;
    }

    void activate() throws Exception {
        this.containerFactory.createContainer("ecf.generic.client");
    }

    public void bindRemoteService(IHello proxy) {
        System.out.println("Got proxy IHello=" + proxy);
        proxy.hello("helloclientcomponent via proxy");
        IRemoteService remoteService = ((IRemoteServiceProxy)proxy).getRemoteService();
        IRemoteCallListener listener = new IRemoteCallListener(){

            public void handleEvent(IRemoteCallEvent event) {
                if (event instanceof IRemoteCallCompleteEvent) {
                    System.out.println("Completed hello remote service invocation using async");
                }
            }
        };
        RemoteServiceHelper.asyncExec((IRemoteService)remoteService, (String)"hello", (Object[])new Object[]{"helloclientcomponent via async"}, (IRemoteCallListener)listener);
    }
}

