/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.osgi.services.discovery.DiscoveredServiceTracker;
import org.eclipse.ecf.osgi.services.discovery.local.FileBasedDiscoveryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DSTTracker
implements ServiceTrackerCustomizer {
    private Map dsTrackers = null;
    private BundleContext context = null;

    public DSTTracker(BundleContext ctx) {
        this.context = ctx;
        this.dsTrackers = Collections.synchronizedMap(new HashMap());
    }

    public Map getDsTrackers() {
        return new HashMap(this.dsTrackers);
    }

    public Object addingService(ServiceReference dstTrackerReference) {
        DiscoveredServiceTracker tracker = (DiscoveredServiceTracker)this.context.getService(dstTrackerReference);
        if (!this.dsTrackers.keySet().contains(tracker)) {
            FileBasedDiscoveryImpl.log(3, "adding service tracker " + tracker);
            this.addTracker(dstTrackerReference);
            Map changedFilterCriteria = this.determineChangedFilterProperties(tracker, dstTrackerReference);
            FileBasedDiscoveryImpl.notifyOnAvailableSEDs(tracker, changedFilterCriteria);
            return tracker;
        }
        return null;
    }

    public void modifiedService(ServiceReference dstTrackerReference, Object arg1) {
        DiscoveredServiceTracker tracker = (DiscoveredServiceTracker)this.context.getService(dstTrackerReference);
        Map changedFilterCriteria = this.determineChangedFilterProperties(tracker, dstTrackerReference);
        FileBasedDiscoveryImpl.log(3, "modified service tracker " + tracker + " ;changedFilter = " + changedFilterCriteria);
        this.dsTrackers.remove(tracker);
        this.addTracker(dstTrackerReference);
        FileBasedDiscoveryImpl.notifyOnAvailableSEDs(tracker, changedFilterCriteria);
    }

    public void removedService(ServiceReference dstTrackerReference, Object arg1) {
        DiscoveredServiceTracker tracker = (DiscoveredServiceTracker)this.context.getService(dstTrackerReference);
        FileBasedDiscoveryImpl.log(3, "removing service tracker " + tracker);
        this.dsTrackers.remove(tracker);
    }

    private Map determineChangedFilterProperties(DiscoveredServiceTracker tracker, ServiceReference serviceReference) {
        HashMap<String, Collection> result = new HashMap<String, Collection>();
        Map props = (Map)this.dsTrackers.get(tracker);
        if (props != null) {
            Collection oldInterfaceCriteria = (Collection)props.get("osgi.remote.discovery.interest.interfaces");
            Collection oldFilterCriteria = (Collection)props.get("osgi.remote.discovery.interest.filters");
            Collection newInterfaceCriteria = (Collection)serviceReference.getProperty("osgi.remote.discovery.interest.interfaces");
            Collection newFilterCriteria = (Collection)serviceReference.getProperty("osgi.remote.discovery.interest.filters");
            result.put("osgi.remote.discovery.interest.interfaces", this.getAddedEntries(oldInterfaceCriteria, newInterfaceCriteria));
            result.put("osgi.remote.discovery.interest.filters", this.getAddedEntries(oldFilterCriteria, newFilterCriteria));
        } else {
            result.put("osgi.remote.discovery.interest.interfaces", new ArrayList());
            result.put("osgi.remote.discovery.interest.filters", new ArrayList());
        }
        return result;
    }

    private Collection getAddedEntries(Collection oldList, Collection newList) {
        ArrayList result = new ArrayList();
        if (newList == null || newList.isEmpty()) {
            return null;
        }
        if (oldList == null) {
            return newList;
        }
        Iterator it = newList.iterator();
        while (it.hasNext()) {
            Object val = it.next();
            if (oldList.contains(val)) continue;
            result.add(val);
        }
        return result;
    }

    private void addTracker(ServiceReference ref) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("osgi.remote.discovery.interest.interfaces", ref.getProperty("osgi.remote.discovery.interest.interfaces"));
        props.put("osgi.remote.discovery.interest.filters", ref.getProperty("osgi.remote.discovery.interest.filters"));
        this.dsTrackers.put((DiscoveredServiceTracker)this.context.getService(ref), props);
    }
}

