/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery.local;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ecf.osgi.services.discovery.ServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.discovery.local.FileBasedDiscoveryImpl;
import org.eclipse.ecf.osgi.services.discovery.local.Messages;
import org.eclipse.ecf.osgi.services.discovery.local.ServiceDescriptionParser;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class DiscoveryCommandProvider
implements CommandProvider {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private FileBasedDiscoveryImpl discovery = null;

    public DiscoveryCommandProvider(FileBasedDiscoveryImpl discovery) {
        this.discovery = discovery;
    }

    public String getHelp() {
        return String.valueOf(LINE_SEPARATOR) + Messages.getString("DiscoveryCommandProvider.CommandHeadline") + LINE_SEPARATOR + Messages.getString("DiscoveryCommandProvider.CommandHelp") + LINE_SEPARATOR;
    }

    public void _publish(CommandInterpreter ci) {
        Collection seds = this.getServiceEndpointDescriptions(ci);
        Iterator iterator = seds.iterator();
        while (iterator.hasNext()) {
            ServiceEndpointDescription sed = (ServiceEndpointDescription)iterator.next();
            this.discovery.publishService(sed);
        }
    }

    public void _unpublish(CommandInterpreter ci) {
        Collection seds = this.getServiceEndpointDescriptions(ci);
        Iterator iterator = seds.iterator();
        while (iterator.hasNext()) {
            ServiceEndpointDescription sed = (ServiceEndpointDescription)iterator.next();
            this.discovery.unpublishService(sed);
        }
    }

    private Collection getServiceEndpointDescriptions(CommandInterpreter ci) {
        String path = ci.nextArgument();
        try {
            URL url = new URL(path);
            InputStream inputStream = url.openStream();
            return new ServiceDescriptionParser().load(inputStream);
        }
        catch (IOException e) {
            ci.print((Object)NLS.bind((String)Messages.getString("DiscoveryCommandProvider.IOException"), (Object)path));
        }
        catch (ParserConfigurationException e) {
            ci.print((Object)Messages.getString("DiscoveryCommandProvider.ParserConfigurationException"));
        }
        catch (SAXException e) {
            ci.print((Object)NLS.bind((String)Messages.getString("DiscoveryCommandProvider.SAXException"), (Object)path));
        }
        return new ArrayList();
    }
}

