/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery.local;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ecf.osgi.services.discovery.local.ServiceEndpointDescriptionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ServiceDescriptionParser {
    private static final String SERVICEDESCRIPTION_ELEMENT = "service-description";
    private static final String PROVIDE_ELEMENT = "provide";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String INTERFACE_ATTR = "interface";
    private static final String NAME_ATTR = "name";
    private static final String TYPE_ATTR = "type";

    private void findElementsNamed(Node top, String name, List aList) {
        short type = top.getNodeType();
        switch (type) {
            case 10: {
                NamedNodeMap nodeMap = ((DocumentType)top).getEntities();
                int i = 0;
                while (i < nodeMap.getLength()) {
                    Entity entity = (Entity)nodeMap.item(i);
                    this.findElementsNamed(entity, name, aList);
                    ++i;
                }
                break;
            }
            case 1: {
                String elementName = top.getNodeName();
                if (name.equals(elementName)) {
                    aList.add(top);
                }
            }
            default: {
                Node child = top.getFirstChild();
                while (child != null) {
                    this.findElementsNamed(child, name, aList);
                    child = child.getNextSibling();
                }
                break block0;
            }
        }
    }

    private Collection processServiceDescriptionNodes(List serviceDescriptionNodes) {
        ArrayList<ServiceEndpointDescriptionImpl> res = new ArrayList<ServiceEndpointDescriptionImpl>();
        Iterator i = serviceDescriptionNodes.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            ServiceEndpointDescriptionImpl c = new ServiceEndpointDescriptionImpl();
            this.processServiceEndpointDescription(n, c);
            res.add(c);
        }
        return res;
    }

    private Collection loadServiceDescriptions(Document doc) {
        ArrayList ps = new ArrayList();
        this.findElementsNamed(doc, SERVICEDESCRIPTION_ELEMENT, ps);
        return this.processServiceDescriptionNodes(ps);
    }

    private String getAttributeValue(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        Node attrNode = attrs.getNamedItem(attrName);
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return "";
    }

    private void processServiceEndpointDescription(Node n, ServiceEndpointDescriptionImpl c) {
        ArrayList groupList = new ArrayList();
        this.findElementsNamed(n, PROVIDE_ELEMENT, groupList);
        ArrayList<String> providedInterfaces = null;
        if (!groupList.isEmpty()) {
            providedInterfaces = new ArrayList<String>();
            Iterator i = groupList.iterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                String providedInterfaceValue = this.getAttributeValue(node, INTERFACE_ATTR);
                if (providedInterfaceValue == null || providedInterfaceValue.equals("")) continue;
                providedInterfaces.add(providedInterfaceValue);
            }
            c.setProvidedInterfaces(providedInterfaces);
        }
        groupList = new ArrayList();
        this.findElementsNamed(n, PROPERTY_ELEMENT, groupList);
        HashMap<String, Object> providedProperties = null;
        if (!groupList.isEmpty()) {
            providedProperties = new HashMap<String, Object>();
            Iterator i = groupList.iterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                String name = this.getAttributeValue(node, NAME_ATTR);
                String value = node.getFirstChild().getNodeValue();
                String type = this.getAttributeValue(node, TYPE_ATTR);
                if (name == null || name.equals("") || value == null || value.equals("")) continue;
                if (type == null || type.equals("")) {
                    providedProperties.put(name, value);
                    continue;
                }
                if (type.equals("String")) {
                    providedProperties.put(name, value);
                    continue;
                }
                if (type.equals("Long")) {
                    providedProperties.put(name, Long.valueOf(value));
                    continue;
                }
                if (type.equals("Double")) {
                    providedProperties.put(name, Double.valueOf(value));
                    continue;
                }
                if (type.equals("Float")) {
                    providedProperties.put(name, Float.valueOf(value));
                    continue;
                }
                if (type.equals("Integer")) {
                    providedProperties.put(name, Integer.valueOf(value));
                    continue;
                }
                if (type.equals("Byte")) {
                    providedProperties.put(name, Byte.valueOf(value));
                    continue;
                }
                if (type.equals("Character")) {
                    providedProperties.put(name, new Character(value.charAt(0)));
                    continue;
                }
                if (type.equals("Boolean")) {
                    providedProperties.put(name, Boolean.valueOf(value));
                    continue;
                }
                if (!type.equals("Short")) continue;
                providedProperties.put(name, Short.valueOf(value));
            }
            c.setProvidedInterfaces(providedInterfaces);
            c.setProperties(providedProperties);
        }
    }

    public Collection load(InputStream ins) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(ins);
        return this.loadServiceDescriptions(doc);
    }
}

