/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery.local;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.osgi.services.discovery.ServiceEndpointDescription;
import org.eclipse.ecf.osgi.services.discovery.local.OneInterfaceSED;

public class ServiceEndpointDescriptionImpl
implements ServiceEndpointDescription {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String endpointID = null;
    private final Map listOfJSLPSEDs = Collections.synchronizedMap(new HashMap());
    private Map properties = new HashMap();

    public ServiceEndpointDescriptionImpl() {
        this.endpointID = this.getUUID();
    }

    public ServiceEndpointDescriptionImpl(Collection interfaceNames, Collection interfacesAndVersions, Collection endPointInterfaces, Map props, String endpntID) {
        if (interfaceNames == null) {
            throw new IllegalArgumentException("Given set of Java interfaces must not be null.");
        }
        if (interfaceNames.size() <= 0) {
            throw new IllegalArgumentException("Given set of Java interfaces must contain at least one service interface name.");
        }
        HashMap<String, String> interfaceAndVersionsMap = new HashMap<String, String>();
        if (interfacesAndVersions != null) {
            Iterator versionIterator = interfacesAndVersions.iterator();
            while (versionIterator.hasNext()) {
                String interfaceAndVersion = (String)versionIterator.next();
                int separatorIndex = interfaceAndVersion.indexOf("|");
                if (separatorIndex <= 0 || separatorIndex + 1 == interfaceAndVersion.length()) break;
                String interfaceName = interfaceAndVersion.substring(0, separatorIndex);
                String version = interfaceAndVersion.substring(separatorIndex + 1);
                if (interfaceName == null || interfaceName.length() <= 0 || version == null || version.length() <= 0) continue;
                interfaceAndVersionsMap.put(interfaceName, version);
            }
        }
        HashMap<String, String> endPointInterfacesMap = new HashMap<String, String>();
        if (endPointInterfaces != null) {
            Iterator endpIterator = endPointInterfaces.iterator();
            while (endpIterator.hasNext()) {
                String interfaceAndEndpoint = (String)endpIterator.next();
                int separatorIndex = interfaceAndEndpoint.indexOf("|");
                if (separatorIndex <= 0 || separatorIndex + 1 == interfaceAndEndpoint.length()) break;
                String interfaceName = interfaceAndEndpoint.substring(0, separatorIndex);
                String endpInterface = interfaceAndEndpoint.substring(separatorIndex + 1);
                if (interfaceName == null || interfaceName.length() <= 0 || endpInterface == null || endpInterface.length() <= 0) continue;
                endPointInterfacesMap.put(interfaceName, endpInterface);
            }
        }
        Iterator it = interfaceNames.iterator();
        while (it.hasNext()) {
            String ifName = (String)it.next();
            OneInterfaceSED jslpSED = new OneInterfaceSED();
            jslpSED.setInterfaceName(ifName);
            jslpSED.setVersion((String)interfaceAndVersionsMap.get(ifName));
            jslpSED.setEndpointInterface((String)endPointInterfacesMap.get(ifName));
            this.listOfJSLPSEDs.put(ifName, jslpSED);
        }
        this.endpointID = endpntID != null ? endpntID : this.getUUID();
        if (props != null) {
            this.properties = new HashMap(props);
        }
        this.addInterfacesAndVersionsToProperties(interfaceNames, interfacesAndVersions, endPointInterfaces, this.endpointID);
    }

    private void addInterfacesAndVersionsToProperties(Collection interfaceNames, Collection versions, Collection endPointInterfaces, String endpntID) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put("osgi.remote.service.interfaces", interfaceNames);
        if (versions != null) {
            this.properties.put("osgi.remote.service.interfaces.version", versions);
        }
        if (endPointInterfaces != null) {
            this.properties.put("osgi.remote.endpoint.interfaces", endPointInterfaces);
        }
        if (endpntID != null) {
            this.properties.put("osgi.remote.endpoint.id", endpntID);
        }
    }

    public Map getProperties() {
        return new HashMap(this.properties);
    }

    public Object getProperty(String key) {
        return this.getProperties().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer("Service:" + LINE_SEPARATOR);
        if (this.endpointID != null) {
            sb.append("EndpointID = ");
            sb.append(this.endpointID);
            sb.append(LINE_SEPARATOR);
        }
        Map map = this.listOfJSLPSEDs;
        synchronized (map) {
            Iterator it = this.listOfJSLPSEDs.values().iterator();
            int i = 1;
            while (it.hasNext()) {
                sb.append("Interface ");
                sb.append(i);
                sb.append(LINE_SEPARATOR);
                sb.append((OneInterfaceSED)it.next());
                ++i;
            }
        }
        Iterator it = this.properties.keySet().iterator();
        if (it.hasNext()) {
            sb.append("properties=" + LINE_SEPARATOR);
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = this.properties.get(key);
            if (value == null) {
                value = "<null>";
            }
            sb.append("\t");
            sb.append(key);
            sb.append("=");
            sb.append(value.toString());
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getProvidedInterfaces() {
        ArrayList<String> l = new ArrayList<String>();
        Map map = this.listOfJSLPSEDs;
        synchronized (map) {
            Iterator it = this.listOfJSLPSEDs.values().iterator();
            while (it.hasNext()) {
                l.add(((OneInterfaceSED)it.next()).getInterfaceName());
            }
        }
        return l;
    }

    public String getEndpointInterfaceName(String interfaceName) {
        OneInterfaceSED jSED = (OneInterfaceSED)this.listOfJSLPSEDs.get(interfaceName);
        if (jSED != null) {
            return jSED.getEndpointInterface();
        }
        return null;
    }

    public String getVersion(String interfaceName) {
        OneInterfaceSED jSED = (OneInterfaceSED)this.listOfJSLPSEDs.get(interfaceName);
        if (jSED != null) {
            return jSED.getVersion();
        }
        return null;
    }

    public URI getLocation() {
        Object uriObject = this.getProperty("osgi.remote.endpoint.location");
        if (uriObject instanceof URI) {
            return (URI)uriObject;
        }
        if (uriObject instanceof String) {
            try {
                return new URI((String)uriObject);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (uriObject == null) {
            return null;
        }
        throw new RuntimeException("Service location property is not of expected type URI or String. Property = " + uriObject.toString());
    }

    public Collection getPropertyKeys() {
        return this.getProperties().keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String key, Object value) {
        Map map = this.listOfJSLPSEDs;
        synchronized (map) {
            Iterator it = this.listOfJSLPSEDs.values().iterator();
            while (it.hasNext()) {
                ((OneInterfaceSED)it.next()).addProperty(key, value);
            }
        }
        if (key.equals("osgi.remote.endpoint.id")) {
            this.endpointID = (String)value;
        }
        this.properties.put(key, value);
    }

    private String getUUID() {
        return String.valueOf(new UID().toString()) + new VMID().toString();
    }

    public static String convertJavaInterface2Path(String javaInterfaceName) {
        return javaInterfaceName != null ? ":" + javaInterfaceName.replace('.', '/') : "";
    }

    public static String convertPath2JavaInterface(String interfaceNameEncodedAsPath) {
        return interfaceNameEncodedAsPath != null ? interfaceNameEncodedAsPath.replace('/', '.') : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object serviceDescription) {
        if (!(serviceDescription instanceof ServiceEndpointDescription)) {
            return false;
        }
        ServiceEndpointDescription descr = (ServiceEndpointDescription)serviceDescription;
        if (this.endpointID != null || descr.getEndpointID() != null) {
            if (this.endpointID != null) {
                return this.endpointID.equals(descr.getEndpointID());
            }
            return false;
        }
        Collection descrInterfaces = descr.getProvidedInterfaces();
        if (descrInterfaces == null) {
            throw new RuntimeException("The service does not contain requiered parameter interfaces. " + descr);
        }
        boolean found = false;
        Map map = this.listOfJSLPSEDs;
        synchronized (map) {
            Iterator it = this.listOfJSLPSEDs.values().iterator();
            while (it.hasNext()) {
                OneInterfaceSED sed = (OneInterfaceSED)it.next();
                if (!sed.equals(serviceDescription)) continue;
                found = true;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.endpointID != null) {
            return this.endpointID.hashCode();
        }
        int result = 17;
        Map map = this.listOfJSLPSEDs;
        synchronized (map) {
            Iterator it = this.listOfJSLPSEDs.values().iterator();
            while (it.hasNext()) {
                result = 37 * result + ((OneInterfaceSED)it.next()).hashCode();
            }
        }
        if (this.endpointID != null) {
            result = 37 * result + this.endpointID.hashCode();
        }
        if (this.properties != null) {
            result = 37 * result + this.properties.hashCode();
        }
        return result;
    }

    public String getEndpointID() {
        return this.endpointID;
    }

    public void setProvidedInterfaces(Collection interfaceNames) {
        if (interfaceNames == null || interfaceNames.isEmpty()) {
            return;
        }
        this.listOfJSLPSEDs.clear();
        Iterator it = interfaceNames.iterator();
        while (it.hasNext()) {
            String ifName = (String)it.next();
            OneInterfaceSED jslpSED = new OneInterfaceSED();
            jslpSED.setInterfaceName(ifName);
            this.listOfJSLPSEDs.put(ifName, jslpSED);
        }
    }

    public void setProperties(Map props) {
        this.properties = new HashMap(props);
    }
}

