/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.discovery;

import java.net.URI;
import java.util.Arrays;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.osgi.services.discovery.RemoteServiceEndpointDescription;

public class RemoteServiceEndpointDescriptionImpl
extends RemoteServiceEndpointDescription {
    private final ID endpointId;
    private final IServiceID serviceId;
    private ID targetId = null;
    private int hashCode = 7;

    public RemoteServiceEndpointDescriptionImpl(IServiceInfo serviceInfo) {
        super(((ServiceProperties)serviceInfo.getServiceProperties()).asProperties());
        this.serviceId = serviceInfo.getServiceID();
        IServiceProperties serviceProperties = serviceInfo.getServiceProperties();
        byte[] endpointBytes = serviceProperties.getPropertyBytes("ecf.sp.cid");
        if (endpointBytes == null) {
            throw new IDCreateException("ServiceEndpointDescription endpointBytes cannot be null");
        }
        String endpointStr = new String(endpointBytes);
        String namespaceStr = serviceProperties.getPropertyString("ecf.sp.cns");
        if (namespaceStr == null) {
            throw new IDCreateException("ServiceEndpointDescription namespaceStr cannot be null");
        }
        this.endpointId = IDFactory.getDefault().createID(namespaceStr, endpointStr);
        byte[] targetBytes = serviceProperties.getPropertyBytes("ecf.sp.tid");
        if (targetBytes != null) {
            String targetStr = new String(targetBytes);
            String targetNamespaceStr = serviceProperties.getPropertyString("ecf.sp.tns");
            if (targetNamespaceStr == null) {
                targetNamespaceStr = namespaceStr;
            }
            this.targetId = IDFactory.getDefault().createID(targetNamespaceStr, targetStr);
        }
        URI serviceLocation = this.serviceId.getLocation();
        long rsId = this.getRemoteServiceId();
        this.hashCode = 31 * this.hashCode + (int)(rsId ^ rsId >>> 32);
        this.hashCode = 31 * this.hashCode + serviceLocation.hashCode();
    }

    public ID getEndpointAsID() throws IDCreateException {
        return this.endpointId;
    }

    public ID getConnectTargetID() {
        return this.targetId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteServiceEndpointDescriptionImpl other = (RemoteServiceEndpointDescriptionImpl)obj;
        return this.serviceId.getLocation().equals(other.serviceId.getLocation()) && this.getRemoteServiceId() == other.getRemoteServiceId();
    }

    public IServiceID getServiceID() {
        return this.serviceId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ServiceEndpointDescriptionImpl[");
        sb.append(";providedInterfaces=").append(this.getProvidedInterfaces());
        String[] supportedConfigs = this.getSupportedConfigs();
        sb.append(";supportedConfigTypes").append(supportedConfigs == null ? "null" : Arrays.asList(supportedConfigs).toString());
        String[] serviceIntents = this.getServiceIntents();
        sb.append(";serviceIntents").append(serviceIntents == null ? "null" : Arrays.asList(serviceIntents).toString());
        sb.append(";location=").append(this.getLocation());
        sb.append(";remoteServiceId=").append(this.getRemoteServiceId());
        sb.append(";discoveryServiceID=").append(this.getServiceID());
        sb.append(";endpointID=").append(this.getEndpointID());
        sb.append(";endpointAsID=").append(this.getEndpointAsID());
        sb.append(";connectTargetID=").append(this.getConnectTargetID());
        sb.append(";remoteServicesFilter=").append(this.getRemoteServicesFilter());
        sb.append(";props=").append(this.getProperties()).append("]");
        return sb.toString();
    }
}

