/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.LogUtility;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;
import org.osgi.framework.ServiceReference;

public abstract class AbstractContainerFinder {
    public static final IRemoteServiceContainer[] EMPTY_REMOTE_SERVICE_CONTAINER_ARRAY = new IRemoteServiceContainer[0];
    static /* synthetic */ Class class$0;

    protected IIDFactory getIDFactory() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        return activator.getIDFactory();
    }

    protected IContainerManager getContainerManager() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        return activator.getContainerManager();
    }

    protected IContainerFactory getContainerFactory() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        IContainerManager containerManager = this.getContainerManager();
        if (containerManager == null) {
            return null;
        }
        return containerManager.getContainerFactory();
    }

    protected ContainerTypeDescription[] getContainerTypeDescriptions() {
        IContainerFactory containerFactory = this.getContainerFactory();
        if (containerFactory == null) {
            return null;
        }
        return containerFactory.getDescriptions().toArray(new ContainerTypeDescription[0]);
    }

    protected IContainer[] getContainers() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        IContainerManager containerManager = activator.getContainerManager();
        if (containerManager == null) {
            return null;
        }
        return containerManager.getAllContainers();
    }

    protected IRemoteServiceContainerAdapter hasRemoteServiceContainerAdapter(IContainer container) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IRemoteServiceContainerAdapter)container.getAdapter((Class)clazz);
    }

    protected ContainerTypeDescription getContainerTypeDescription(IContainer container) {
        IContainerManager containerManager = this.getContainerManager();
        if (containerManager == null) {
            return null;
        }
        return containerManager.getContainerTypeDescription(container.getID());
    }

    protected IRemoteServiceContainer[] getRemoteServiceContainers(IContainer[] containers) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        int i = 0;
        while (i < containers.length) {
            IRemoteServiceContainerAdapter adapter = this.hasRemoteServiceContainerAdapter(containers[i]);
            if (adapter != null) {
                results.add(new RemoteServiceContainer(containers[i], adapter));
            }
            ++i;
        }
        return results.toArray(new IRemoteServiceContainer[0]);
    }

    protected boolean includeContainerWithConnectNamespace(IContainer container, String connectNamespaceName) {
        Namespace namespace;
        return connectNamespaceName != null && (namespace = container.getConnectNamespace()) != null && namespace.getName().equals(connectNamespaceName);
    }

    protected void connectContainer(IContainer container, ID connectTargetID, IConnectContext connectContext) throws ContainerConnectException {
        this.trace("connectContainer", "Connecting container=" + container.getID() + " to connectTargetID=" + connectTargetID);
        container.connect(connectTargetID, connectContext);
    }

    protected String[] getSupportedConfigTypes(ContainerTypeDescription containerTypeDescription) {
        String[] supportedConfigs = containerTypeDescription.getSupportedConfigs();
        return supportedConfigs == null ? new String[]{} : supportedConfigs;
    }

    protected String[] getSupportedIntents(ContainerTypeDescription containerTypeDescription) {
        String[] supportedIntents = containerTypeDescription.getSupportedIntents();
        return supportedIntents == null ? new String[]{} : supportedIntents;
    }

    protected IContainer createContainer(ServiceReference serviceReference, ContainerTypeDescription containerTypeDescription) throws ContainerCreateException {
        IContainerFactory containerFactory = this.getContainerFactory();
        if (containerFactory == null) {
            throw new ContainerCreateException("container factory must not be null");
        }
        Object containerFactoryArguments = serviceReference.getProperty("org.eclipse.ecf.containerFactoryArgs");
        if (containerFactoryArguments instanceof String) {
            return containerFactory.createContainer(containerTypeDescription, (String)containerFactoryArguments);
        }
        if (containerFactoryArguments instanceof ID) {
            return containerFactory.createContainer(containerTypeDescription, (ID)containerFactoryArguments);
        }
        if (containerFactoryArguments instanceof Object[]) {
            return containerFactory.createContainer(containerTypeDescription, (Object[])containerFactoryArguments);
        }
        return containerFactory.createContainer(containerTypeDescription);
    }

    protected ID createTargetID(IContainer container, Object target) {
        ID targetID = null;
        if (target instanceof String) {
            targetID = this.getIDFactory().createID(container.getConnectNamespace(), (String)target);
        } else if (target instanceof Object[]) {
            targetID = this.getIDFactory().createID(container.getConnectNamespace(), (Object[])target);
        }
        return targetID;
    }

    protected void disconnectContainer(IContainer container) {
        container.disconnect();
    }

    protected IConnectContext createConnectContext(ServiceReference serviceReference, IContainer container, Object context) {
        if (context instanceof IConnectContext) {
            return (IConnectContext)context;
        }
        return null;
    }

    protected void logException(String string, Exception e) {
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.distribution", string, (Throwable)e));
    }

    protected void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/containerfinder", this.getClass(), message);
    }

    protected void traceException(String methodName, String message, Throwable t) {
        LogUtility.traceException(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/exceptions/catching", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message, Throwable t) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/containerfinder", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/containerfinder", this.getClass(), message);
    }

    protected void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/containerfinder", this.getClass(), message);
    }

    protected boolean matchConnectNamespace(IContainer container, ID endpointID) {
        if (endpointID == null) {
            return false;
        }
        return endpointID.getNamespace().getName().equals(container.getConnectNamespace().getName());
    }

    protected boolean matchContainerID(IContainer container, ID endpointID) {
        if (endpointID == null) {
            return false;
        }
        return endpointID.equals((Object)container.getID());
    }
}

