/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.r_osgi;

import ch.ethz.iks.r_osgi.RemoteOSGiException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteServiceReferenceImpl;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallStartEvent;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.eclipse.equinox.concurrent.future.TimeoutException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceException;

final class RemoteServiceImpl
implements IRemoteService,
InvocationHandler {
    static final Object[] EMPTY_PARAMETERS = new Object[0];
    RemoteServiceReferenceImpl refImpl;
    Object service;
    private long nextID;
    static /* synthetic */ Class class$0;

    public RemoteServiceImpl(RemoteServiceReferenceImpl refImpl, Object service) {
        this.refImpl = refImpl;
        this.service = service;
    }

    public void callAsync(IRemoteCall call, IRemoteCallListener listener) {
        new AsyncResult(call, listener).start();
    }

    public IFuture callAsync(final IRemoteCall call) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RemoteServiceImpl.this.callSync(call);
            }
        }, null);
    }

    public Object callSync(final IRemoteCall call) throws ECFException {
        Object[] ps = call.getParameters();
        final Object[] parameters = ps == null ? EMPTY_PARAMETERS : ps;
        final Class[] formalParams = new Class[parameters.length];
        int i = 0;
        while (i < formalParams.length) {
            formalParams[i] = call.getParameters()[i].getClass();
            ++i;
        }
        ThreadsExecutor executor = new ThreadsExecutor();
        IFuture future = executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return RemoteServiceImpl.this.service.getClass().getMethod(call.getMethod(), formalParams).invoke(RemoteServiceImpl.this.service, parameters);
            }
        }, null);
        Object result = null;
        try {
            result = future.get(call.getTimeout());
        }
        catch (OperationCanceledException e) {
            throw new ECFException("callSync cancelled", (Throwable)e);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (TimeoutException e) {
            throw new ECFException(NLS.bind((String)"callSync timed out after {0} ms", (Object)Long.toString(call.getTimeout())), (Throwable)new TimeoutException(call.getTimeout()));
        }
        IStatus status = future.getStatus();
        if (!status.isOK()) {
            throw new ECFException("Exception during callSync", status.getException());
        }
        return result;
    }

    public void fireAsync(IRemoteCall call) throws ECFException {
        try {
            this.callAsync(call);
        }
        catch (RemoteOSGiException r) {
            throw new ECFException((Throwable)r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Object getProxy() throws ECFException {
        Object proxy;
        if (!this.refImpl.getR_OSGiServiceReference().isActive()) {
            throw new ECFException("Container currently not connected");
        }
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            String[] clazzes = this.refImpl.getR_OSGiServiceReference().getServiceInterfaces();
            Class[] cs = new Class[clazzes.length + 1];
            int i = 0;
            while (i < clazzes.length) {
                cs[i] = Class.forName(clazzes[i], true, cl);
                ++i;
            }
            int n = clazzes.length;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceProxy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            cs[n] = clazz;
            proxy = Proxy.newProxyInstance(cl, cs, (InvocationHandler)this);
        }
        catch (Exception e) {
            throw new ECFException("Exception creating proxy for remote service", (Throwable)e);
        }
        return proxy;
    }

    synchronized long getNextID() {
        return this.nextID++;
    }

    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        try {
            if (method.getName().equals("toString")) {
                String[] clazzes = this.refImpl.getR_OSGiServiceReference().getServiceInterfaces();
                String proxyClass = clazzes.length == 1 ? clazzes[0] : Arrays.asList(clazzes).toString();
                return String.valueOf(proxyClass) + ".proxy@" + this.refImpl.getID();
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("equals")) {
                if (args == null || args.length == 0) {
                    return Boolean.FALSE;
                }
                try {
                    return new Boolean(Proxy.getInvocationHandler(args[0]).equals(this));
                }
                catch (IllegalArgumentException e) {
                    return Boolean.FALSE;
                }
            }
            if (method.getName().equals("getRemoteService")) {
                return this;
            }
            if (method.getName().equals("getRemoteServiceReference")) {
                return this.refImpl;
            }
            return this.callSync(new IRemoteCall(){

                public String getMethod() {
                    return method.getName();
                }

                public Object[] getParameters() {
                    return args == null ? EMPTY_PARAMETERS : args;
                }

                public long getTimeout() {
                    return IRemoteCall.DEFAULT_TIMEOUT;
                }
            });
        }
        catch (Throwable t) {
            throw new ServiceException("Service exception on remote service proxy rsid=" + this.refImpl.getID(), 5, t);
        }
    }

    private class AsyncResult
    extends Thread {
        Object result;
        Throwable exception;
        IRemoteCall call;
        private IRemoteCallListener listener;

        AsyncResult(IRemoteCall call, IRemoteCallListener listener) {
            this.call = call;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object r = null;
            Throwable e = null;
            long reqID = RemoteServiceImpl.this.getNextID();
            if (this.listener != null) {
                this.listener.handleEvent((IRemoteCallEvent)new IRemoteCallStartEvent(this, reqID){
                    final /* synthetic */ AsyncResult this$1;
                    private final /* synthetic */ long val$reqID;
                    {
                        this.this$1 = asyncResult;
                        this.val$reqID = l;
                    }

                    public IRemoteCall getCall() {
                        return this.this$1.call;
                    }

                    public IRemoteServiceReference getReference() {
                        return AsyncResult.access$0((AsyncResult)this.this$1).refImpl;
                    }

                    public long getRequestId() {
                        return this.val$reqID;
                    }
                });
            }
            try {
                r = RemoteServiceImpl.this.callSync(this.call);
            }
            catch (Throwable t) {
                e = t;
            }
            AsyncResult asyncResult = this;
            synchronized (asyncResult) {
                this.result = r;
                this.exception = e;
                this.notify();
            }
            if (this.listener != null) {
                this.listener.handleEvent((IRemoteCallEvent)new IRemoteCallCompleteEvent(this, reqID){
                    final /* synthetic */ AsyncResult this$1;
                    private final /* synthetic */ long val$reqID;
                    {
                        this.this$1 = asyncResult;
                        this.val$reqID = l;
                    }

                    public Throwable getException() {
                        return this.this$1.exception;
                    }

                    public Object getResponse() {
                        return this.this$1.result;
                    }

                    public boolean hadException() {
                        return this.this$1.exception != null;
                    }

                    public long getRequestId() {
                        return this.val$reqID;
                    }
                });
            }
        }

        static /* synthetic */ RemoteServiceImpl access$0(AsyncResult asyncResult) {
            return asyncResult.RemoteServiceImpl.this;
        }
    }
}

