/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.r_osgi;

import java.util.Dictionary;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.provider.r_osgi.LocalRemoteServiceReferenceImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.ServiceRegistration;

final class RemoteServiceRegistrationImpl
implements IRemoteServiceRegistration {
    private IRemoteServiceID remoteServiceID;
    private ServiceRegistration reg;
    private IRemoteServiceReference remoteReference;

    public RemoteServiceRegistrationImpl(IRemoteServiceID remoteServiceID, ServiceRegistration reg) {
        Assert.isNotNull((Object)remoteServiceID);
        Assert.isNotNull((Object)reg);
        this.remoteServiceID = remoteServiceID;
        this.reg = reg;
        this.remoteReference = new LocalRemoteServiceReferenceImpl(remoteServiceID, reg.getReference());
    }

    public ID getContainerID() {
        return this.getID().getContainerID();
    }

    public Object getProperty(String key) {
        return this.reg.getReference().getProperty(key);
    }

    public String[] getPropertyKeys() {
        return this.reg.getReference().getPropertyKeys();
    }

    public IRemoteServiceReference getReference() {
        return this.remoteReference;
    }

    public void setProperties(Dictionary properties) {
        this.reg.setProperties(properties);
    }

    public void unregister() {
        this.reg.unregister();
    }

    public IRemoteServiceID getID() {
        return this.remoteServiceID;
    }
}

