/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.xmpp.identity;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.osgi.util.NLS;

public class XMPPFileID
extends BaseID
implements IFileID {
    private static final long serialVersionUID = 9052434567658554404L;
    public static final String FILENAME_KEY = "file";
    public static final String XMPPIDNAMESPACE_KEY = "ns";
    private static final String UTF_8 = "utf-8";
    private final XMPPID xmppid;
    private final String filename;
    private final URL url;

    public XMPPFileID(XMPPID id, String fn) throws MalformedURLException {
        Assert.isNotNull((Object)((Object)id));
        Assert.isNotNull((Object)fn);
        this.xmppid = id;
        this.filename = fn;
        this.url = XMPPFileID.createURL(this.xmppid, this.filename);
    }

    XMPPFileID(URL url) throws IDCreateException, MalformedURLException {
        Assert.isNotNull((Object)url);
        this.url = url;
        this.xmppid = (XMPPID)IDFactory.getDefault().createID(XMPPFileID.getPropertyFromURL(XMPPIDNAMESPACE_KEY, url), XMPPFileID.getIDStringFromFileURL(url));
        this.filename = XMPPFileID.getPropertyFromURL(FILENAME_KEY, url);
    }

    private static String getIDStringFromFileURL(URL url) throws MalformedURLException {
        String result = url.getAuthority();
        String path = url.getPath();
        path = path.startsWith("/") ? path : "/" + path;
        return String.valueOf(result) + path;
    }

    private static String getPropertyFromURL(String propKey, URL url) throws MalformedURLException {
        String query = url.getQuery();
        if (query == null || query.equals("")) {
            throw new MalformedURLException(NLS.bind((String)"Cannot have empty query for URL {0}", (Object)url));
        }
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (!tok.startsWith(String.valueOf(propKey) + "=")) continue;
            try {
                return URLDecoder.decode(tok.substring(propKey.length() + "=".length()), UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new MalformedURLException(NLS.bind((String)"Could not decode {0} in URL {1}", (Object)propKey, (Object)url));
            }
        }
        throw new MalformedURLException(NLS.bind((String)"Key {0} not found in URL {1}", (Object)propKey, (Object)url));
    }

    public static URL createURL(XMPPID xmppid2, String filename2) throws MalformedURLException {
        StringBuffer buf = new StringBuffer("xmppfile");
        buf.append("://");
        buf.append(xmppid2.getFQName()).append(XMPPFileID.createQuery(filename2, xmppid2.getNamespace().getName()));
        return new URL(buf.toString());
    }

    public static String createQuery(String filename, String xmppidScheme) throws MalformedURLException {
        StringBuffer sb = new StringBuffer("?");
        try {
            sb.append(FILENAME_KEY).append("=").append(URLEncoder.encode(filename, UTF_8));
            sb.append("&");
            sb.append(XMPPIDNAMESPACE_KEY).append("=").append(URLEncoder.encode(xmppidScheme, UTF_8));
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new MalformedURLException("filename encoding exception");
        }
    }

    public XMPPID getXMPPID() {
        return this.xmppid;
    }

    public String toExternalForm() {
        return this.url.toExternalForm();
    }

    protected int namespaceCompareTo(BaseID o) {
        return this.getName().compareTo(o.getName());
    }

    protected boolean namespaceEquals(BaseID o) {
        if (!(o instanceof XMPPFileID)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        XMPPFileID other = (XMPPFileID)o;
        return this.xmppid.equals((Object)other.xmppid) && this.filename.equals(other.filename);
    }

    protected String namespaceGetName() {
        return this.toExternalForm();
    }

    protected int namespaceHashCode() {
        return this.xmppid.hashCode() ^ this.filename.hashCode();
    }

    public String getFilename() {
        return this.filename;
    }

    public URL getURL() throws MalformedURLException {
        return this.url;
    }
}

