/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.rest.client;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.AbstractClientService;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteCallableRequestType;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.rest.IRestCall;
import org.eclipse.ecf.remoteservice.rest.RestException;
import org.eclipse.ecf.remoteservice.rest.client.AbstractRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpDeleteRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpGetRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpPostRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpPutRequestType;
import org.eclipse.ecf.remoteservice.rest.client.RestClientContainer;
import org.eclipse.osgi.util.NLS;

public class RestClientService
extends AbstractClientService {
    protected HttpClient httpClient = new HttpClient();

    public RestClientService(RestClientContainer container, RemoteServiceClientRegistration registration) {
        super((AbstractClientContainer)container, registration);
    }

    protected Object invokeRemoteCall(IRemoteCall call, IRemoteCallable callable) throws ECFException {
        String uri = this.prepareEndpointAddress(call, callable);
        HttpMethod httpMethod = this.createAndPrepareHttpMethod(uri, call, callable);
        String responseBody = null;
        int responseCode = -1;
        try {
            responseCode = this.httpClient.executeMethod(httpMethod);
            if (responseCode == 200) {
                responseBody = httpMethod.getResponseBodyAsString();
                if (responseBody == null) {
                    throw new RestException("Invalid server response", responseCode);
                }
            } else {
                this.handleException(NLS.bind((String)"Http response not OK.  URL={0}, responseCode={1}", (Object)uri, (Object)new Integer(responseCode)), null, responseCode);
            }
        }
        catch (HttpException e) {
            this.handleException("Transport HttpException", e, responseCode);
        }
        catch (IOException e) {
            this.handleException("Transport IOException", e, responseCode);
        }
        Object result = null;
        try {
            result = this.processResponse(uri, call, callable, this.convertResponseHeaders(httpMethod.getResponseHeaders()), responseBody);
        }
        catch (NotSerializableException e) {
            this.handleException(NLS.bind((String)"Exception deserializing response.  URL={0}, responseCode={1}", (Object)uri, (Object)new Integer(responseCode)), e, responseCode);
        }
        return result;
    }

    protected void handleException(String message, Throwable e, int responseCode) throws RestException {
        throw new RestException(message, e, responseCode);
    }

    protected void setupTimeouts(HttpClient httpClient, IRemoteCall call, IRemoteCallable callable) {
        long callTimeout = call.getTimeout();
        if (callTimeout == IRemoteCall.DEFAULT_TIMEOUT) {
            callTimeout = callable.getDefaultTimeout();
        }
        int timeout = (int)callTimeout;
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
        httpClient.getParams().setConnectionManagerTimeout((long)timeout);
    }

    private Map convertResponseHeaders(Header[] headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (headers == null) {
            return result;
        }
        int i = 0;
        while (i < headers.length) {
            String name = headers[i].getName();
            String value = headers[i].getValue();
            result.put(name, value);
            ++i;
        }
        return result;
    }

    protected void addRequestHeaders(HttpMethod httpMethod, IRemoteCall call, IRemoteCallable callable) {
        Map callHeaders;
        Map requestHeaders;
        Map map = requestHeaders = callable.getRequestType() instanceof AbstractRequestType ? ((AbstractRequestType)callable.getRequestType()).getDefaultRequestHeaders() : new HashMap();
        if (requestHeaders == null) {
            requestHeaders = new HashMap();
        }
        if (call instanceof IRestCall && (callHeaders = ((IRestCall)call).getRequestHeaders()) != null) {
            requestHeaders.putAll(requestHeaders);
        }
        Set keySet = requestHeaders.keySet();
        Object[] headers = keySet.toArray();
        int i = 0;
        while (i < headers.length) {
            String key = (String)headers[i];
            String value = (String)requestHeaders.get(key);
            httpMethod.addRequestHeader(key, value);
            ++i;
        }
    }

    protected HttpMethod createAndPrepareHttpMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws RestException {
        HttpMethod httpMethod;
        block7: {
            httpMethod = null;
            IRemoteCallableRequestType requestType = callable.getRequestType();
            if (requestType == null) {
                throw new RestException("Request type for call cannot be null");
            }
            try {
                if (requestType instanceof HttpGetRequestType) {
                    httpMethod = this.prepareGetMethod(uri, call, callable);
                    break block7;
                }
                if (requestType instanceof HttpPostRequestType) {
                    httpMethod = this.preparePostMethod(uri, call, callable);
                    break block7;
                }
                if (requestType instanceof HttpPutRequestType) {
                    httpMethod = this.preparePutMethod(uri, call, callable);
                    break block7;
                }
                if (requestType instanceof HttpDeleteRequestType) {
                    httpMethod = this.prepareDeleteMethod(uri, call, callable);
                    break block7;
                }
                throw new RestException(NLS.bind((String)"HTTP method {0} not supported", (Object)requestType));
            }
            catch (NotSerializableException e) {
                throw new RestException("Could not serialize parameters for uri=" + uri + " call=" + call + " callable=" + callable);
            }
        }
        this.addRequestHeaders(httpMethod, call, callable);
        this.setupAuthenticaton(this.httpClient, httpMethod);
        this.httpClient.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)new Boolean(true));
        this.setupTimeouts(this.httpClient, call, callable);
        return httpMethod;
    }

    protected HttpMethod prepareDeleteMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws RestException {
        return new DeleteMethod(uri);
    }

    protected HttpMethod preparePutMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        PutMethod result = new PutMethod(uri);
        HttpPutRequestType putRequestType = (HttpPutRequestType)callable.getRequestType();
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (putRequestType.useRequestEntity()) {
            if (defaultParameters != null && defaultParameters.length > 0 && parameters != null && parameters.length > 0) {
                RequestEntity requestEntity = putRequestType.generateRequestEntity(uri, call, callable, defaultParameters[0], parameters[0]);
                result.setRequestEntity(requestEntity);
            }
        } else {
            NameValuePair[] params = this.toNameValuePairs(uri, call, callable);
            if (params != null) {
                result.setQueryString(params);
            }
        }
        return result;
    }

    protected HttpMethod preparePostMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        PostMethod result = new PostMethod(uri);
        HttpPostRequestType postRequestType = (HttpPostRequestType)callable.getRequestType();
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (postRequestType.useRequestEntity()) {
            if (defaultParameters != null && defaultParameters.length > 0 && parameters != null && parameters.length > 0) {
                RequestEntity requestEntity = postRequestType.generateRequestEntity(uri, call, callable, defaultParameters[0], parameters[0]);
                result.setRequestEntity(requestEntity);
            }
        } else {
            NameValuePair[] params = this.toNameValuePairs(uri, call, callable);
            if (params != null) {
                result.setQueryString(params);
            }
        }
        return result;
    }

    protected HttpMethod prepareGetMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        GetMethod result = new GetMethod(uri);
        NameValuePair[] params = this.toNameValuePairs(uri, call, callable);
        if (params != null) {
            result.setQueryString(params);
        }
        return result;
    }

    protected NameValuePair[] toNameValuePairs(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        IRemoteCallParameter[] restParameters = this.prepareParameters(uri, call, callable);
        ArrayList<NameValuePair> nameValueList = new ArrayList<NameValuePair>();
        if (restParameters != null) {
            int i = 0;
            while (i < restParameters.length) {
                try {
                    String parameterValue = null;
                    Object o = restParameters[i].getValue();
                    if (o instanceof String) {
                        parameterValue = (String)o;
                    } else if (o != null) {
                        parameterValue = o.toString();
                    }
                    if (parameterValue != null) {
                        String parameterName = URLEncoder.encode(restParameters[i].getName(), "UTF-8");
                        parameterValue = URLEncoder.encode(parameterValue, "UTF-8");
                        nameValueList.add(new NameValuePair(parameterName, parameterValue));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return nameValueList.toArray(new NameValuePair[nameValueList.size()]);
    }

    protected void setupAuthenticaton(HttpClient httpClient, HttpMethod method) {
        IConnectContext connectContext = this.container.getConnectContextForAuthentication();
        if (connectContext != null) {
            NameCallback nameCallback = new NameCallback("");
            ObjectCallback passwordCallback = new ObjectCallback();
            Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
            CallbackHandler callbackHandler = connectContext.getCallbackHandler();
            if (callbackHandler == null) {
                return;
            }
            try {
                callbackHandler.handle(callbacks);
                String username = nameCallback.getName();
                String password = (String)passwordCallback.getObject();
                AuthScope authscope = new AuthScope(null, -1);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                httpClient.getState().setCredentials(authscope, (Credentials)credentials);
                method.setDoAuthentication(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedCallbackException e) {
                e.printStackTrace();
            }
        }
    }
}

