/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.sharedobject;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import org.eclipse.ecf.internal.core.sharedobject.Messages;

public class SharedObjectMsg
implements Serializable {
    private static final long serialVersionUID = -8761203700888592267L;
    public static final Object[] nullArgs = new Object[0];
    public static final Class[] nullTypes = new Class[0];
    protected String clazz;
    protected String method;
    protected Object[] parameters;

    protected SharedObjectMsg() {
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object[] param) {
        if (methodName == null || param == null) {
            throw new NullPointerException(Messages.SharedObjectMsg_Excepton_Invalid_Shared_Object_Msg);
        }
        return new SharedObjectMsg(className, methodName, param);
    }

    public static SharedObjectMsg createMsg(String methodName, Object[] param) {
        return SharedObjectMsg.createMsg(null, methodName, param);
    }

    public static SharedObjectMsg createMsg(String methodName) {
        return SharedObjectMsg.createMsg(null, methodName, nullArgs);
    }

    public static SharedObjectMsg createMsg(String className, String methodName) {
        return SharedObjectMsg.createMsg(className, methodName, nullArgs);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg) {
        Object[] args = new Object[]{arg};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static SharedObjectMsg createMsg(String methodName, Object arg) {
        return SharedObjectMsg.createMsg(null, methodName, arg);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4, arg5};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static Class getClass(ClassLoader loader, String name) throws ClassNotFoundException {
        if (name == null) {
            return null;
        }
        return Class.forName(name, true, loader);
    }

    public static String getNameForClass(Class clazz) {
        return clazz.getName();
    }

    public static Class[] getTypesForParameters(Object[] args) {
        Class[] argTypes = null;
        if (args == null || args.length == 0) {
            argTypes = nullTypes;
        } else {
            argTypes = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                argTypes[i] = args[i] == null ? null : args[i].getClass();
                ++i;
            }
        }
        return argTypes;
    }

    public static Method findMethod(final Class clazz, String meth, Class[] args) {
        Method[] methods = null;
        try {
            methods = (Method[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return clazz.getDeclaredMethods();
                }
            });
        }
        catch (PrivilegedActionException e) {
            return null;
        }
        return SharedObjectMsg.searchForMethod(methods, meth, args);
    }

    public static Method searchForMethod(Method[] meths, String meth, Class[] args) {
        int i = 0;
        while (i < meths.length) {
            Method test = meths[i];
            if (test.getName().equals(meth) && test.getParameterTypes().length == args.length) {
                return test;
            }
            ++i;
        }
        return null;
    }

    public static Method findMethodRecursive(Class clazz, String meth, Class[] args) {
        Method aMethod = SharedObjectMsg.findMethod(clazz, meth, args);
        if (aMethod == null) {
            Class superclazz = clazz.getSuperclass();
            if (superclazz != null) {
                return SharedObjectMsg.findMethodRecursive(superclazz, meth, args);
            }
            return null;
        }
        return aMethod;
    }

    public static void checkForSerializable(SharedObjectMsg aMsg) throws NotSerializableException {
        Object[] args = aMsg.getParameters();
        int i = 0;
        while (i < args.length) {
            if (args[i] != null && !(args[i] instanceof Serializable)) {
                throw new NotSerializableException(String.valueOf(Messages.SharedObjectMsg_Exception_Param) + i + Messages.SharedObjectMsg_Exception_Not_Serializable);
            }
            ++i;
        }
    }

    protected SharedObjectMsg(String className, String methodName, Object[] parameters) {
        this.clazz = className;
        this.method = methodName;
        this.parameters = parameters;
    }

    public final String getMethod() {
        return this.method;
    }

    public final void setMethod(String name) {
        this.checkAlterMsg();
        if (name == null) {
            throw new NullPointerException(Messages.SharedObjectMsg_Exception_Methodname_Not_Null);
        }
        this.method = name;
    }

    protected void checkAlterMsg() {
    }

    public final String getClassName() {
        return this.clazz;
    }

    public final void setClassName(String name) {
        this.checkAlterMsg();
        this.clazz = name;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public final void setParameters(Object[] args) {
        this.checkAlterMsg();
        args = args == null ? nullArgs : args;
    }

    protected Class[] getParameterTypes() {
        return SharedObjectMsg.getTypesForParameters(this.getParameters());
    }

    protected final Method findMethod(Class clazz1) {
        return SharedObjectMsg.findMethod(clazz1, this.getMethod(), this.getParameterTypes());
    }

    protected final Method findMethodRecursive(Class clazz1) {
        return SharedObjectMsg.findMethodRecursive(clazz1, this.getMethod(), this.getParameterTypes());
    }

    public final Object invoke(Object target) throws Exception {
        return this.doInvoke(target);
    }

    Object doInvoke(Object target) throws Exception {
        if (target == null) {
            throw new NoSuchMethodException(Messages.SharedObjectMsg_Exception_Null_Target);
        }
        Method meth = null;
        meth = this.clazz == null ? this.findMethodRecursive(target.getClass()) : this.findMethod(SharedObjectMsg.getClass(target.getClass().getClassLoader(), this.clazz));
        if (meth == null) {
            throw new NoSuchMethodException(this.getMethod());
        }
        final Method toCall = meth;
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (!toCall.isAccessible()) {
                    ((AccessibleObject)toCall).setAccessible(true);
                }
                return null;
            }
        });
        return toCall.invoke(target, this.getParameters());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SharedObjectMsg[");
        sb.append("class=").append(this.clazz).append(";");
        sb.append("method=").append(this.method).append(";");
        sb.append("params=").append(Arrays.asList(this.parameters)).append("]");
        return sb.toString();
    }
}

