/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.outgoing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.FileTransferInfo;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileTransfer;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IFileTransferRunnable;
import org.eclipse.ecf.filetransfer.IIncomingFileTransferRequestListener;
import org.eclipse.ecf.filetransfer.IOutgoingFileTransfer;
import org.eclipse.ecf.filetransfer.SendFileTransferException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferResponseEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferSendDataEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferSendDoneEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.ISendFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferNamespace;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractOutgoingFileTransfer
implements IOutgoingFileTransfer,
ISendFileTransfer {
    public static final int DEFAULT_BUF_LENGTH = 4096;
    protected Job job;
    protected URL remoteFileURL;
    protected IFileID remoteFileID;
    protected IFileTransferListener listener;
    protected int buff_length = 4096;
    protected boolean done = false;
    protected long bytesSent = 0L;
    protected InputStream localFileContents;
    protected OutputStream remoteFileContents;
    protected Exception exception;
    protected IFileTransferInfo fileTransferInfo;
    protected Map options = null;
    protected IConnectContext connectContext;
    protected Proxy proxy;
    private final IFileTransferRunnable fileTransferRunnable = new IFileTransferRunnable(){

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IStatus performFileTransfer(IProgressMonitor monitor) {
            byte[] buf = new byte[AbstractOutgoingFileTransfer.this.buff_length];
            long totalWork = AbstractOutgoingFileTransfer.this.fileTransferInfo.getFileSize() == -1L ? 100L : AbstractOutgoingFileTransfer.this.fileTransferInfo.getFileSize();
            double factor = totalWork > Integer.MAX_VALUE ? 2.147483647E9 / (double)totalWork : 1.0;
            int work = totalWork > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)totalWork;
            monitor.beginTask(String.valueOf(AbstractOutgoingFileTransfer.this.getRemoteFileURL().toString()) + Messages.AbstractOutgoingFileTransfer_Progress_Data, work);
            try {
                try {
                    while (!AbstractOutgoingFileTransfer.this.isDone()) {
                        if (monitor.isCanceled()) {
                            throw new UserCancelledException(Messages.AbstractOutgoingFileTransfer_Exception_User_Cancelled);
                        }
                        int bytes = AbstractOutgoingFileTransfer.this.localFileContents.read(buf);
                        if (bytes != -1) {
                            AbstractOutgoingFileTransfer.this.bytesSent += (long)bytes;
                            AbstractOutgoingFileTransfer.this.remoteFileContents.write(buf, 0, bytes);
                            AbstractOutgoingFileTransfer.this.fireTransferSendDataEvent();
                            monitor.worked((int)Math.round(factor * (double)bytes));
                            continue;
                        }
                        AbstractOutgoingFileTransfer.this.done = true;
                    }
                }
                catch (Exception e) {
                    AbstractOutgoingFileTransfer.this.exception = e;
                    AbstractOutgoingFileTransfer.this.done = true;
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                AbstractOutgoingFileTransfer.this.hardClose();
                monitor.done();
                try {
                    AbstractOutgoingFileTransfer.this.fireTransferSendDoneEvent();
                    throw throwable;
                }
                catch (Exception e) {
                    Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, Messages.AbstractOutgoingFileTransfer_EXCEPTION_IN_FINALLY, (Throwable)e));
                }
                throw throwable;
            }
            {
                Object var9_10 = null;
                AbstractOutgoingFileTransfer.this.hardClose();
            }
            monitor.done();
            try {}
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, Messages.AbstractOutgoingFileTransfer_EXCEPTION_IN_FINALLY, (Throwable)e));
                return AbstractOutgoingFileTransfer.this.getFinalStatus(AbstractOutgoingFileTransfer.this.exception);
            }
            AbstractOutgoingFileTransfer.this.fireTransferSendDoneEvent();
            return AbstractOutgoingFileTransfer.this.getFinalStatus(AbstractOutgoingFileTransfer.this.exception);
        }
    };
    FileTransferJob fileTransferJob;

    protected URL getRemoteFileURL() {
        return this.remoteFileURL;
    }

    protected void setInputStream(InputStream ins) {
        this.localFileContents = ins;
    }

    protected void setOutputStream(OutputStream outs) {
        this.remoteFileContents = outs;
    }

    protected IFileTransferInfo getFileTransferInfo() {
        return this.fileTransferInfo;
    }

    protected Map getOptions() {
        return this.options;
    }

    protected IStatus getFinalStatus(Throwable exception1) {
        return Status.OK_STATUS;
    }

    protected void hardClose() {
        try {
            if (this.remoteFileContents != null) {
                this.remoteFileContents.close();
            }
        }
        catch (IOException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, "hardClose", (Throwable)e));
        }
        try {
            if (this.localFileContents != null) {
                this.localFileContents.close();
            }
        }
        catch (IOException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, "hardClose", (Throwable)e));
        }
        this.job = null;
        this.remoteFileContents = null;
        this.localFileContents = null;
    }

    public ID getID() {
        return this.remoteFileID;
    }

    protected void fireTransferSendDoneEvent() {
        this.listener.handleTransferEvent((IFileTransferEvent)new IOutgoingFileTransferSendDoneEvent(){
            private static final long serialVersionUID = -2686266564645210722L;

            public IOutgoingFileTransfer getSource() {
                return AbstractOutgoingFileTransfer.this;
            }

            public Exception getException() {
                return AbstractOutgoingFileTransfer.this.getException();
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("IOutgoingFileTransferSendDoneEvent[");
                sb.append("bytesSent=").append(AbstractOutgoingFileTransfer.this.bytesSent).append(";fileLength=").append(AbstractOutgoingFileTransfer.this.fileTransferInfo.getFileSize()).append(";exception=").append(this.getException()).append("]");
                return sb.toString();
            }
        });
    }

    protected void fireTransferSendDataEvent() {
        this.listener.handleTransferEvent((IFileTransferEvent)new IOutgoingFileTransferSendDataEvent(){
            private static final long serialVersionUID = -2916500675859842392L;

            public IOutgoingFileTransfer getSource() {
                return AbstractOutgoingFileTransfer.this;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("IOutgoingFileTransferSendDataEvent[");
                sb.append("bytesSent=").append(AbstractOutgoingFileTransfer.this.bytesSent).append(";fileLength=").append(AbstractOutgoingFileTransfer.this.fileTransferInfo.getFileSize()).append("]");
                return sb.toString();
            }
        });
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void cancel() {
        if (this.job != null) {
            this.job.cancel();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public double getPercentComplete() {
        long fileLength = this.getFileLength();
        if (fileLength == -1L || fileLength == 0L) {
            return fileLength;
        }
        return (double)this.bytesSent / (double)fileLength;
    }

    public long getFileLength() {
        return this.fileTransferInfo.getFileSize();
    }

    public boolean isDone() {
        return this.done;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    protected abstract void openStreams() throws SendFileTransferException;

    public Namespace getOutgoingNamespace() {
        return IDFactory.getDefault().getNamespaceByName(FileTransferNamespace.PROTOCOL);
    }

    public IFileTransferListener getListener() {
        return this.listener;
    }

    protected String createJobName() {
        return this.getRemoteFileURL().toString();
    }

    protected void setupAndScheduleJob() {
        if (this.fileTransferJob == null) {
            this.fileTransferJob = new FileTransferJob(this.createJobName());
        }
        this.fileTransferJob.setFileTransferRunnable(this.fileTransferRunnable);
        this.fileTransferJob.setFileTransfer((IFileTransfer)this);
        this.job = this.fileTransferJob;
        this.job.schedule();
    }

    protected void fireSendStartEvent() {
        this.listener.handleTransferEvent((IFileTransferEvent)new IOutgoingFileTransferResponseEvent(){
            private static final long serialVersionUID = 2171381825030082432L;

            public String toString() {
                StringBuffer sb = new StringBuffer("IOutgoingFileTransferResponseEvent[");
                sb.append("isdone=").append(AbstractOutgoingFileTransfer.this.done).append(";");
                sb.append("bytesSent=").append(AbstractOutgoingFileTransfer.this.bytesSent).append("]");
                return sb.toString();
            }

            public boolean requestAccepted() {
                return true;
            }

            public IOutgoingFileTransfer getSource() {
                return AbstractOutgoingFileTransfer.this;
            }

            public void setFileTransferJob(FileTransferJob ftj) {
                AbstractOutgoingFileTransfer.this.fileTransferJob = ftj;
            }
        });
    }

    protected abstract void setupProxy(Proxy var1);

    protected void setupProxies() {
        if (this.proxy == null) {
            this.proxy = ProxySetupHelper.getProxy(this.getRemoteFileURL().toExternalForm());
        }
        if (this.proxy != null) {
            this.setupProxy(this.proxy);
        }
    }

    protected IProxyData selectProxyFromProxies(String protocol, IProxyData[] proxies) {
        block7: {
            block6: {
                if (proxies == null || proxies.length == 0) {
                    return null;
                }
                if (proxies.length == 1) {
                    return proxies[0];
                }
                if (!protocol.equalsIgnoreCase("http")) break block6;
                int i = 0;
                while (i < proxies.length) {
                    if (proxies[i].getType().equals("HTTP")) {
                        return proxies[i];
                    }
                    ++i;
                }
                break block7;
            }
            if (!protocol.equalsIgnoreCase("https")) break block7;
            int i = 0;
            while (i < proxies.length) {
                if (proxies[i].getType().equals("HTTPS")) {
                    return proxies[i];
                }
                ++i;
            }
        }
        return proxies[0];
    }

    public void sendOutgoingRequest(IFileID targetReceiver, IFileTransferInfo localFileToSend, IFileTransferListener transferListener, Map ops) throws SendFileTransferException {
        Assert.isNotNull((Object)targetReceiver, (String)Messages.AbstractOutgoingFileTransfer_RemoteFileID_Not_Null);
        Assert.isNotNull((Object)transferListener, (String)Messages.AbstractOutgoingFileTransfer_TransferListener_Not_Null);
        Assert.isNotNull((Object)localFileToSend, (String)Messages.AbstractOutgoingFileTransfer_EXCEPTION_FILE_TRANSFER_INFO_NOT_NULL);
        this.done = false;
        this.bytesSent = 0L;
        this.exception = null;
        this.fileTransferInfo = localFileToSend;
        this.remoteFileID = targetReceiver;
        this.options = ops;
        try {
            this.remoteFileURL = targetReceiver.getURL();
        }
        catch (MalformedURLException e) {
            throw new SendFileTransferException(NLS.bind((String)Messages.AbstractOutgoingFileTransfer_MalformedURLException, (Object)targetReceiver), (Throwable)e);
        }
        this.listener = transferListener;
        this.setupProxies();
        this.openStreams();
        this.fireSendStartEvent();
        this.setupAndScheduleJob();
    }

    public void sendOutgoingRequest(IFileID targetReceiver, File localFileToSend, IFileTransferListener transferListener, Map ops) throws SendFileTransferException {
        this.sendOutgoingRequest(targetReceiver, (IFileTransferInfo)new FileTransferInfo(localFileToSend, null, null), transferListener, ops);
    }

    public void addListener(IIncomingFileTransferRequestListener l) {
    }

    public boolean removeListener(IIncomingFileTransferRequestListener l) {
        return false;
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.connectContext = connectContext;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

