/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.internal.core.identity.Activator;
import org.eclipse.osgi.service.debug.DebugOptions;

public class Trace {
    protected static final String PARENTHESIS_OPEN = "(";
    protected static final String PARENTHESIS_CLOSE = ")";
    protected static final String TRACE_STR = "TRACE";
    protected static final String PREFIX_TRACING = "TRACING ";
    protected static final String PREFIX_CHANGING = "CHANGING ";
    protected static final String PREFIX_CATCHING = "CAUGHT ";
    protected static final String PREFIX_THROWING = "THROWN ";
    protected static final String PREFIX_ENTERING = "ENTERING ";
    protected static final String PREFIX_EXITING = "EXITING ";
    protected static final String SEPARATOR_METHOD = "#";
    protected static final String SEPARATOR_PARAMETER = ", ";
    protected static final String SEPARATOR_RETURN = ":";
    protected static final String SEPARATOR_SPACE = " ";
    protected static final String LABEL_OLD_VALUE = "old=";
    protected static final String LABEL_NEW_VALUE = "new=";
    private static final Map cachedOptions = new HashMap();

    private Trace() {
    }

    protected static boolean shouldTrace(String pluginId) {
        return Trace.shouldTrace0(String.valueOf(pluginId) + "/debug");
    }

    protected static boolean shouldTrace0(String option) {
        if (option == null) {
            return false;
        }
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return false;
        }
        DebugOptions debugOptions = activator.getDebugOptions();
        if (debugOptions == null) {
            return false;
        }
        String result = debugOptions.getOption(option);
        return result == null ? false : result.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldTrace(String pluginId, String option) {
        if (pluginId == null) {
            return false;
        }
        if (Trace.shouldTrace(pluginId)) {
            Boolean value = null;
            Map map = cachedOptions;
            synchronized (map) {
                value = (Boolean)cachedOptions.get(option);
                if (value == null) {
                    value = Trace.shouldTrace0(option) ? Boolean.TRUE : Boolean.FALSE;
                    cachedOptions.put(option, value);
                }
            }
            return value;
        }
        return false;
    }

    public static String getArgumentString(Object argument) {
        if (argument == null) {
            return "null";
        }
        if (argument instanceof byte[]) {
            return Trace.getStringFromByteArray((byte[])argument);
        }
        if (argument.getClass().isArray()) {
            return Trace.getArgumentsString((Object[])argument);
        }
        return String.valueOf(argument);
    }

    private static String getStringFromByteArray(byte[] bytes) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < bytes.length) {
            buf.append(bytes[i]);
            if (i == bytes.length - 1) {
                buf.append("]");
            } else {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getArgumentsString(Object[] arguments) {
        if (arguments == null) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer("[");
        int i = 0;
        while (i < arguments.length) {
            buffer.append(Trace.getArgumentString(arguments[i]));
            if (i < arguments.length - 1) {
                buffer.append(SEPARATOR_PARAMETER);
            }
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected static void trace(String message) {
        StringBuffer buf = new StringBuffer(PARENTHESIS_OPEN);
        buf.append(TRACE_STR).append(PARENTHESIS_CLOSE).append(Trace.getTimeString()).append(message).append(SEPARATOR_SPACE);
        System.out.println(buf.toString());
    }

    protected static String getTimeString() {
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("[MM/dd/yy;HH:mm:ss:SSS]");
        return df.format(d);
    }

    public static void trace(String pluginId, String message) {
        if (Trace.shouldTrace(pluginId)) {
            Trace.trace(message);
        }
    }

    public static void trace(String pluginId, String option, String message) {
        if (Trace.shouldTrace(pluginId, option)) {
            Trace.trace(message);
        }
    }

    public static void trace(String pluginId, String option, Class clazz, String methodName, String message) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_TRACING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            buf.append(PARENTHESIS_OPEN).append(message).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void changing(String pluginId, String option, String valueDescription, Object oldValue, Object newValue) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_CHANGING);
            buf.append(valueDescription).append(SEPARATOR_SPACE).append(LABEL_OLD_VALUE).append(Trace.getArgumentString(oldValue));
            buf.append(SEPARATOR_PARAMETER).append(LABEL_NEW_VALUE).append(Trace.getArgumentString(newValue));
            Trace.trace(buf.toString());
        }
    }

    public static void changing(String pluginId, String option, Class clazz, String methodName, String valueDescription, Object oldValue, Object newValue) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_CHANGING);
            buf.append(valueDescription).append(SEPARATOR_SPACE).append(LABEL_OLD_VALUE).append(Trace.getArgumentString(oldValue));
            buf.append(SEPARATOR_PARAMETER).append(LABEL_NEW_VALUE).append(Trace.getArgumentString(newValue));
            buf.append(SEPARATOR_SPACE).append(PARENTHESIS_OPEN).append(clazz.getName()).append(SEPARATOR_METHOD);
            buf.append(methodName).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void catching(String pluginId, String option, Class clazz, String methodName, Throwable throwable) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_CATCHING);
            buf.append(throwable.getMessage()).append(SEPARATOR_SPACE);
            buf.append(PARENTHESIS_OPEN).append(clazz.getName()).append(SEPARATOR_METHOD);
            buf.append(methodName).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
            throwable.printStackTrace(System.err);
        }
    }

    public static void throwing(String pluginId, String option, Class clazz, String methodName, Throwable throwable) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_THROWING);
            buf.append(throwable.getMessage()).append(SEPARATOR_SPACE);
            buf.append(PARENTHESIS_OPEN).append(clazz.getName()).append(SEPARATOR_METHOD);
            buf.append(methodName).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
            throwable.printStackTrace(System.err);
        }
    }

    public static void entering(String pluginId, String option, Class clazz, String methodName) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_ENTERING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName).append(PARENTHESIS_OPEN).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void entering(String pluginId, String option, Class clazz, String methodName, Object parameter) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_ENTERING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            buf.append(PARENTHESIS_OPEN).append(Trace.getArgumentString(parameter)).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void entering(String pluginId, String option, Class clazz, String methodName, Object[] parameters) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_ENTERING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            buf.append(PARENTHESIS_OPEN).append(Trace.getArgumentString(parameters)).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }

    public static void exiting(String pluginId, String option, Class clazz, String methodName) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_EXITING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            Trace.trace(buf.toString());
        }
    }

    public static void exiting(String pluginId, String option, Class clazz, String methodName, Object returnValue) {
        if (Trace.shouldTrace(pluginId, option)) {
            StringBuffer buf = new StringBuffer(PREFIX_EXITING).append(clazz.getName());
            buf.append(SEPARATOR_METHOD).append(methodName);
            buf.append(PARENTHESIS_OPEN).append(Trace.getArgumentString(returnValue)).append(PARENTHESIS_CLOSE);
            Trace.trace(buf.toString());
        }
    }
}

