/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bittorrent.internal.net;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import org.eclipse.bittorrent.TorrentConfiguration;
import org.eclipse.bittorrent.TorrentFile;
import org.eclipse.bittorrent.internal.encode.Decode;
import org.eclipse.bittorrent.internal.encode.Encode;
import org.eclipse.bittorrent.internal.net.ConnectionInfo;
import org.eclipse.bittorrent.internal.net.ConnectionPool;
import org.eclipse.bittorrent.internal.net.TorrentManager;
import org.eclipse.bittorrent.internal.torrent.Piece;

class PeerConnection
extends Thread {
    private static final byte[] KEEP_ALIVE = new byte[4];
    private static final byte[] CHOKE;
    private static final byte[] UNCHOKE;
    private static final byte[] INTERESTED;
    private static final byte[] NOT_INTERESTED;
    private static final String PROTOCOL_STRING;
    private static final int BUFFER_MAXIMUM = 1024;
    private final ByteBuffer buffer = ByteBuffer.allocate(1024);
    private final ByteBuffer sendBuffer = ByteBuffer.allocate(1024);
    private final ConnectionPool pool;
    private final TorrentManager manager;
    private final long[] downloads = new long[20];
    private final long[] uploads = new long[20];
    private final byte[] handshake;
    private final byte[] have;
    private final byte[] request;
    private final byte[] blockInfo;
    private final byte[] cancel;
    private final boolean[] haveMessages;
    private SocketChannel channel;
    private InetSocketAddress address;
    private boolean[] peerPieces;
    private String clientName;
    private String ip;
    private long downloaded;
    private long uploaded;
    private long lastDownloaded;
    private long lastUploaded;
    private int port;
    private int queuePosition;
    private boolean isChoking;
    private boolean isInterested;
    private boolean peerIsChoking;
    private boolean peerIsInterested;
    private boolean peerIsSeed;
    private boolean initialized;
    private boolean sendChoke;
    private boolean sendUnchoke;

    static {
        byte[] byArray = new byte[5];
        byArray[3] = 1;
        CHOKE = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[3] = 1;
        byArray2[4] = 1;
        UNCHOKE = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[3] = 1;
        byArray3[4] = 2;
        INTERESTED = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[3] = 1;
        byArray4[4] = 3;
        NOT_INTERESTED = byArray4;
        byte[] byArray5 = new byte[28];
        byArray5[0] = 19;
        byArray5[1] = 66;
        byArray5[2] = 105;
        byArray5[3] = 116;
        byArray5[4] = 84;
        byArray5[5] = 111;
        byArray5[6] = 114;
        byArray5[7] = 114;
        byArray5[8] = 101;
        byArray5[9] = 110;
        byArray5[10] = 116;
        byArray5[11] = 32;
        byArray5[12] = 112;
        byArray5[13] = 114;
        byArray5[14] = 111;
        byArray5[15] = 116;
        byArray5[16] = 111;
        byArray5[17] = 99;
        byArray5[18] = 111;
        byArray5[19] = 108;
        PROTOCOL_STRING = new String(byArray5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerConnection(ConnectionPool pool, TorrentManager manager) throws UnsupportedEncodingException {
        StringBuffer buffer;
        byte[] byArray = new byte[9];
        byArray[3] = 5;
        byArray[4] = 4;
        this.have = byArray;
        byte[] byArray2 = new byte[17];
        byArray2[3] = 13;
        byArray2[4] = 6;
        byArray2[15] = 32;
        this.request = byArray2;
        byte[] byArray3 = new byte[13];
        byArray3[3] = 9;
        byArray3[4] = 7;
        this.blockInfo = byArray3;
        byte[] byArray4 = new byte[9];
        byArray4[3] = 13;
        byArray4[4] = 8;
        this.cancel = byArray4;
        this.downloaded = 0L;
        this.uploaded = 0L;
        this.lastDownloaded = 0L;
        this.lastUploaded = 0L;
        this.queuePosition = 0;
        this.isChoking = true;
        this.isInterested = false;
        this.peerIsChoking = true;
        this.peerIsInterested = false;
        this.peerIsSeed = false;
        this.initialized = true;
        this.sendChoke = false;
        this.sendUnchoke = false;
        this.pool = pool;
        this.manager = manager;
        TorrentFile torrent = manager.getTorrentFile();
        StringBuffer stringBuffer = buffer = new StringBuffer(PROTOCOL_STRING);
        synchronized (stringBuffer) {
            buffer.append(torrent.getInfoHash());
            buffer.append(manager.getPeerID());
        }
        this.handshake = buffer.toString().getBytes("ISO-8859-1");
        this.peerPieces = new boolean[torrent.getNumPieces()];
        this.haveMessages = new boolean[this.peerPieces.length];
        Arrays.fill(this.peerPieces, false);
        Arrays.fill(this.haveMessages, false);
    }

    void setAddress(String ip, int port) {
        this.address = new InetSocketAddress(ip, port);
        this.ip = ip;
        this.port = port;
    }

    void setChannel(SocketChannel channel) {
        this.channel = channel;
        Socket socket = channel.socket();
        this.ip = socket.getLocalAddress().getHostAddress();
        this.port = socket.getLocalPort();
    }

    private void connect() {
        try {
            if (this.channel == null) {
                this.call();
            } else {
                this.answer();
            }
        }
        catch (IOException e) {
            String message = e.getMessage();
            TorrentConfiguration.debug("The connection with " + this.ip + ":" + this.port + " has been closed" + (message == null ? "." : ": " + message));
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
        this.close();
    }

    /*
     * Unable to fully structure code
     */
    private void call() throws IOException {
        try {
            this.channel = SocketChannel.open(this.address);
            this.address = null;
        }
        catch (SocketException e) {
            TorrentConfiguration.debug("Unable to connect to " + this.ip + ":" + this.port + " - " + e.getMessage());
            return;
        }
        TorrentConfiguration.debug("Established outgoing connection with " + this.ip + ":" + this.port);
        this.sendHandshake();
        read = 0;
        ret = 0;
        while (read < 68) {
            if (this.channel == null) {
                return;
            }
            ret = this.channel.read(this.buffer);
            if (ret == -1) {
                TorrentConfiguration.debug("End of stream has been reached with " + this.ip + ":" + this.port);
                return;
            }
            read += ret;
        }
        TorrentConfiguration.debug("Received [BT_HANDSHAKE] message from " + this.ip + ":" + this.port);
        client = new byte[20];
        System.arraycopy(this.buffer.array(), 48, client, 0, 20);
        this.processClientName(new String(client));
        if (read == 68) ** GOTO lbl79
        while (read < 72) {
            if (this.channel == null) {
                return;
            }
            ret = this.channel.read(this.buffer);
            if (ret == -1) {
                TorrentConfiguration.debug("End of stream has been reached with " + this.ip + ":" + this.port);
                return;
            }
            read += ret;
        }
        if (this.buffer.get(71) != 0) {
            while (read < 73) {
                if (this.channel == null) {
                    return;
                }
                ret = this.channel.read(this.buffer);
                if (ret == -1) {
                    TorrentConfiguration.debug("End of stream has been reached with " + this.ip + ":" + this.port);
                    return;
                }
                read += ret;
            }
            if (this.buffer.get(72) == 5) {
                length = 72 + this.buffer.get(71);
                while (read < length) {
                    if (this.channel == null) {
                        return;
                    }
                    ret = this.channel.read(this.buffer);
                    if (ret == -1) {
                        TorrentConfiguration.debug("End of stream has been reached with " + this.ip + ":" + this.port);
                        return;
                    }
                    read += ret;
                }
                this.buffer.flip();
                array = new byte[read];
                this.buffer.get(array, 0, read);
                this.processBitfield(array, 73, 72 + array[71]);
                if (read == length) {
                    this.sendBitfield();
                }
            } else if (this.buffer.get(71) == 1) {
                bytes = null;
                this.buffer.get(bytes, 0, read);
                array = new byte[5];
                System.arraycopy(bytes, 68, array, 0, 5);
                if (!this.processMessage(array)) {
                    return;
                }
            }
        } else if (this.buffer.get(78) == 0 && this.buffer.get(79) == 0 && this.buffer.get(80) == 0) {
            TorrentConfiguration.debug("Received [BT_KEEPALIVE] message from " + this.ip + ":" + this.port);
        } else {
            TorrentConfiguration.debug("Received an unidentifiable message from " + this.ip + ":" + this.port);
            return;
lbl79:
            // 1 sources

            this.sendBitfield();
        }
        this.buffer.clear();
        this.query();
    }

    private void answer() throws IOException {
        TorrentConfiguration.debug("Established incoming connection from " + this.ip + ":" + this.port);
        this.sendHandshake();
        this.sendBitfield();
        this.query();
    }

    private void query() throws IOException {
        TorrentConfiguration.debug("Entering the main loop with " + this.ip + ":" + this.port);
        byte[] array = null;
        int read = 0;
        int ret = 0;
        while (this.channel != null && this.channel.isConnected()) {
            byte[] bytes;
            int request;
            this.buffer.clear();
            this.sendQueuedMessages();
            if (read != 0) {
                byte[] bufferArray = this.buffer.array();
                byte[] bytes2 = new byte[bufferArray.length];
                System.arraycopy(bufferArray, read, bytes2, 0, bufferArray.length - read);
                this.buffer.put(bytes2);
                this.buffer.position(read);
            }
            int length = (request = this.sendRequest(this.manager.request(this.peerPieces))) == -1 ? 4 : request;
            this.resetBuffer();
            while (read < 4) {
                if (this.channel == null) {
                    return;
                }
                ret = this.channel.read(this.buffer);
                if (ret == -1) {
                    TorrentConfiguration.debug("End of stream has been reached with " + this.ip + ":" + this.port);
                    return;
                }
                this.manager.updateDownloadRequestSpeed(ret);
                this.limitBuffer(this.manager.getDownloadRequestSpeed());
                read += ret;
            }
            this.buffer.limit(1024);
            this.buffer.rewind();
            if (array == null) {
                array = new byte[read];
                this.buffer.get(array, 0, read);
            } else {
                bytes = new byte[array.length + read];
                System.arraycopy(array, 0, bytes, 0, array.length);
                this.buffer.get(bytes, array.length, read);
                array = bytes;
            }
            if (array[0] == 0 && array[1] == 0 && array[2] == 0 && array[3] == 0) {
                TorrentConfiguration.debug("Received [BT_KEEPALIVE] from " + this.ip + ":" + this.port);
                array = this.truncate(array, 4);
                read -= 4;
            }
            while (array != null && array.length > 4) {
                if (array[4] >= 0 && array[4] <= 3) {
                    if (!this.processMessage(array)) {
                        return;
                    }
                    array = this.truncate(array, 5);
                    read -= 5;
                    continue;
                }
                if (array[3] == 5 && array[4] == 4) {
                    if (array.length < 9) {
                        this.buffer.clear();
                        while (read < 9) {
                            if (this.channel == null) {
                                return;
                            }
                            ret = this.channel.read(this.buffer);
                            if (ret == -1) {
                                TorrentConfiguration.debug("End of stream has been reached with " + this.ip + ":" + this.port);
                                return;
                            }
                            read += ret;
                        }
                        bytes = new byte[read];
                        System.arraycopy(array, 0, bytes, 0, array.length);
                        this.buffer.flip();
                        this.buffer.get(bytes, array.length, read - array.length);
                        array = bytes;
                    }
                    this.processHaveMessage(array);
                    array = this.truncate(array, 9);
                    read -= 9;
                    continue;
                }
                if (array[4] == 5) {
                    length = 4 + array[3];
                    while (read < length) {
                        if (this.channel == null) {
                            return;
                        }
                        ret = this.channel.read(this.buffer);
                        if (ret == -1) {
                            TorrentConfiguration.debug("End of stream has been reached with " + this.ip + ":" + this.port);
                            return;
                        }
                        read += ret;
                    }
                    if (array.length < read) {
                        bytes = new byte[read];
                        System.arraycopy(array, 0, bytes, 0, array.length);
                        this.buffer.flip();
                        this.buffer.get(bytes, array.length, read - array.length);
                        array = bytes;
                    }
                    this.processBitfield(array, 5, length);
                    array = this.truncate(array, length);
                    read -= length;
                    continue;
                }
                if (array[3] == 13 && array[4] == 6) {
                    if (array.length < 17) {
                        this.buffer.clear();
                        while (read < 17) {
                            if (this.channel == null) {
                                return;
                            }
                            ret = this.channel.read(this.buffer);
                            if (ret == -1) {
                                TorrentConfiguration.debug("End of stream has been reached with " + this.ip + ":" + this.port);
                                return;
                            }
                            read += ret;
                        }
                        bytes = new byte[read];
                        System.arraycopy(array, 0, bytes, 0, array.length);
                        this.buffer.flip();
                        this.buffer.get(bytes, array.length, read - array.length);
                        array = bytes;
                    }
                    if (!this.processRequest(array)) {
                        this.close();
                        return;
                    }
                    array = this.truncate(array, 17);
                    read -= 17;
                    continue;
                }
                if (array[4] == 7) {
                    byte[] bytes3;
                    byte[] bufferArray = this.buffer.array();
                    int offset = array.length;
                    length = Decode.decodeFourByteNumber(array, 0) + 4;
                    if (offset < length) {
                        byte[] bytes4 = new byte[length];
                        System.arraycopy(array, 0, bytes4, 0, offset);
                        array = bytes4;
                    }
                    this.resetBuffer();
                    this.buffer.clear();
                    int start = read;
                    while (read < length) {
                        if (this.channel == null) {
                            return;
                        }
                        ret = this.channel.read(this.buffer);
                        if (ret == -1) {
                            TorrentConfiguration.debug("End of stream has been reached with " + this.ip + ":" + this.port);
                            return;
                        }
                        if (offset + ret > array.length) {
                            bytes3 = new byte[offset + ret];
                            System.arraycopy(array, 0, bytes3, 0, array.length);
                            array = bytes3;
                        }
                        System.arraycopy(bufferArray, 0, array, offset, ret);
                        this.manager.updateDownloadRequestSpeed(ret);
                        this.buffer.rewind();
                        this.limitBuffer(this.manager.getDownloadRequestSpeed());
                        offset += ret;
                        read += ret;
                    }
                    this.buffer.limit(1024);
                    if (array.length < read) {
                        bytes3 = new byte[read];
                        System.arraycopy(array, 0, bytes3, 0, array.length);
                        this.buffer.position(start);
                        this.buffer.get(bytes3, array.length, read - array.length);
                        array = bytes3;
                    }
                    this.processPiece(array);
                    array = this.truncate(array, length);
                    read -= length;
                    continue;
                }
                if (array[4] == 8) {
                    array = this.truncate(array, 17);
                    read -= 17;
                    continue;
                }
                if (array[4] == 9) {
                    array = this.truncate(array, 9);
                    read -= 9;
                    continue;
                }
                TorrentConfiguration.debug("An ID of " + array[4] + " has been encountered. Closing connection with " + this.ip + ":" + this.port);
                return;
            }
        }
    }

    private byte[] truncate(byte[] array, int length) {
        if (array.length == length) {
            return null;
        }
        byte[] bytes = new byte[array.length - length];
        System.arraycopy(array, length, bytes, 0, bytes.length);
        return bytes;
    }

    private void resetBuffer() {
        long maximum = this.manager.getDownloadRequestSpeed();
        if (maximum == -1L) {
            return;
        }
        this.buffer.limit(0);
        this.limitBuffer(maximum);
    }

    private void limitBuffer(long maximum) {
        if (maximum != 0L) {
            int currentLimit = this.buffer.limit();
            if (maximum + (long)currentLimit > 1024L) {
                this.buffer.limit(1024);
            } else {
                this.buffer.limit(currentLimit + (int)maximum);
            }
        } else {
            try {
                this.buffer.limit(0);
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void processClientName(String peerID) {
        switch (peerID.charAt(0)) {
            case '-': {
                String client = peerID.substring(1, 3);
                String version = String.valueOf(peerID.charAt(3)) + "." + peerID.charAt(4) + "." + peerID.charAt(5) + "." + peerID.charAt(6);
                if (client.equals("AR")) {
                    this.clientName = "Arctic " + version;
                    break;
                }
                if (client.equals("AX")) {
                    this.clientName = "BitPump " + version;
                    break;
                }
                if (client.equals("AZ")) {
                    this.clientName = "Azureus " + version;
                    break;
                }
                if (client.equals("BB")) {
                    this.clientName = "BitBuddy " + version;
                    break;
                }
                if (client.equals("BC")) {
                    this.clientName = "BitComet " + version;
                    break;
                }
                if (client.equals("BS")) {
                    this.clientName = "BTSlave " + version;
                    break;
                }
                if (client.equals("BX")) {
                    this.clientName = "Bittorrent X " + version;
                    break;
                }
                if (client.equals("CD")) {
                    this.clientName = "Enhanced CTorrent " + version;
                    break;
                }
                if (client.equals("CT")) {
                    this.clientName = "CTorrent " + version;
                    break;
                }
                if (client.equals("LP")) {
                    this.clientName = "Lphant " + version;
                    break;
                }
                if (client.equals("LT")) {
                    this.clientName = "libtorrent " + version;
                    break;
                }
                if (client.equals("lt")) {
                    this.clientName = "libTorrent " + version;
                    break;
                }
                if (client.equals("MP")) {
                    this.clientName = "MooPolice " + version;
                    break;
                }
                if (client.equals("MT")) {
                    this.clientName = "MoonlightTorrent " + version;
                    break;
                }
                if (client.equals("QT")) {
                    this.clientName = "QT 4 Torrent example " + version;
                    break;
                }
                if (client.equals("RT")) {
                    this.clientName = "Retriever " + version;
                    break;
                }
                if (client.equals("SB")) {
                    this.clientName = "Swiftbit " + version;
                    break;
                }
                if (client.equals("SS")) {
                    this.clientName = "SwarmScope " + version;
                    break;
                }
                if (client.equals("SZ")) {
                    this.clientName = "Shareaza " + version;
                    break;
                }
                if (client.equals("TN")) {
                    this.clientName = "TorrentDotNet " + version;
                    break;
                }
                if (client.equals("TR")) {
                    this.clientName = "Transmission " + version;
                    break;
                }
                if (client.equals("TS")) {
                    this.clientName = "TorrentStorm " + version;
                    break;
                }
                if (client.equals("UT")) {
                    this.clientName = "\u00b5Torrent " + version;
                    break;
                }
                if (client.equals("XT")) {
                    this.clientName = "XanTorrent " + version;
                    break;
                }
                if (client.equals("ZT")) {
                    this.clientName = "ZipTorrent " + version;
                    break;
                }
                this.clientName = "Unknown";
                break;
            }
            case 'A': {
                this.clientName = "ABC " + peerID.charAt(1) + "." + peerID.charAt(2) + "." + peerID.charAt(3);
                break;
            }
            case 'M': {
                this.clientName = "Mainline " + peerID.charAt(1) + "." + peerID.charAt(3) + "." + peerID.charAt(5);
                break;
            }
            case 'O': {
                this.clientName = "Osprey Permaseed " + peerID.charAt(1) + "." + peerID.charAt(2) + "." + peerID.charAt(3);
                break;
            }
            case 'R': {
                this.clientName = "Tribler " + peerID.charAt(1) + "." + peerID.charAt(2) + "." + peerID.charAt(3);
                break;
            }
            case 'S': {
                this.clientName = "Shadow's client " + peerID.charAt(1) + "." + peerID.charAt(2) + "." + peerID.charAt(3);
                break;
            }
            case 'T': {
                this.clientName = "BitTornado " + peerID.charAt(1) + "." + peerID.charAt(2) + "." + peerID.charAt(3);
                break;
            }
            case 'U': {
                this.clientName = "UPnP NAT Bit Torrent " + peerID.charAt(1) + "." + peerID.charAt(2) + "." + peerID.charAt(3);
                break;
            }
            default: {
                this.clientName = "Unknown";
            }
        }
    }

    private boolean processMessage(byte[] array) throws IOException {
        switch (array[4]) {
            case 0: {
                TorrentConfiguration.debug("Received [BT_CHOKE] message from " + this.ip + ":" + this.port);
                this.peerIsChoking = true;
                break;
            }
            case 1: {
                TorrentConfiguration.debug("Received [BT_UNCHOKE] message from " + this.ip + ":" + this.port);
                this.peerIsChoking = false;
                break;
            }
            case 2: {
                TorrentConfiguration.debug("Received [BT_INTERESTED] message from " + this.ip + ":" + this.port);
                if (this.peerIsInterested) break;
                this.peerIsInterested = true;
                if (!this.pool.checkUnchoke()) break;
                this.sendUnchoke();
                break;
            }
            case 3: {
                TorrentConfiguration.debug("Received [BT_NOT_INTERESTED] message from " + this.ip + ":" + this.port);
                if (!this.peerIsInterested) break;
                this.peerIsInterested = false;
                if (!this.isChoking) {
                    this.pool.unchokedPeerCleared();
                }
                this.sendChoke();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void processBitfield(byte[] array, int offset, int end) {
        boolean[] hasPiece = new boolean[(end - offset) * 8];
        int count = 0;
        int i = offset;
        while (i < end) {
            int bit = Decode.decodeSignedByte(array[i]);
            hasPiece[count++] = (bit & 1) != 0;
            hasPiece[count++] = (bit & 2) != 0;
            hasPiece[count++] = (bit & 4) != 0;
            hasPiece[count++] = (bit & 8) != 0;
            hasPiece[count++] = (bit & 0x10) != 0;
            hasPiece[count++] = (bit & 0x20) != 0;
            hasPiece[count++] = (bit & 0x40) != 0;
            hasPiece[count++] = (bit & 0x80) != 0;
            ++i;
        }
        System.arraycopy(hasPiece, 0, this.peerPieces, 0, this.peerPieces.length);
        TorrentConfiguration.debug("Received [BT_BITFIELD] message from " + this.ip + ":" + this.port);
        this.manager.addPieceAvailability(this.peerPieces);
        i = 0;
        while (i < this.peerPieces.length) {
            if (!this.peerPieces[i]) {
                return;
            }
            ++i;
        }
        this.peerIsSeed = true;
    }

    private void processHaveMessage(byte[] array) {
        int piece = Decode.decodeFourByteNumber(array, 5);
        if (!this.peerPieces[piece]) {
            this.peerPieces[piece] = true;
            this.manager.updatePieceAvailability(piece);
        }
        TorrentConfiguration.debug("Received [BT_HAVE piece #" + piece + "] message from " + this.ip + ":" + this.port);
        int i = 0;
        while (i < this.peerPieces.length) {
            if (!this.peerPieces[i]) {
                return;
            }
            ++i;
        }
        this.peerIsSeed = true;
    }

    private void processCancel(byte[] array) {
    }

    private void processPiece(byte[] array) throws IOException {
        int piece = Decode.decodeFourByteNumber(array, 5);
        int index = Decode.decodeFourByteNumber(array, 9);
        int length = Decode.decodeFourByteNumber(array, 0) - 9;
        this.manager.write(piece, index, array, 13, length);
        this.downloaded += (long)length;
        TorrentConfiguration.debug("Received [BT_PIECE data for #" + piece + ": " + index + "->" + (length + index - 1) + "] message from " + this.ip + ":" + this.port);
    }

    private boolean processRequest(byte[] array) throws IOException {
        int piece = Decode.decodeFourByteNumber(array, 5);
        int index = Decode.decodeFourByteNumber(array, 9);
        int length = Decode.decodeFourByteNumber(array, 13);
        if (this.isChoking) {
            TorrentConfiguration.debug("Ignoring [BT_REQUEST piece #" + piece + ": " + index + "->" + (index + length - 1) + "] message from " + this.ip + ":" + this.port + " as this peer is currently choked");
            return true;
        }
        TorrentConfiguration.debug("Received [BT_REQUEST piece #" + piece + ": " + index + "->" + (index + length - 1) + "] message from " + this.ip + ":" + this.port);
        if (length > 131072) {
            TorrentConfiguration.debug("The requesting of " + length + " bytes violates the standard maximum amount of " + "131072, the connection to " + this.ip + ":" + this.port + " will be closed.");
            return false;
        }
        byte[] block = this.manager.getPieceData(piece, index, length);
        if (block == null) {
            return false;
        }
        Encode.putIntegerAsFourBytes(this.blockInfo, length + 9, 0);
        Encode.putIntegerAsFourBytes(this.blockInfo, piece, 5);
        Encode.putIntegerAsFourBytes(this.blockInfo, index, 9);
        this.sendBuffer.put(this.blockInfo);
        int blockLength = block.length;
        int offset = 0;
        int remaining = this.sendBuffer.remaining();
        long write = this.manager.getUploadRequestSpeed();
        if (write != 0L) {
            write = write == -1L ? (long)blockLength : (write < (long)blockLength ? write : (long)blockLength);
            write = (long)remaining < write ? (long)remaining : write;
        }
        while (offset < blockLength) {
            if (write == 0L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.sendBuffer.put(block, offset, (int)write);
                this.sendBuffer.flip();
                this.channel.write(this.sendBuffer);
                this.sendBuffer.clear();
                offset = (int)((long)offset + write);
                this.manager.updateUploadRequestSpeed((int)write);
                this.uploaded += write;
                this.manager.addToUploaded(write);
            }
            write = this.manager.getUploadRequestSpeed();
            if (write == 0L) continue;
            remaining = blockLength - offset;
            write = write == -1L ? (long)remaining : (write < (long)remaining ? write : (long)remaining);
            remaining = this.sendBuffer.remaining();
            long l = write = (long)remaining < write ? (long)remaining : write;
        }
        TorrentConfiguration.debug("Sent [BT_PIECE data for #" + piece + ": " + index + "->" + (length + index - 1) + "] message to " + this.ip + ":" + this.port);
        return true;
    }

    private void sendHandshake() throws IOException {
        this.sendBuffer.put(this.handshake);
        this.sendBuffer.flip();
        this.channel.write(this.sendBuffer);
        this.sendBuffer.clear();
        TorrentConfiguration.debug("Sent [BT_HANDSHAKE] message to " + this.ip + ":" + this.port);
    }

    private void sendBitfield() throws IOException {
        byte[] bitfield = this.manager.getBitfield();
        boolean hasPiece = false;
        int i = 0;
        while (i < bitfield.length) {
            if (bitfield[i] != 0) {
                hasPiece = true;
                break;
            }
            ++i;
        }
        if (!hasPiece) {
            return;
        }
        byte[] byArray = new byte[5];
        byArray[4] = 5;
        byte[] header = byArray;
        Encode.putIntegerAsFourBytes(header, bitfield.length + 1, 0);
        this.sendBuffer.put(header);
        this.sendBuffer.put(this.manager.getBitfield());
        this.sendBuffer.flip();
        this.channel.write(this.sendBuffer);
        this.sendBuffer.clear();
        TorrentConfiguration.debug("Sent [BT_BITFIELD] message to " + this.ip + ":" + this.port);
    }

    private int sendRequest(Piece piece) throws IOException {
        if (piece == null) {
            this.sendNotInterested();
            return -1;
        }
        if (this.peerIsChoking) {
            this.sendInterested();
            return -1;
        }
        int[] information = piece.getRequestInformation();
        while (information == null) {
            piece = this.manager.request(this.peerPieces);
            if (piece == null) {
                this.sendNotInterested();
                return -1;
            }
            information = piece.getRequestInformation();
        }
        Encode.placeRequestInformation(this.request, information);
        this.sendBuffer.put(this.request);
        this.sendBuffer.flip();
        this.channel.write(this.sendBuffer);
        this.sendBuffer.clear();
        TorrentConfiguration.debug("Sent [BT_REQUEST piece #" + information[0] + ": " + information[1] + "->" + (information[1] + information[2] - 1) + "] message to " + this.ip + ":" + this.port);
        return information[2] + 13;
    }

    private synchronized void sendQueuedMessages() throws IOException {
        int i = 0;
        while (i < this.haveMessages.length) {
            if (this.haveMessages[i]) {
                Encode.putIntegerAsFourBytes(this.have, i, 5);
                this.sendBuffer.put(this.have);
                this.sendBuffer.flip();
                this.channel.write(this.sendBuffer);
                this.sendBuffer.clear();
                TorrentConfiguration.debug("Sent [BT_HAVE PIECE #" + i + "] message to " + this.ip + ":" + this.port);
                this.haveMessages[i] = false;
            }
            ++i;
        }
        if (this.sendChoke) {
            this.sendChoke();
            this.sendChoke = false;
        } else if (this.sendUnchoke) {
            this.sendUnchoke();
            this.sendUnchoke = false;
        }
    }

    private void sendKeepAlive() throws IOException {
        this.sendBuffer.put(KEEP_ALIVE);
        this.sendBuffer.flip();
        this.channel.write(this.sendBuffer);
        this.sendBuffer.clear();
    }

    private void sendInterested() throws IOException {
        if (!this.isInterested) {
            this.sendBuffer.put(INTERESTED);
            this.sendBuffer.flip();
            this.channel.write(this.sendBuffer);
            this.sendBuffer.clear();
            this.isInterested = true;
            TorrentConfiguration.debug("Sent [BT_INTERESTED] message to " + this.ip + ":" + this.port);
        }
    }

    private void sendNotInterested() throws IOException {
        if (this.isInterested) {
            this.sendBuffer.put(NOT_INTERESTED);
            this.sendBuffer.flip();
            this.channel.write(this.sendBuffer);
            this.sendBuffer.clear();
            this.isInterested = false;
            TorrentConfiguration.debug("Sent [BT_NOT_INTERESTED] message to " + this.ip + ":" + this.port);
        }
    }

    private void sendChoke() throws IOException {
        if (!this.isChoking) {
            this.sendBuffer.put(CHOKE);
            this.sendBuffer.flip();
            this.channel.write(this.sendBuffer);
            this.sendBuffer.clear();
            this.isChoking = true;
            TorrentConfiguration.debug("Sent [BT_CHOKE] message to " + this.ip + ":" + this.port);
        }
    }

    private void sendUnchoke() throws IOException {
        if (this.isChoking) {
            this.sendBuffer.put(UNCHOKE);
            this.sendBuffer.flip();
            this.channel.write(this.sendBuffer);
            this.sendBuffer.clear();
            this.isChoking = false;
            TorrentConfiguration.debug("Sent [BT_UNCHOKE] message to " + this.ip + ":" + this.port);
        }
    }

    private void reset() {
        this.queuePosition = 0;
        this.downloaded = 0L;
        this.uploaded = 0L;
        Arrays.fill(this.downloads, 0L);
        Arrays.fill(this.uploads, 0L);
        this.isInterested = false;
        this.isChoking = true;
        this.peerIsInterested = false;
        this.peerIsChoking = true;
        this.peerIsSeed = false;
        Arrays.fill(this.peerPieces, false);
        this.sendChoke = false;
        this.sendUnchoke = false;
        Arrays.fill(this.haveMessages, false);
        this.clientName = "Unknown";
    }

    private void cleanup() {
        this.pool.connectionClosed();
        if (!this.isChoking) {
            this.pool.unchokedPeerCleared();
        }
        this.initialized = false;
    }

    void close() {
        if (this.channel != null) {
            this.reset();
            try {
                this.channel.close();
            }
            catch (IOException iOException) {}
            this.channel = null;
            this.manager.removePieceAvailability(this.peerPieces);
        }
    }

    boolean isChoking() {
        return this.isChoking;
    }

    boolean isConnectedTo(String ip, int port) {
        return port == this.port && ip.equals(this.ip);
    }

    boolean isSeed() {
        return this.peerIsSeed;
    }

    void queueHaveMessage(int number) throws IllegalArgumentException {
        if (number < 0) {
            throw new IllegalArgumentException("The piece number cannot be negative");
        }
        if (number >= this.peerPieces.length) {
            throw new IllegalArgumentException("The piece number is greater than the number of pieces");
        }
        this.haveMessages[number] = true;
    }

    void queueChokeMessage() {
        this.sendUnchoke = true;
    }

    void queueUnchokeMessage() {
        this.sendChoke = true;
    }

    long getDownloaded() {
        return this.downloaded;
    }

    long getUploaded() {
        return this.uploaded;
    }

    double getDownSpeed() {
        double totalDown = 0.0;
        int j = 0;
        while (j < 20) {
            totalDown += (double)this.downloads[j];
            ++j;
        }
        return totalDown / 20.0;
    }

    double getUpSpeed() {
        double totalUp = 0.0;
        int j = 0;
        while (j < 20) {
            totalUp += (double)this.uploads[j];
            ++j;
        }
        return totalUp / 20.0;
    }

    void queueSpeeds() {
        if (this.queuePosition == 20) {
            this.queuePosition = 0;
        }
        this.downloads[this.queuePosition] = this.downloaded - this.lastDownloaded;
        this.uploads[this.queuePosition] = this.uploaded - this.lastUploaded;
        this.lastDownloaded = this.downloaded;
        this.lastUploaded = this.uploaded;
        ++this.queuePosition;
    }

    String getClientName() {
        return this.clientName;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ConnectionInfo info = this.pool.dequeue();
        if (info == null) {
            this.pool.connectionDestroyed(this);
            return;
        }
        try {
            do {
                this.initialized = true;
                if (info.isChannel()) {
                    this.setChannel(info.getChannel());
                } else {
                    this.setAddress(info.getIP(), info.getPort());
                }
                this.pool.connectionCreated();
                this.connect();
                this.cleanup();
                if (!this.pool.isConnected()) {
                    return;
                }
                try {
                    ConnectionPool connectionPool = this.pool;
                    synchronized (connectionPool) {
                        this.pool.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.pool.connectionDestroyed(this);
                    return;
                }
            } while ((info = this.pool.dequeue()) != null);
            this.pool.connectionDestroyed(this);
            return;
        }
        catch (RuntimeException e) {
            this.cleanup();
            this.pool.connectionDestroyed(this);
            throw e;
        }
    }
}

