/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bittorrent.internal.torrent;

class Block {
    private int index;
    private int blockLength;

    Block(int index, int blockLength) {
        this.index = index;
        this.blockLength = blockLength;
    }

    void append(int blockLength) {
        this.blockLength += blockLength;
    }

    void prepend(int blockLength) {
        this.index -= blockLength;
        this.blockLength += blockLength;
    }

    void append(Block other) {
        this.blockLength += other.blockLength;
    }

    void prepend(Block other) {
        this.index -= other.blockLength;
        this.blockLength += other.blockLength;
    }

    boolean isConnectedToStart(Block other) {
        return other.index + other.blockLength == this.index;
    }

    boolean isConnectedToEnd(Block other) {
        return this.index + this.blockLength == other.index;
    }

    boolean isConnectedToStart(int index, int blockLength) {
        return index + blockLength == this.index;
    }

    boolean isConnectedToEnd(int index) {
        return this.index + this.blockLength == index;
    }

    int getIndex() {
        return this.index;
    }

    int getBlockLength() {
        return this.blockLength;
    }

    public String toString() {
        return String.valueOf(this.index) + "-" + (this.index + this.blockLength);
    }
}

