/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bittorrent.internal.torrent;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class DataFile {
    private RandomAccessFile file;
    private int[] pieces;
    private int[] pieceLengths;
    private long length;

    public DataFile(File aFile, long length) throws IOException {
        this.file = new RandomAccessFile(aFile, "rw");
        if (aFile.length() > length) {
            aFile.delete();
        }
        if (aFile.length() != length) {
            this.file.seek(length - 1L);
            this.file.write(0);
        }
        this.length = length;
    }

    public void setPieces(int[] pieces, int initialLength, int length) throws IllegalArgumentException {
        if (pieces.length > 2 && initialLength > length) {
            throw new IllegalArgumentException("The first piece's length cannot be larger than a regular piece's length");
        }
        this.pieces = pieces;
        int numPieces = pieces.length;
        this.pieceLengths = new int[numPieces];
        this.pieceLengths[0] = 0;
        if (numPieces == 1) {
            return;
        }
        this.pieceLengths[1] = initialLength;
        int i = 2;
        while (i < numPieces) {
            this.pieceLengths[i] = this.pieceLengths[i - 1] + length;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] write(int piece, int offset, byte[] block, int[] data) throws IllegalArgumentException, IOException {
        if (offset == -1) {
            return data;
        }
        int index = this.indexOf(piece);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        int seek = this.pieceLengths[index] + offset;
        if ((long)seek >= this.length) {
            throw new IllegalArgumentException("The seeking position cannot be greater than this file's length");
        }
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            this.file.seek(seek);
            if ((long)(seek + data[1]) > this.length) {
                int write = (int)(this.length - (long)seek);
                this.file.write(block, data[0], write);
                data[0] = data[0] + write;
                data[1] = data[1] - write;
                data[2] = write;
                return data;
            }
            this.file.write(block, data[0], data[1]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(int piece) throws IOException {
        int index = this.indexOf(piece);
        if (index == -1) {
            return null;
        }
        int dataLength = -1;
        dataLength = this.pieceLengths.length - 1 == index ? (int)(this.length - (long)this.pieceLengths[index]) : this.pieceLengths[index + 1] - this.pieceLengths[index];
        byte[] data = new byte[dataLength];
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            this.file.seek(this.pieceLengths[index]);
            this.file.read(data, 0, dataLength);
        }
        return data;
    }

    public long length() {
        return this.length;
    }

    public boolean containsPiece(int piece) {
        if (this.pieces.length == 1) {
            return this.pieces[0] == piece;
        }
        return this.pieces[0] <= piece && this.pieces[this.pieces.length - 1] >= piece;
    }

    private int indexOf(int piece) {
        if (!this.containsPiece(piece)) {
            return -1;
        }
        int i = 0;
        while (i < this.pieces.length) {
            if (this.pieces[i] == piece) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public FileChannel getChannel() {
        return this.file.getChannel();
    }

    public int[] getPieces() {
        return this.pieces;
    }
}

