/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.docshare;

import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.AbstractShare;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.events.IChannelDisconnectEvent;
import org.eclipse.ecf.docshare.DocShareEditorInput;
import org.eclipse.ecf.docshare.messages.Message;
import org.eclipse.ecf.docshare.messages.SelectionMessage;
import org.eclipse.ecf.docshare.messages.StartMessage;
import org.eclipse.ecf.docshare.messages.StopMessage;
import org.eclipse.ecf.docshare.messages.UpdateMessage;
import org.eclipse.ecf.internal.docshare.Activator;
import org.eclipse.ecf.internal.docshare.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DocShare
extends AbstractShare {
    ID initiatorID;
    ID receiverID;
    ID ourID;
    ITextEditor editor;
    String startContent = null;
    Object stateLock = new Object();
    IDocumentListener documentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (DocShare.this.getChannel() == null || !Activator.getDefault().isListenerActive()) {
                return;
            }
            if (!Activator.getDefault().isListenerActive()) {
                return;
            }
            DocShare.this.sendUpdateMessage(event);
        }
    };
    static /* synthetic */ Class class$0;

    public DocShare(IChannelContainerAdapter adapter) throws ECFException {
        super(adapter);
    }

    public ID getInitiatorID() {
        return this.initiatorID;
    }

    public ID getReceiverID() {
        return this.receiverID;
    }

    public ID getOurID() {
        return this.ourID;
    }

    public ITextEditor getTextEditor() {
        return this.editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSharing() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.editor != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ID getOtherID() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isInitiator()) {
                return this.receiverID;
            }
            return this.initiatorID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitiator() {
        Object object = this.stateLock;
        synchronized (object) {
            block4: {
                if (this.ourID != null && this.initiatorID != null && this.receiverID != null) break block4;
                return false;
            }
            return this.ourID.equals((Object)this.initiatorID);
        }
    }

    public void startShare(final ID our, String fromName, final ID toID, final String fileName, final ITextEditor editorPart) {
        Assert.isNotNull((Object)our);
        final String fName = fromName == null ? our.getName() : fromName;
        Assert.isNotNull((Object)toID);
        Assert.isNotNull((Object)fName);
        Assert.isNotNull((Object)editorPart);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    String content = editorPart.getDocumentProvider().getDocument((Object)editorPart.getEditorInput()).get();
                    DocShare.this.send(toID, new StartMessage(our, fName, toID, content, fileName));
                    DocShare.this.localStartShare(our, our, toID, editorPart);
                }
                catch (Exception e) {
                    DocShare.this.logError(Messages.DocShare_ERROR_STARTING_EDITOR_TITLE, e);
                    DocShare.this.showErrorToUser(Messages.DocShare_ERROR_STARTING_EDITOR_TITLE, NLS.bind((String)Messages.DocShare_ERROR_STARTING_EDITOR_MESSAGE, (Object)e.getLocalizedMessage()));
                }
            }
        });
    }

    public void stopShare() {
        if (this.isSharing()) {
            this.sendStopMessage();
        }
        this.localStopShare();
    }

    public void sendSelection() {
        ISelectionProvider selectionProvider;
        ISelection selection;
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor != null && (selection = (selectionProvider = textEditor.getSelectionProvider()).getSelection()) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            try {
                this.send(this.getOtherID(), new SelectionMessage(textSelection.getOffset(), textSelection.getLength(), textSelection.getStartLine(), textSelection.getEndLine()));
            }
            catch (Exception e) {
                this.logError(Messages.DocShare_SELECTION_SEND_ERROR_TITLE, e);
                this.showErrorToUser(Messages.DocShare_SELECTION_SEND_ERROR_TITLE, Messages.DocShare_SELECTION_SEND_ERROR_MESSAGE);
            }
        }
    }

    protected void handleSelectionMessage(final SelectionMessage selectionMessage) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ITextEditor textEditor = DocShare.this.getTextEditor();
                if (textEditor != null) {
                    textEditor.selectAndReveal(selectionMessage.getOffset(), selectionMessage.getLength());
                }
            }
        });
    }

    void send(ID toID, Message message) throws Exception {
        super.sendMessage(toID, message.serialize());
    }

    protected void handleMessage(ID fromContainerID, byte[] data) {
        block6: {
            try {
                Message message = Message.deserialize(data);
                Assert.isNotNull((Object)message);
                if (message instanceof StartMessage) {
                    this.handleStartMessage((StartMessage)message);
                    break block6;
                }
                if (message instanceof UpdateMessage) {
                    this.handleUpdateMessage((UpdateMessage)message);
                    break block6;
                }
                if (message instanceof StopMessage) {
                    this.handleStopMessage((StopMessage)message);
                    break block6;
                }
                if (message instanceof SelectionMessage) {
                    this.handleSelectionMessage((SelectionMessage)message);
                    break block6;
                }
                throw new InvalidObjectException(NLS.bind((String)Messages.DocShare_EXCEPTION_INVALID_MESSAGE, (Object)message.getClass().getName()));
            }
            catch (Exception e) {
                this.logError(Messages.DocShare_EXCEPTION_HANDLE_MESSAGE, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStartMessage(StartMessage message) {
        final ID senderID = message.getSenderID();
        Assert.isNotNull((Object)senderID);
        final String senderUsername = message.getSenderUsername();
        Assert.isNotNull((Object)senderUsername);
        final ID our = message.getReceiverID();
        Assert.isNotNull((Object)our);
        final String filename = message.getFilename();
        Assert.isNotNull((Object)filename);
        String documentContent = message.getDocumentContent();
        Assert.isNotNull((Object)documentContent);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isSharing() || this.startContent != null) {
                this.sendStopMessage(senderID);
                return;
            }
            this.startContent = documentContent;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (DocShare.this.openReceiverDialog(senderID, senderUsername, filename)) {
                        DocShareEditorInput dsei = new DocShareEditorInput(DocShare.this.getTempFileStore(senderUsername, filename, DocShare.this.startContent), senderUsername, filename);
                        ITextEditor ep = (ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)dsei, DocShare.this.getEditorIdForFileName(filename));
                        DocShare.this.localStartShare(our, senderID, our, ep);
                    } else {
                        DocShare.this.sendStopMessage();
                        DocShare.this.localStopShare();
                    }
                }
                catch (Exception e) {
                    DocShare.this.logError(Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_TITLE, e);
                    DocShare.this.showErrorToUser(Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_TITLE, NLS.bind((String)Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_MESSAGE, (Object)e.getLocalizedMessage()));
                }
            }
        });
    }

    void modifyStartContent(int offset, int length, String text) {
        StringBuffer result = new StringBuffer(this.startContent.substring(0, offset));
        result.append(text);
        result.append(this.startContent.substring(offset + length));
        this.startContent = result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateMessage(UpdateMessage message) {
        final int offset = message.getOffset();
        Assert.isTrue((offset > -1 ? 1 : 0) != 0);
        final int length = message.getLength();
        Assert.isTrue((length > -1 ? 1 : 0) != 0);
        final String text = message.getText();
        Assert.isTrue((text != null ? 1 : 0) != 0);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.startContent != null) {
                this.modifyStartContent(offset, length, text);
                return;
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        IDocument document = DocShare.this.getDocumentFromEditor();
                        if (document != null) {
                            DocShare.this.setEditorToRefuseInput();
                            document.replace(offset, length, text);
                        }
                    }
                    catch (Exception e) {
                        DocShare.this.logError(Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_TITLE, e);
                        DocShare.this.showErrorToUser(Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_TITLE, NLS.bind((String)Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_MESSAGE, (Object)e.getLocalizedMessage()));
                    }
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    DocShare.this.setEditorToAcceptInput();
                    throw throwable;
                }
                {
                    Object var2_5 = null;
                    DocShare.this.setEditorToAcceptInput();
                    return;
                }
            }
        });
    }

    protected void handleStopMessage(StopMessage message) {
        if (this.isSharing()) {
            this.localStopShare();
        }
    }

    void setEditorToRefuseInput() {
        this.setEditorEditable(false);
        Activator.getDefault().setListenerActive(false);
    }

    void setEditorToAcceptInput() {
        this.setEditorEditable(true);
        Activator.getDefault().setListenerActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IEditorInput getEditorInput() {
        Object object = this.stateLock;
        synchronized (object) {
            block4: {
                if (this.editor != null) break block4;
                return null;
            }
            return this.editor.getEditorInput();
        }
    }

    boolean openReceiverDialog(ID fromID, String fromUsername, String fileName) {
        return MessageDialog.openQuestion(null, (String)Messages.DocShare_EDITOR_SHARE_POPUP_TITLE, (String)NLS.bind((String)Messages.DocShare_EDITOR_SHARE_POPUP_MESSAGE, (Object)fromUsername, (Object)fileName));
    }

    protected void handleDisconnectEvent(IChannelDisconnectEvent cde) {
        super.handleDisconnectEvent(cde);
        this.localStopShare();
    }

    IFileStore getTempFileStore(String fromUsername, String fileName, String content) throws IOException, CoreException {
        IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(File.createTempFile(fromUsername, fileName));
        OutputStream outs = fileStore.openOutputStream(2, null);
        outs.write(content.getBytes());
        outs.close();
        return fileStore;
    }

    public synchronized void dispose() {
        this.localStopShare();
        super.dispose();
    }

    void logError(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    void showErrorToUser(String title, String message) {
        MessageDialog.openError(null, (String)title, (String)message);
    }

    void logError(String exceptionString, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.docshare", 4, exceptionString, e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StyledText getTextControl() {
        Object object = this.stateLock;
        synchronized (object) {
            block7: {
                if (this.editor != null) break block7;
                return null;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Control");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (StyledText)this.editor.getAdapter((Class)clazz);
        }
    }

    void setEditorEditable(final boolean editable) {
        final StyledText textControl = this.getTextControl();
        if (textControl != null && !textControl.isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    textControl.setEditable(editable);
                }
            });
        }
    }

    String getEditorIdForFileName(String fileName) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IEditorRegistry er = wb.getEditorRegistry();
        IEditorDescriptor desc = er.getDefaultEditor(fileName);
        if (desc != null) {
            return desc.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDocument getDocumentFromEditor() {
        Object object = this.stateLock;
        synchronized (object) {
            IDocumentProvider documentProvider;
            block6: {
                block5: {
                    if (this.editor != null) break block5;
                    return null;
                }
                documentProvider = this.editor.getDocumentProvider();
                if (documentProvider != null) break block6;
                return null;
            }
            return documentProvider.getDocument((Object)this.editor.getEditorInput());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void localStartShare(ID our, ID initiator, ID receiver, ITextEditor edt) {
        Object object = this.stateLock;
        synchronized (object) {
            this.localStopShare();
            this.ourID = our;
            this.initiatorID = initiator;
            this.receiverID = receiver;
            this.editor = edt;
            IDocument doc = this.getDocumentFromEditor();
            if (doc != null) {
                doc.addDocumentListener(this.documentListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void localStopShare() {
        Object object = this.stateLock;
        synchronized (object) {
            this.ourID = null;
            this.initiatorID = null;
            this.receiverID = null;
            this.startContent = null;
            IDocument doc = this.getDocumentFromEditor();
            if (doc != null) {
                doc.removeDocumentListener(this.documentListener);
            }
            this.editor = null;
        }
    }

    void sendUpdateMessage(DocumentEvent event) {
        if (this.isSharing()) {
            try {
                this.send(this.getOtherID(), new UpdateMessage(event.getOffset(), event.getLength(), event.getText()));
            }
            catch (Exception e) {
                this.logError(Messages.DocShare_EXCEPTION_SEND_MESSAGE, e);
            }
        }
    }

    void sendStopMessage() {
        this.sendStopMessage(this.getOtherID());
    }

    void sendStopMessage(ID other) {
        if (this.isSharing()) {
            try {
                this.send(other, new StopMessage());
            }
            catch (Exception e) {
                this.logError(Messages.DocShare_EXCEPTION_SEND_MESSAGE, e);
            }
        }
    }
}

